/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.client.scissor.ClosingScissorBox;
import com.teamresourceful.resourcefullib.client.utils.RenderUtils;
import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.client.components.LabeledImageButton;
import earth.terrarium.adastra.client.utils.DimensionRenderingUtils;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.constants.PlanetConstants;
import earth.terrarium.adastra.common.entities.vehicles.Rocket;
import earth.terrarium.adastra.common.handlers.base.SpaceStation;
import earth.terrarium.adastra.common.menus.PlanetsMenu;
import earth.terrarium.adastra.common.network.NetworkHandler;
import earth.terrarium.adastra.common.network.messages.ServerboundLandOnSpaceStationPacket;
import earth.terrarium.adastra.common.network.messages.ServerboundLandPacket;
import earth.terrarium.adastra.common.planets.AdAstraData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_7919;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;

public class PlanetsScreen
extends class_465<PlanetsMenu> {
    public static final class_2960 BUTTON = new class_2960("ad_astra", "textures/gui/sprites/planets/button.png");
    public static final class_2960 BACK_BUTTON = new class_2960("ad_astra", "textures/gui/sprites/planets/back_button.png");
    public static final class_2960 PLUS_BUTTON = new class_2960("ad_astra", "textures/gui/sprites/planets/plus_button.png");
    public static final class_2960 SELECTION_MENU = new class_2960("ad_astra", "textures/gui/sprites/planets/selection_menu.png");
    public static final class_2960 SMALL_SELECTION_MENU = new class_2960("ad_astra", "textures/gui/sprites/planets/small_selection_menu.png");
    private final List<class_4185> buttons = new ArrayList<class_4185>();
    private class_4185 backButton;
    private double scrollAmount;
    private final List<class_4185> spaceStationButtons = new ArrayList<class_4185>();
    private class_4185 addSpaceStatonButton;
    private double spaceStationScrollAmount;
    private final boolean hasMultipleSolarSystems;
    private int pageIndex;
    @Nullable
    private class_2960 selectedSolarSystem = PlanetConstants.SOLAR_SYSTEM;
    @Nullable
    private Planet selectedPlanet;

    public PlanetsScreen(PlanetsMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        this.field_2792 = this.field_22789;
        this.field_2779 = this.field_22790;
        List<Planet> planets = AdAstraData.planets().values().stream().filter(planet -> !menu.disabledPlanets().contains(planet.dimension().method_29177())).filter(planet -> menu.tier() >= planet.tier()).toList();
        this.hasMultipleSolarSystems = planets.stream().map(Planet::solarSystem).distinct().count() > 1L;
        this.pageIndex = this.hasMultipleSolarSystems ? 0 : 1;
    }

    protected void method_25426() {
        super.method_25426();
        this.buttons.clear();
        this.spaceStationButtons.clear();
        this.spaceStationScrollAmount = 0.0;
        switch (this.pageIndex) {
            case 0: {
                this.createSolarSystemButtons();
                break;
            }
            case 1: 
            case 2: {
                this.createPlanetButtons();
                if (this.pageIndex != 2 || this.selectedPlanet == null) break;
                this.createSelectedPlanetButtons();
            }
        }
        this.backButton = (class_4185)this.method_37063((class_364)new LabeledImageButton(10, this.field_22790 / 2 - 85, 12, 12, 0, 12, 12, BACK_BUTTON, 12, 24, b -> {
            --this.pageIndex;
            this.method_41843();
        }));
        this.addSpaceStatonButton = (class_4185)this.method_37063((class_364)new LabeledImageButton(114, this.field_22790 / 2 - 41, 12, 12, 0, 12, 12, PLUS_BUTTON, 12, 24, b -> {
            if (this.selectedPlanet != null) {
                int ownedSpaceStationCount = ((PlanetsMenu)this.field_2797).getOwnedAndTeamSpaceStations(this.selectedPlanet.orbitIfPresent()).size();
                class_5250 name = class_2561.method_43469((String)"text.ad_astra.text.space_station_name", (Object[])new Object[]{ownedSpaceStationCount + 1});
                ((PlanetsMenu)this.field_2797).constructSpaceStation(this.selectedPlanet.dimension(), (class_2561)name);
                this.close();
            }
        }));
        if (this.selectedPlanet != null) {
            this.addSpaceStatonButton.method_47400(this.getSpaceStationRecipeTooltip(this.selectedPlanet.orbitIfPresent()));
            this.addSpaceStatonButton.field_22763 = this.selectedPlanet != null && ((PlanetsMenu)this.field_2797).canConstruct(this.selectedPlanet.orbitIfPresent()) && !((PlanetsMenu)this.field_2797).isInSpaceStation(this.selectedPlanet.orbitIfPresent());
        }
        this.backButton.field_22764 = this.pageIndex > (this.hasMultipleSolarSystems ? 0 : 1);
        this.addSpaceStatonButton.field_22764 = this.pageIndex == 2 && this.selectedPlanet != null;
    }

    private void createSolarSystemButtons() {
        this.selectedSolarSystem = null;
        AdAstraData.solarSystems().forEach(solarSystem -> {
            LabeledImageButton button = (LabeledImageButton)this.method_25429((class_364)new LabeledImageButton(10, 0, 99, 20, 0, 0, 20, BUTTON, 99, 40, b -> {
                this.pageIndex = 1;
                this.selectedSolarSystem = solarSystem;
                this.method_41843();
            }, (class_2561)class_2561.method_48321((String)"solar_system.%s.%s".formatted(solarSystem.method_12836(), solarSystem.method_12832()), (String)this.title(solarSystem.method_12832()))));
            this.buttons.add((class_4185)button);
        });
    }

    private void createPlanetButtons() {
        for (Planet planet : ((PlanetsMenu)this.field_2797).getSortedPlanets()) {
            if (planet.isSpace() || ((PlanetsMenu)this.field_2797).tier() < planet.tier() || !planet.solarSystem().equals((Object)this.selectedSolarSystem)) continue;
            this.buttons.add((class_4185)this.method_25429((class_364)new LabeledImageButton(10, 0, 99, 20, 0, 0, 20, BUTTON, 99, 40, b -> {
                this.pageIndex = 2;
                this.selectedPlanet = planet;
                this.method_41843();
            }, ((PlanetsMenu)this.field_2797).getPlanetName(planet.dimension()))));
        }
    }

    private void createSelectedPlanetButtons() {
        if (this.selectedPlanet == null) {
            return;
        }
        class_2338 pos = ((PlanetsMenu)this.field_2797).getLandingPos(this.selectedPlanet.dimension(), true);
        LabeledImageButton button = (LabeledImageButton)this.method_37063((class_364)new LabeledImageButton(114, this.field_22790 / 2 - 77, 99, 20, 0, 0, 20, BUTTON, 99, 40, b -> this.land(this.selectedPlanet.dimension()), ConstantComponents.LAND));
        button.method_47400(class_7919.method_47407((class_2561)class_2561.method_43469((String)"tooltip.ad_astra.land", (Object[])new Object[]{((PlanetsMenu)this.field_2797).getPlanetName(this.selectedPlanet.dimension()), pos.method_10263(), pos.method_10260()}).method_27692(class_124.field_1075)));
        this.addSpaceStationButtons(this.selectedPlanet.orbitIfPresent());
    }

    private void addSpaceStationButtons(class_5321<class_1937> dimension) {
        ((PlanetsMenu)this.field_2797).getOwnedAndTeamSpaceStations(dimension).forEach(station -> {
            class_1923 pos = ((SpaceStation)station.getSecond()).position();
            LabeledImageButton button = (LabeledImageButton)this.method_25429((class_364)new LabeledImageButton(114, this.field_22790 / 2, 99, 20, 0, 0, 20, BUTTON, 99, 40, b -> this.landOnSpaceStation(dimension, pos), ((SpaceStation)station.getSecond()).name()));
            button.method_47400(this.getSpaceStationLandTooltip(dimension, pos, (String)station.getFirst()));
            this.spaceStationButtons.add((class_4185)button);
        });
    }

    public class_7919 getSpaceStationLandTooltip(class_5321<class_1937> dimension, class_1923 pos, String owner) {
        return class_7919.method_47407((class_2561)class_5244.method_37110((class_2561[])new class_2561[]{class_2561.method_43469((String)"tooltip.ad_astra.space_station_land", (Object[])new Object[]{((PlanetsMenu)this.field_2797).getPlanetName(dimension), pos.method_33940(), pos.method_33942()}).method_27692(class_124.field_1075), class_2561.method_43469((String)"tooltip.ad_astra.space_station_owner", (Object[])new Object[]{owner}).method_27692(class_124.field_1065)}));
    }

    public class_7919 getSpaceStationRecipeTooltip(class_5321<class_1937> planet) {
        ArrayList<Object> tooltip = new ArrayList<Object>();
        class_2338 pos = ((PlanetsMenu)this.field_2797).getLandingPos(planet, false);
        tooltip.add(class_2561.method_43469((String)"tooltip.ad_astra.construct_space_station_at", (Object[])new Object[]{((PlanetsMenu)this.field_2797).getPlanetName(planet), pos.method_10263(), pos.method_10260()}).method_27692(class_124.field_1075));
        if (((PlanetsMenu)this.field_2797).isInSpaceStation(planet) || ((PlanetsMenu)this.field_2797).isClaimed(planet)) {
            tooltip.add(ConstantComponents.SPACE_STATION_ALREADY_EXISTS);
            return class_7919.method_47407((class_2561)class_5244.method_37109(tooltip));
        }
        tooltip.add(ConstantComponents.CONSTRUCTION_COST.method_27661().method_27692(class_124.field_1075));
        List<Pair<class_1799, Integer>> ingredients = ((PlanetsMenu)this.field_2797).ingredients().get(planet);
        if (ingredients == null) {
            return class_7919.method_47407((class_2561)class_5244.method_37109(tooltip));
        }
        for (Pair<class_1799, Integer> ingredient : ingredients) {
            class_1799 stack = (class_1799)ingredient.getFirst();
            int amountOwned = (Integer)ingredient.getSecond();
            boolean hasEnough = ((PlanetsMenu)this.field_2797).player().method_7337() || ((PlanetsMenu)this.field_2797).player().method_7325() || amountOwned >= stack.method_7947();
            tooltip.add(class_2561.method_43469((String)"tooltip.ad_astra.requirement", (Object[])new Object[]{amountOwned, stack.method_7947(), stack.method_7964().method_27661().method_27692(class_124.field_1062)}).method_27661().method_27692(hasEnough ? class_124.field_1060 : class_124.field_1061));
        }
        return class_7919.method_47407((class_2561)class_5244.method_37109(tooltip));
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        this.renderButtons(graphics, mouseX, mouseY, partialTick);
        this.backButton.field_22764 = this.pageIndex > (this.hasMultipleSolarSystems ? 0 : 1);
        this.addSpaceStatonButton.field_22764 = this.pageIndex == 2 && this.selectedPlanet != null;
    }

    /*
     * WARNING - void declaration
     */
    private void renderButtons(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        int scrollPixels = (int)this.scrollAmount;
        try (ClosingScissorBox ignored = RenderUtils.createScissorBox((class_310)class_310.method_1551(), (class_4587)graphics.method_51448(), (int)0, (int)(this.field_22790 / 2 - 43), (int)112, (int)131);){
            for (class_4185 class_41852 : this.buttons) {
                class_41852.method_25394(graphics, mouseX, mouseY, partialTick);
            }
            for (int i = 0; i < this.buttons.size(); ++i) {
                class_4185 class_41853 = this.buttons.get(i);
                class_41853.method_46419(i * 24 - scrollPixels + (this.field_22790 / 2 - 41));
            }
        }
        if (this.pageIndex == 2 && this.selectedPlanet != null) {
            int spaceStationScrollPixels = (int)this.spaceStationScrollAmount;
            try (ClosingScissorBox ignored = RenderUtils.createScissorBox((class_310)class_310.method_1551(), (class_4587)graphics.method_51448(), (int)112, (int)(this.field_22790 / 2 - 2), (int)112, (int)90);){
                void var8_18;
                for (class_4185 button : this.spaceStationButtons) {
                    button.method_25394(graphics, mouseX, mouseY, partialTick);
                }
                boolean bl = false;
                while (var8_18 < this.spaceStationButtons.size()) {
                    class_4185 button;
                    button = this.spaceStationButtons.get((int)var8_18);
                    button.method_46419((int)(var8_18 * 24 - spaceStationScrollPixels + this.field_22790 / 2));
                    ++var8_18;
                }
            }
        }
    }

    protected void method_2389(class_332 graphics, float partialTick, int mouseX, int mouseY) {
        if (this.pageIndex == 2) {
            graphics.method_25290(SELECTION_MENU, 7, this.field_22790 / 2 - 88, 0.0f, 0.0f, 209, 177, 209, 177);
            graphics.method_27534(this.field_22793, ConstantComponents.SPACE_STATION, 163, this.field_22790 / 2 - 15, 0xFFFFFF);
        } else {
            graphics.method_25290(SMALL_SELECTION_MENU, 7, this.field_22790 / 2 - 88, 0.0f, 0.0f, 105, 177, 105, 177);
        }
        if (this.pageIndex == 2 && this.selectedPlanet != null) {
            class_5250 title = class_2561.method_48321((String)"planet.%s.%s".formatted(this.selectedPlanet.dimension().method_29177().method_12836(), this.selectedPlanet.dimension().method_29177().method_12832()), (String)this.title(this.selectedPlanet.dimension().method_29177().method_12832()));
            graphics.method_27534(this.field_22793, (class_2561)title, 57, this.field_22790 / 2 - 60, 0xFFFFFF);
        } else if (this.pageIndex == 1 && this.selectedSolarSystem != null) {
            class_5250 title = class_2561.method_48321((String)"solar_system.%s.%s".formatted(this.selectedSolarSystem.method_12836(), this.selectedSolarSystem.method_12832()), (String)this.title(this.selectedSolarSystem.method_12832()));
            graphics.method_27534(this.field_22793, (class_2561)title, 57, this.field_22790 / 2 - 60, 0xFFFFFF);
        } else {
            graphics.method_27534(this.field_22793, ConstantComponents.CATALOG, 57, this.field_22790 / 2 - 60, 0xFFFFFF);
        }
    }

    public void method_25420(class_332 graphics) {
        int i;
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, -16776167);
        RenderSystem.setShader(class_757::method_34535);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        for (i = -this.field_22790; i <= this.field_22789; i += 24) {
            bufferBuilder.method_22912((double)i, 0.0, 0.0).method_39415(-15784615).method_1344();
            bufferBuilder.method_22912((double)(i + this.field_22790), (double)this.field_22790, 0.0).method_39415(-15784615).method_1344();
        }
        for (i = this.field_22789 + this.field_22790; i >= 0; i -= 24) {
            bufferBuilder.method_22912((double)i, 0.0, 0.0).method_39415(-15784615).method_1344();
            bufferBuilder.method_22912((double)(i - this.field_22790), (double)this.field_22790, 0.0).method_39415(-15784615).method_1344();
        }
        if (PlanetConstants.PROXIMA_CENTAURI.equals((Object)this.selectedSolarSystem)) {
            this.drawCircles(1, 1, -16744320, bufferBuilder);
        } else if (PlanetConstants.SOLAR_SYSTEM.equals((Object)this.selectedSolarSystem)) {
            this.drawCircles(0, 4, -14404997, bufferBuilder);
        }
        tessellator.method_1350();
        if (PlanetConstants.PROXIMA_CENTAURI.equals((Object)this.selectedSolarSystem)) {
            this.renderProximaCentauri(graphics);
        } else if (PlanetConstants.SOLAR_SYSTEM.equals((Object)this.selectedSolarSystem)) {
            this.renderSolarSystem(graphics);
        }
    }

    public void renderSolarSystem(class_332 graphics) {
        graphics.method_25290(DimensionRenderingUtils.SUN, this.field_22789 / 2 - 8, this.field_22790 / 2 - 8, 0.0f, 0.0f, 16, 16, 16, 16);
        float yRot = (float)class_156.method_658() / 100.0f;
        for (int i = 1; i < 5; ++i) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f, 0.0f);
            graphics.method_51448().method_22907(class_7833.field_40718.rotationDegrees(yRot * (float)(5 - i) / 2.0f));
            graphics.method_51448().method_46416((float)(31 * i - 10), 0.0f, 0.0f);
            graphics.method_25290(DimensionRenderingUtils.SOLAR_SYSTEM_TEXTURES.get(i - 1), 0, 0, 0.0f, 0.0f, 12, 12, 12, 12);
            graphics.method_51448().method_22909();
        }
    }

    public void renderProximaCentauri(class_332 graphics) {
        graphics.method_25290(DimensionRenderingUtils.BLUE_SUN, this.field_22789 / 2 - 8, this.field_22790 / 2 - 8, 0.0f, 0.0f, 16, 16, 16, 16);
        float yRot = (float)class_156.method_658() / 100.0f % 360.0f;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f, 0.0f);
        graphics.method_51448().method_22907(class_7833.field_40718.rotationDegrees(yRot));
        graphics.method_51448().method_46416(53.0f, 0.0f, 0.0f);
        graphics.method_25290(DimensionRenderingUtils.GLACIO, 0, 0, 0.0f, 0.0f, 12, 12, 12, 12);
        graphics.method_51448().method_22909();
    }

    public void drawCircles(int start, int count, int color, class_287 bufferBuilder) {
        for (int i = 1 + start; i < count + start + 1; ++i) {
            PlanetsScreen.drawCircle(bufferBuilder, (float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f, 30 * i, 75, color);
        }
    }

    public static void drawCircle(class_287 bufferBuilder, double x, double y, double radius, int sides, int color) {
        for (double r = radius - 0.5; r <= radius + 0.5; r += 0.1) {
            for (int i = 0; i < sides; ++i) {
                double angle = (double)i * 2.0 * Math.PI / (double)sides;
                double nextAngle = (double)(i + 1) * 2.0 * Math.PI / (double)sides;
                double x1 = x + r * Math.cos(angle);
                double y1 = y + r * Math.sin(angle);
                double x2 = x + r * Math.cos(nextAngle);
                double y2 = y + r * Math.sin(nextAngle);
                bufferBuilder.method_22912(x1, y1, 0.0).method_39415(color).method_1344();
                bufferBuilder.method_22912(x2, y2, 0.0).method_39415(color).method_1344();
            }
        }
    }

    public boolean method_25421() {
        return true;
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (mouseX < 112.0 && mouseX > 6.0 && mouseY > (double)((float)this.field_22790 / 2.0f - 43.0f) && mouseY < (double)((float)this.field_22790 / 2.0f + 88.0f)) {
            this.setScrollAmount(this.scrollAmount - delta * 16.0 / 2.0);
        } else if (mouseX > 112.0 && mouseX < 224.0 && mouseY > (double)((float)this.field_22790 / 2.0f - 2.0f) && mouseY < (double)((float)this.field_22790 / 2.0f + 88.0f)) {
            this.setSpaceStationScrollAmount(this.spaceStationScrollAmount - delta * 16.0 / 2.0);
        }
        return true;
    }

    public void method_25419() {
        if (this.pageIndex > 0) {
            --this.pageIndex;
            this.method_41843();
            return;
        }
        class_1657 player = ((PlanetsMenu)this.field_2797).player();
        if (player.method_7337() || player.method_7325()) {
            super.method_25419();
        } else if (!(player.method_5854() instanceof Rocket)) {
            super.method_25419();
        }
    }

    protected void close() {
        this.pageIndex = 0;
        this.method_25419();
    }

    protected void setScrollAmount(double amount) {
        this.scrollAmount = class_3532.method_15350((double)amount, (double)0.0, (double)Math.max(0, this.buttons.size() * 24 - 131));
    }

    protected void setSpaceStationScrollAmount(double amount) {
        this.spaceStationScrollAmount = class_3532.method_15350((double)amount, (double)0.0, (double)Math.max(0, this.spaceStationButtons.size() * 24 - 90));
    }

    public void land(class_5321<class_1937> dimension) {
        NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundLandPacket(dimension, true));
        this.close();
    }

    public void landOnSpaceStation(class_5321<class_1937> dimension, class_1923 pos) {
        NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundLandOnSpaceStationPacket(dimension, pos));
        this.close();
    }

    private String title(String string) {
        return WordUtils.capitalizeFully((String)string.replace("_", " "));
    }
}

