/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.entities.vehicles;

import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.adastra.api.systems.GravityApi;
import earth.terrarium.adastra.common.container.VehicleContainer;
import earth.terrarium.adastra.common.entities.multipart.MultipartEntity;
import earth.terrarium.adastra.common.entities.multipart.MultipartPartEntity;
import earth.terrarium.adastra.common.entities.vehicles.VehiclePart;
import earth.terrarium.adastra.common.network.NetworkHandler;
import earth.terrarium.adastra.common.network.messages.ServerboundVehicleControlPacket;
import earth.terrarium.adastra.mixins.common.LivingEntityAccessor;
import earth.terrarium.botarium.common.menu.ExtraDataMenuProvider;
import earth.terrarium.botarium.common.menu.MenuHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2604;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_6026;
import net.minecraft.class_7248;
import net.minecraft.class_8103;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public abstract class Vehicle
extends class_1297
implements class_6026,
ExtraDataMenuProvider,
MultipartEntity,
class_7248 {
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private float xxa;
    private float zza;
    protected final VehicleContainer inventory = new VehicleContainer(this.getInventorySize());
    protected final List<VehiclePart> parts = new ArrayList<VehiclePart>();
    private final List<MultipartPartEntity<?>> multipartParts = new ArrayList();

    public Vehicle(class_1299<?> type, class_1937 level) {
        super(type, level);
    }

    protected void addPart(float width, float height, Vector3f offset, BiFunction<class_1657, class_1268, class_1269> handler) {
        VehiclePart part = new VehiclePart(this, width, height, offset, handler);
        this.parts.add(part);
        this.multipartParts.add(part);
    }

    protected void method_5693() {
    }

    protected void method_5749(class_2487 compound) {
        this.inventory.method_7659(compound.method_10554("Inventory", 10));
    }

    protected void method_5652(class_2487 compound) {
        compound.method_10566("Inventory", (class_2520)this.inventory.method_7660());
    }

    public boolean method_30949(class_1297 entity) {
        return class_1690.method_30959((class_1297)this, (class_1297)entity);
    }

    public boolean method_30948() {
        return true;
    }

    public void method_5759(double x, double y, double z, float yRot, float xRot, int lerpSteps, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yRot;
        this.lerpXRot = xRot;
        this.lerpSteps = lerpSteps;
    }

    public void method_5773() {
        super.method_5773();
        this.tickLerp();
        if (!this.method_5740()) {
            this.tickGravity();
        }
        this.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
        if (this.method_5787()) {
            class_1309 class_13092;
            if (this.method_37908().method_8608() && this.method_5782() && (class_13092 = this.method_5642()) instanceof class_1657) {
                class_1657 player = (class_1657)class_13092;
                NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundVehicleControlPacket(player.field_6212, player.field_6250));
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.tickFriction();
        }
        for (VehiclePart part : this.parts) {
            part.tickPart();
        }
    }

    public void tickLerp() {
        if (this.method_5787()) {
            this.lerpSteps = 0;
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
        }
        if (this.lerpSteps > 0) {
            double x = this.method_23317() + (this.lerpX - this.method_23317()) / (double)this.lerpSteps;
            double y = this.method_23318() + (this.lerpY - this.method_23318()) / (double)this.lerpSteps;
            double z = this.method_23321() + (this.lerpZ - this.method_23321()) / (double)this.lerpSteps;
            double g = class_3532.method_15338((double)(this.lerpYRot - (double)this.method_36454()));
            this.method_36456(this.method_36454() + (float)g / (float)this.lerpSteps);
            this.method_36457(this.method_36455() + (float)(this.lerpXRot - (double)this.method_36455()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.method_5814(x, y, z);
            this.method_5710(this.method_36454(), this.method_36455());
        }
    }

    public void tickGravity() {
        class_243 velocity = this.method_18798();
        double gravity = 0.05 * (double)GravityApi.API.getGravity(this);
        this.method_18800(velocity.field_1352, velocity.field_1351 - gravity, velocity.field_1350);
    }

    public void tickFriction() {
        float friction = this.method_37908().method_8320(this.method_23314()).method_26204().method_9499();
        float speed = this.method_24828() ? friction * 0.91f : 0.91f;
        class_243 deltaMovement = this.method_18798();
        this.method_18800(deltaMovement.field_1352 * (double)speed, deltaMovement.field_1351, deltaMovement.field_1350 * (double)speed);
    }

    @Nullable
    public class_1309 method_5642() {
        class_1309 e;
        class_1297 class_12972 = this.method_31483();
        return class_12972 instanceof class_1309 ? (e = (class_1309)class_12972) : null;
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1657 player;
        class_1297 class_12972;
        if (this.method_5679(source)) {
            return false;
        }
        if (source.method_48789(class_8103.field_42247)) {
            return false;
        }
        if (amount >= 0.0f && (class_12972 = source.method_5529()) instanceof class_1657 && ((player = (class_1657)class_12972).method_5854() == null || !player.method_5854().equals((Object)this))) {
            this.method_43077(class_3417.field_21919);
            if (!player.method_31549().field_7477) {
                this.drop();
            }
            this.method_31472();
            return true;
        }
        return false;
    }

    public void drop() {
        class_1264.method_5449((class_1937)this.method_37908(), (double)this.method_23317(), (double)this.method_23318(), (double)this.method_23321(), (class_1799)this.getDropStack());
        if (this.inventory.method_5439() > 0) {
            class_1264.method_5451((class_1937)this.method_37908(), (class_2338)this.method_24515(), (class_1263)this.inventory);
        }
    }

    public abstract class_1799 getDropStack();

    @NotNull
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!this.method_37908().method_8608()) {
            if (player.method_21823()) {
                this.method_6722(player);
                return class_1269.field_5812;
            }
            return player.method_5804((class_1297)this) ? class_1269.field_21466 : class_1269.field_5811;
        }
        return class_1269.field_5812;
    }

    public void method_6722(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            MenuHooks.openMenu((class_3222)serverPlayer, (ExtraDataMenuProvider)this);
        }
    }

    public void updateInput(float xxa, float zza) {
        this.xxa = xxa;
        this.zza = zza;
    }

    public abstract int getInventorySize();

    public boolean shouldSit() {
        return true;
    }

    public boolean hideRider() {
        return false;
    }

    public boolean zoomOutCameraInThirdPerson() {
        return false;
    }

    public boolean isSafeToDismount(class_1657 player) {
        return true;
    }

    public float xxa() {
        class_1309 controllingPassenger = this.method_5642();
        if (controllingPassenger == null) {
            return 0.0f;
        }
        return this.method_37908().method_8608() ? controllingPassenger.field_6212 : this.xxa;
    }

    public float zza() {
        class_1309 controllingPassenger = this.method_5642();
        if (controllingPassenger == null) {
            return 0.0f;
        }
        return this.method_37908().method_8608() ? controllingPassenger.field_6250 : this.zza;
    }

    public boolean passengerHasSpaceDown() {
        class_1309 controllingPassenger = this.method_5642();
        if (!(controllingPassenger instanceof LivingEntityAccessor)) {
            return false;
        }
        LivingEntityAccessor entity = (LivingEntityAccessor)controllingPassenger;
        return entity.isJumping();
    }

    public VehicleContainer inventory() {
        return this.inventory;
    }

    public void writeExtraData(class_3222 player, class_2540 buffer) {
        buffer.method_10804(this.method_5628());
    }

    @Override
    public List<MultipartPartEntity<?>> getParts() {
        return this.multipartParts;
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        for (int i = 0; i < this.parts.size(); ++i) {
            this.parts.get(i).method_5838(i + 1 + packet.method_11167());
        }
    }
}

