/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.world.biome;

import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_5699;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6910;

public class CratersBiomeSource
extends class_1966 {
    public static final Codec<CratersBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1959.field_24677.fieldOf("default_biome").forGetter(source -> source.defaultBiome), (App)class_5699.method_36973((Codec)DepthBiome.CODEC.listOf()).listOf().fieldOf("biomes").forGetter(source -> source.allowedBiomes), (App)Codec.doubleRange((double)Double.MIN_VALUE, (double)1.0).fieldOf("erosion_threshold").orElse((Object)0.5).forGetter(source -> source.erosionThreshold)).apply((Applicative)instance, CratersBiomeSource::new));
    private final class_6880<class_1959> defaultBiome;
    private final List<List<DepthBiome>> allowedBiomes;
    private final double erosionThreshold;

    public CratersBiomeSource(class_6880<class_1959> defaultBiome, List<List<DepthBiome>> biomeLists, double erosionThreshold) {
        this.defaultBiome = defaultBiome;
        this.allowedBiomes = biomeLists;
        this.erosionThreshold = erosionThreshold;
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    protected Stream<class_6880<class_1959>> method_49494() {
        return Streams.concat((Stream[])new Stream[]{Stream.of(this.defaultBiome), this.allowedBiomes.stream().flatMap(Collection::stream).map(DepthBiome::biome)});
    }

    public class_6880<class_1959> method_38109(int x, int y, int z, class_6544.class_6552 climateSampler) {
        if (this.allowedBiomes.isEmpty()) {
            return this.defaultBiome;
        }
        class_6910.class_6914 context = new class_6910.class_6914(x, y, z);
        if (climateSampler.comp_367().method_40464((class_6910.class_6912)context) <= this.erosionThreshold) {
            return this.defaultBiome;
        }
        int cubeX = x - 8 >> 6;
        int cubeZ = z - 8 >> 6;
        int biomeIndex = (int)(((long)(cubeX * 31) ^ (long)cubeZ + class_6544.method_38665((float)((float)climateSampler.comp_365().method_40464((class_6910.class_6912)context)))) % (long)this.allowedBiomes.size());
        List<DepthBiome> biomes = this.allowedBiomes.get(biomeIndex);
        long depth = class_6544.method_38665((float)((float)climateSampler.comp_368().method_40464((class_6910.class_6912)context)));
        return biomes.stream().min(Comparator.comparingDouble(depthBiome -> depthBiome.depth().method_38126(depth))).map(DepthBiome::biome).orElse(this.defaultBiome);
    }

    public record DepthBiome(class_6880<class_1959> biome, class_6544.class_6546 depth) {
        public static final Codec<DepthBiome> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1959.field_24677.fieldOf("biome").forGetter(DepthBiome::biome), (App)class_6544.class_6546.field_34478.fieldOf("depth").forGetter(DepthBiome::depth)).apply((Applicative)instance, DepthBiome::new));
    }
}

