/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.renderers.textures;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import earth.terrarium.adastra.common.blockentities.flag.FlagColor;
import java.io.IOException;
import net.minecraft.class_1011;
import net.minecraft.class_1049;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.slf4j.Logger;

public class FlagImageTexture
extends class_1049 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2960 DEFAULT_FLAG = new class_2960("ad_astra", "textures/block/flag/warning_flag.png");
    private final FlagColor[] colors;
    private boolean loaded;

    public FlagImageTexture(byte[] data) {
        super(DEFAULT_FLAG);
        this.colors = FlagColor.fromBytes(data);
    }

    private void upload(class_1011 image) {
        TextureUtil.prepareImage((int)this.method_4624(), (int)image.method_4307(), (int)image.method_4323());
        image.method_4301(0, 0, 0, true);
    }

    public void method_4625(class_3300 manager) {
        class_310.method_1551().execute(() -> {
            if (!this.loaded) {
                try {
                    super.method_4625(manager);
                }
                catch (IOException var3x) {
                    LOGGER.warn("Failed to load texture: {}", (Object)this.field_5224, (Object)var3x);
                }
                this.loaded = true;
            }
        });
        class_310.method_1551().execute(() -> {
            class_1011 image = this.loadTexture(this.colors);
            if (image != null) {
                this.loaded = true;
                if (!RenderSystem.isOnRenderThread()) {
                    RenderSystem.recordRenderCall(() -> this.upload(image));
                } else {
                    this.upload(image);
                }
            }
        });
    }

    private class_1011 loadTexture(FlagColor[] colors) {
        try {
            class_1011 nativeImage = new class_1011(22, 16, false);
            for (int x = 0; x < 22; ++x) {
                for (int y = 0; y < 16; ++y) {
                    FlagColor color = colors[x + y * 22];
                    if (color == FlagColor.NONE) {
                        nativeImage.method_4305(x, y, 0);
                        continue;
                    }
                    nativeImage.method_4305(x, y, color.color() | 0xFF000000);
                }
            }
            return nativeImage;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load texture: {}", (Object)this.field_5224, (Object)e);
            return null;
        }
    }
}

