/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.additionalbanners.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.function.Supplier;
import net.darkhax.additionalbanners.Constants;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.entity.merchant.MerchantTier;
import net.darkhax.bookshelf.api.entity.merchant.trade.VillagerSells;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_3853;

public class TradeConfig {
    @Expose
    private WanderingOffer wanderingVillager;
    @Expose
    private VillagerOffer shepherdOffer;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();

    public WanderingOffer getWanderingOffer() {
        return this.wanderingVillager;
    }

    public VillagerOffer getShepherdOffer() {
        return this.shepherdOffer;
    }

    private TradeConfig(boolean isRare, int cost, boolean canShepherdTrade) {
        this.wanderingVillager = new WanderingOffer(true, cost, isRare);
        this.shepherdOffer = new VillagerOffer(canShepherdTrade, cost);
    }

    public static TradeConfig getDefaultConfig(class_1814 rarity) {
        return switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case class_1814.field_8906 -> new TradeConfig(false, 8, false);
            case class_1814.field_8907 -> new TradeConfig(false, 13, false);
            case class_1814.field_8903 -> new TradeConfig(true, 18, false);
            case class_1814.field_8904 -> new TradeConfig(true, 23, true);
        };
    }

    public static TradeConfig load(String patternName, class_1814 rarity) {
        TradeConfig defaultConfig;
        File configDir = new File(new File(Services.PLATFORM.getConfigDirectory(), "additionalbanners"), "trades");
        if (!configDir.exists()) {
            Constants.LOG.info("Generating trades config dir at {}.", (Object)configDir.getPath());
            configDir.mkdirs();
        }
        File configFile = new File(configDir, patternName + ".json");
        TradeConfig config = defaultConfig = TradeConfig.getDefaultConfig(rarity);
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                config = (TradeConfig)GSON.fromJson((Reader)reader, TradeConfig.class);
            }
            catch (Exception e) {
                Constants.LOG.error("Could not read config file {}. Defaults will be used.", (Object)configFile.getAbsolutePath(), (Object)e);
            }
        } else {
            Constants.LOG.debug("Creating a new config file at {}.", (Object)configFile.getAbsolutePath());
            configFile.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (Exception e) {
            Constants.LOG.error("Could not write config file '{}'!", (Object)configFile.getAbsolutePath(), (Object)e);
        }
        if (config == null) {
            Constants.LOG.error("Corrupted or invalid config file found! Defaults will be used. {}", (Object)configFile.getAbsolutePath());
            return defaultConfig;
        }
        return config;
    }

    public static class WanderingOffer
    extends Offer {
        @Expose
        private boolean isRareTrade;

        private WanderingOffer(boolean enabled, int emeraldCost, boolean isRare) {
            super(enabled, emeraldCost);
            this.isRareTrade = isRare;
        }

        public boolean isRareTrade() {
            return this.isRareTrade;
        }
    }

    public static class VillagerOffer
    extends Offer {
        @Expose
        private MerchantTier tier = MerchantTier.EXPERT;

        private VillagerOffer(boolean enabled, int emeraldCost) {
            super(enabled, emeraldCost);
        }

        public MerchantTier getTier() {
            return this.tier;
        }
    }

    public static class Offer {
        @Expose
        private boolean enabled;
        @Expose
        private int emeraldCost;
        @Expose
        private int maxUses = 8;
        @Expose
        private int villagerExp = 1;
        @Expose
        private float priceMultiplier = 0.5f;

        private Offer(boolean enabled, int emeraldCost) {
            this.enabled = enabled;
            this.emeraldCost = emeraldCost;
        }

        public class_3853.class_1652 createTrade(Supplier<? extends class_1935> toBuy) {
            return VillagerSells.create(toBuy, (int)this.emeraldCost, (int)this.maxUses, (int)this.villagerExp, (float)this.priceMultiplier);
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

