/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.sound;

import it.unimi.dsi.fastutil.doubles.Double2DoubleMap;
import it.unimi.dsi.fastutil.doubles.Double2DoubleRBTreeMap;
import it.unimi.dsi.fastutil.doubles.DoubleComparators;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_310;
import team.creative.ambientsounds.sound.AmbientSound;

public class AmbientSoundEngine {
    private static final class_310 mc = class_310.method_1551();
    private List<AmbientSound.SoundStream> sounds = new ArrayList<AmbientSound.SoundStream>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int playingCount() {
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            return this.sounds.size();
        }
    }

    public class_1144 getManager() {
        return mc.method_1483();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            try {
                Double2DoubleRBTreeMap mutes = new Double2DoubleRBTreeMap((Comparator)DoubleComparators.OPPOSITE_COMPARATOR);
                for (AmbientSound.SoundStream sound : this.sounds) {
                    double soundMute = sound.mute();
                    if (!(soundMute > 0.0)) continue;
                    mutes.mergeDouble(sound.mutePriority(), soundMute, (x, y) -> Math.max(x, y));
                }
                Iterator<AmbientSound.SoundStream> iterator = this.sounds.iterator();
                while (iterator.hasNext()) {
                    boolean playing;
                    AmbientSound.SoundStream sound;
                    sound = iterator.next();
                    if (!this.getManager().method_4877((class_1113)sound)) {
                        if (!sound.hasPlayedOnce()) continue;
                        playing = false;
                    } else {
                        playing = true;
                    }
                    if (sound.hasPlayedOnce() && !playing) {
                        sound.onFinished();
                        this.getManager().method_4870((class_1113)sound);
                        iterator.remove();
                        continue;
                    }
                    if (!sound.hasPlayedOnce() && playing) {
                        sound.setPlayedOnce();
                    }
                    if (mutes.isEmpty()) {
                        sound.generatedVoume = (float)sound.volume;
                        continue;
                    }
                    double mute = 0.0;
                    for (Double2DoubleMap.Entry muteEntry : mutes.double2DoubleEntrySet()) {
                        if (!(sound.mutePriority() < muteEntry.getDoubleKey()) && sound.mute() != 0.0) break;
                        mute = Math.max(muteEntry.getDoubleValue(), mute);
                    }
                    sound.generatedVoume = (float)(sound.volume * (1.0 - mute));
                }
            }
            catch (ConcurrentModificationException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(AmbientSound.SoundStream sound) {
        this.getManager().method_4870((class_1113)sound);
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            this.sounds.remove(sound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(AmbientSound.SoundStream stream) {
        this.getManager().method_4873((class_1113)stream);
        stream.onStart();
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            this.sounds.add(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll() {
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            for (AmbientSound.SoundStream sound : this.sounds) {
                this.stop(sound);
                sound.onFinished();
            }
        }
    }
}

