/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.environment;

import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import team.creative.ambientsounds.condition.AmbientVolume;
import team.creative.ambientsounds.engine.AmbientEngine;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.client.render.text.DebugTextRenderer;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.common.util.type.list.PairList;

public class BiomeEnvironment
implements Iterable<Pair<BiomeArea, AmbientVolume>> {
    private final PairList<BiomeArea, AmbientVolume> biomes = new PairList();
    private double highestRainVolume;

    public BiomeEnvironment() {
    }

    public BiomeEnvironment(AmbientEngine engine, class_1657 player, class_1937 level, AmbientVolume volume) {
        this.highestRainVolume = 0.0;
        if (volume.volume() > 0.0) {
            class_2338 center = class_2338.method_49638((class_2374)player.method_5836(CreativeCoreClient.getFrameTime()));
            class_2338.class_2339 pos = new class_2338.class_2339();
            for (int x2 = -engine.biomeScanCount; x2 <= engine.biomeScanCount; ++x2) {
                for (int z = -engine.biomeScanCount; z <= engine.biomeScanCount; ++z) {
                    BiomeArea area;
                    Pair before;
                    pos.method_10103(center.method_10263() + x2 * engine.biomeScanDistance, center.method_10264(), center.method_10260() + z * engine.biomeScanDistance);
                    class_6880 holder = level.method_23753((class_2338)pos);
                    float biomeConditionVolume = (float)((1.0 - center.method_10262((class_2382)pos) / engine.squaredBiomeDistance) * volume.conditionVolume());
                    if (level.method_8419() && ((class_1959)holder.comp_349()).method_48162((class_2338)pos) == class_1959.class_1963.field_9382) {
                        this.highestRainVolume = Math.max(this.highestRainVolume, (double)biomeConditionVolume * volume.settingVolume());
                    }
                    if ((before = this.biomes.getPair((Object)(area = new BiomeArea(level, (class_6880<class_1959>)holder, (class_2338)pos)))) == null) {
                        this.biomes.add((Object)area, (Object)new AmbientVolume(biomeConditionVolume, volume.settingVolume()));
                        continue;
                    }
                    if (!(((AmbientVolume)before.value).conditionVolume() < (double)biomeConditionVolume)) continue;
                    ((AmbientVolume)before.value).setConditionVolumeDirect(biomeConditionVolume);
                }
            }
            this.biomes.sort(Comparator.comparingDouble(x -> ((AmbientVolume)x.value).volume()).reversed());
        }
    }

    @Override
    public Iterator<Pair<BiomeArea, AmbientVolume>> iterator() {
        return this.biomes.iterator();
    }

    public double rainVolume() {
        return this.highestRainVolume;
    }

    public void collectDetails(DebugTextRenderer text) {
        for (Pair<BiomeArea, AmbientVolume> pair : this) {
            text.detail(((BiomeArea)pair.getKey()).location.toString(), pair.getValue());
        }
    }

    public static class BiomeArea {
        public final class_6880<class_1959> biome;
        public final class_2960 location;
        public final class_2338 pos;

        public BiomeArea(class_1937 level, class_6880<class_1959> biome, class_2338 pos) {
            this.biome = biome;
            this.location = level.method_30349().method_30530(class_7924.field_41236).method_10221((Object)((class_1959)biome.comp_349()));
            this.pos = pos;
        }

        public boolean checkBiome(String[] names) {
            for (String name : names) {
                if (!(name.startsWith("#") ? this.biome.method_40228().anyMatch(x -> x.comp_327().toString().matches(".*" + name.substring(1).replace("*", ".*") + ".*")) : this.location.toString().matches(".*" + name.replace("*", ".*") + ".*"))) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object object) {
            if (object instanceof BiomeArea) {
                return ((BiomeArea)object).biome.equals(this.biome);
            }
            return false;
        }

        public int hashCode() {
            return this.biome.hashCode();
        }
    }
}

