/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.utils.modinfo.ModInfoUtils;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.api.party.Party;
import earth.terrarium.argonauts.api.party.PartyApi;
import earth.terrarium.argonauts.common.compat.cadmus.CadmusIntegration;
import earth.terrarium.argonauts.common.compat.heracles.HeraclesIntegration;
import earth.terrarium.argonauts.common.constants.ConstantComponents;
import earth.terrarium.argonauts.common.handlers.party.members.PartyMembers;
import earth.terrarium.argonauts.common.network.NetworkHandler;
import earth.terrarium.argonauts.common.network.messages.ClientboundSyncGuildsPacket;
import earth.terrarium.argonauts.common.network.messages.ClientboundSyncPartiesPacket;
import earth.terrarium.argonauts.common.utils.ModUtils;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class Argonauts {
    public static final String MOD_ID = "argonauts";

    public static void init() {
        NetworkHandler.init();
        if (Argonauts.isCadmusLoaded()) {
            CadmusIntegration.init();
        }
        if (Argonauts.isHeraclesLoaded()) {
            HeraclesIntegration.init();
        }
    }

    public static void onPlayerJoin(class_1657 player) {
        if (player.method_37908().method_8608()) {
            return;
        }
        NetworkHandler.CHANNEL.sendToPlayer((Packet)new ClientboundSyncGuildsPacket(new HashSet<Guild>(GuildApi.API.getAll(player.method_5682())), Set.of()), player);
        NetworkHandler.CHANNEL.sendToPlayer((Packet)new ClientboundSyncPartiesPacket(new HashSet<Party>(PartyApi.API.getAll()), Set.of()), player);
        Guild guild = GuildApi.API.get((class_3222)player);
        if (guild == null) {
            return;
        }
        class_2561 motd = guild.settings().motd();
        if (motd.getString().isEmpty()) {
            return;
        }
        player.method_7353(ConstantComponents.MOTD_HEADER, false);
        player.method_7353(ModUtils.getParsedComponent(motd, (class_3222)player), false);
        player.method_7353(ConstantComponents.LINE, false);
    }

    public static void onPlayerLeave(class_1657 player) {
        if (player.method_37908().method_8608()) {
            return;
        }
        Party party = PartyApi.API.getPlayerParty(player.method_5667());
        if (party == null) {
            return;
        }
        if (!((PartyMembers)party.members()).isLeader(player.method_5667())) {
            return;
        }
        PartyApi.API.disband(party, Objects.requireNonNull(player.method_5682()));
    }

    public static boolean isCadmusLoaded() {
        return ModInfoUtils.isModLoaded((String)"cadmus");
    }

    public static boolean isHeraclesLoaded() {
        return ModInfoUtils.isModLoaded((String)"heracles");
    }
}

