/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.client.screens.chat.embeds;

import com.google.gson.JsonObject;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import com.teamresourceful.resourcefullib.client.scissor.CloseableScissorStack;
import com.teamresourceful.resourcefullib.client.utils.RenderUtils;
import com.teamresourceful.resourcefullib.common.utils.WebUtils;
import earth.terrarium.argonauts.client.screens.chat.embeds.Embeder;
import earth.terrarium.argonauts.client.screens.chat.embeds.ImageEmbeder;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1041;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class SpotifyTrackEmbeder
implements Embeder {
    private static final Map<String, SpotifyTrackInfo> INFO = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());

    @Override
    public void handle(class_332 graphics, URI uri) {
        SpotifyTrackEmbeder.resolve(uri.toString());
        SpotifyTrackInfo info = INFO.get(uri.toString());
        if (info == null) {
            return;
        }
        String title = info.title;
        String thumbnail = info.image;
        if (title == null || thumbnail == null || !info.future.isDone()) {
            return;
        }
        class_2960 texture = ImageEmbeder.resolveImage(thumbnail);
        class_312 mouse = class_310.method_1551().field_1729;
        class_1041 mainWindow = class_310.method_1551().method_22683();
        double mouseX = mouse.method_1603() * (double)mainWindow.method_4486() / (double)mainWindow.method_4480();
        double mouseY = mouse.method_1604() * (double)mainWindow.method_4502() / (double)mainWindow.method_4507();
        try (CloseablePoseStack pose = new CloseablePoseStack(graphics);){
            pose.method_22904(mouseX, mouseY, 200.0);
            graphics.method_25290(texture, 5, 5, 0.0f, 0.0f, info.width, info.height, info.width, info.height);
            graphics.method_25294(5, 5 + info.height - 15, 5 + info.width, 5 + info.height, Integer.MIN_VALUE);
            try (CloseableScissorStack ignored = RenderUtils.createScissor((class_310)class_310.method_1551(), (class_332)graphics, (int)5, (int)(5 + info.height - 15), (int)info.width, (int)15);){
                List split = class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43470((String)title), info.width - 20);
                if (!split.isEmpty()) {
                    int draw = graphics.method_51430(class_310.method_1551().field_1772, (class_5481)split.get(0), 8, 5 + info.height - 12, 43247, false);
                    if (split.size() > 1) {
                        graphics.method_51433(class_310.method_1551().field_1772, "...", draw, 5 + info.height - 12, 43247, false);
                    }
                }
            }
        }
    }

    private static void resolve(String url) {
        if (INFO.containsKey(url)) {
            return;
        }
        INFO.put(url, new SpotifyTrackInfo(CompletableFuture.runAsync(() -> {
            try {
                JsonObject object = WebUtils.getJson((String)("https://open.spotify.com/oembed?url=" + url + "&format=json"), (boolean)true);
                if (object == null) {
                    return;
                }
                SpotifyTrackInfo info = INFO.get(url);
                if (info == null) {
                    return;
                }
                info.update(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, class_156.method_18349())));
    }

    private static class SpotifyTrackInfo {
        private final CompletableFuture<?> future;
        private String image;
        private String title;
        private int height;
        private int width;

        public SpotifyTrackInfo(CompletableFuture<?> future) {
            this.future = future;
        }

        public void update(JsonObject object) {
            this.title = object.get("title").getAsString();
            this.image = object.get("thumbnail_url").getAsString();
            this.height = object.get("thumbnail_height").getAsInt();
            this.width = object.get("thumbnail_width").getAsInt();
            if (this.height > 200 || this.width > 250) {
                this.height = (int)((float)this.height * 0.25f);
                this.width = (int)((float)this.width * 0.25f);
            }
        }
    }
}

