/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.commands.guild;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMembers;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_3222;
import net.minecraft.class_5242;

public class GuildAdminCommands {
    private static final SuggestionProvider<class_2168> GUILDS_SUGGESTION_PROVIDER = (context, builder) -> {
        Collection<Guild> guilds = GuildApi.API.getAll(((class_2168)context.getSource()).method_9211());
        return class_2172.method_9264(guilds.stream().map(g -> g.id().toString()), (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"guild").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"admin").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"disband").then(class_2170.method_9244((String)"guild", (ArgumentType)class_5242.method_27643()).suggests(GUILDS_SUGGESTION_PROVIDER).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            Guild guild = GuildApi.API.get(player.field_13995, class_5242.method_27645((CommandContext)context, (String)"guild"));
            GuildAdminCommands.removeGuild(guild, player);
            return 1;
        })))).then(class_2170.method_9247((String)"disbandall").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            new ArrayList<Guild>(GuildApi.API.getAll(player.field_13995)).forEach(guild -> GuildAdminCommands.removeGuild(guild, player));
            return 1;
        }))).then(class_2170.method_9247((String)"join").then(class_2170.method_9244((String)"guild", (ArgumentType)class_5242.method_27643()).suggests(GUILDS_SUGGESTION_PROVIDER).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            Guild guild = GuildApi.API.get(player.field_13995, class_5242.method_27645((CommandContext)context, (String)"guild"));
            GuildAdminCommands.joinGuild(guild, player);
            return 1;
        })))));
    }

    public static void removeGuild(Guild guild, class_3222 player) {
        CommandHelper.runAction(() -> {
            if (guild == null) {
                throw MemberException.GUILD_DOES_NOT_EXIST;
            }
            player.method_7353(CommonUtils.serverTranslatable((String)"text.argonauts.member.guild_disband", (Object[])new Object[]{guild.settings().displayName().getString()}), false);
            ((GuildMembers)guild.members()).forEach(p -> {
                class_3222 groupMember = player.field_13995.method_3760().method_14602(p.profile().getId());
                if (groupMember != null) {
                    groupMember.method_7353(CommonUtils.serverTranslatable((String)"text.argonauts.member.disband", (Object[])new Object[]{guild.displayName()}), false);
                }
            });
            GuildApi.API.remove(true, guild, player.field_13995);
        });
    }

    public static void joinGuild(Guild guild, class_3222 player) {
        CommandHelper.runAction(() -> {
            if (guild == null) {
                throw MemberException.GUILD_DOES_NOT_EXIST;
            }
            GuildApi.API.join(guild, player);
        });
    }
}

