/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.commands.guild;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.commands.base.ManageCommands;
import earth.terrarium.argonauts.common.commands.guild.GuildCommandHelper;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMember;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMembers;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3222;

public final class GuildManageCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"guild").then(GuildManageCommands.invite())).then(GuildManageCommands.remove())).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"allies").then(GuildManageCommands.addAlly())).then(GuildManageCommands.removeAlly())));
    }

    private static ArgumentBuilder<class_2168, LiteralArgumentBuilder<class_2168>> invite() {
        return ManageCommands.invite("guild", MemberException.YOU_CANT_MANAGE_MEMBERS_IN_GUILD, MemberException.PLAYER_ALREADY_IN_GUILD, GuildCommandHelper::getGuildOrThrow);
    }

    private static ArgumentBuilder<class_2168, LiteralArgumentBuilder<class_2168>> remove() {
        return ManageCommands.remove(MemberException.YOU_CANT_REMOVE_YOURSELF_FROM_GUILD, MemberException.YOU_CANT_REMOVE_GUILD_OWNER, MemberException.YOU_CANT_MANAGE_MEMBERS_IN_GUILD, GuildCommandHelper::getGuildOrThrow, GuildApi.API::leave);
    }

    private static ArgumentBuilder<class_2168, LiteralArgumentBuilder<class_2168>> addAlly() {
        return class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            class_3222 target = class_2186.method_9315((CommandContext)context, (String)"player");
            Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
            CommandHelper.runAction(() -> {
                GuildMember member = (GuildMember)guild.getMember((class_1657)player);
                if (player.method_5667().equals(target.method_5667())) {
                    throw MemberException.YOU_CANT_ALLY_YOURSELF;
                }
                if (((GuildMembers)guild.members()).isMember(target.method_5667())) {
                    throw MemberException.PLAYER_ALREADY_IN_GUILD;
                }
                if (!member.hasPermission("manage.members")) {
                    throw MemberException.YOU_CANT_MANAGE_MEMBERS_IN_GUILD;
                }
                ((GuildMembers)guild.members()).ally(target.method_7334());
                player.method_7353(CommonUtils.serverTranslatable((String)"text.argonauts.allied", (Object[])new Object[]{target.method_5477().getString()}), false);
                target.method_7353(CommonUtils.serverTranslatable((String)"text.argonauts.member.guild_allied", (Object[])new Object[]{player.method_5477().getString()}), false);
            });
            return 1;
        }));
    }

    private static ArgumentBuilder<class_2168, LiteralArgumentBuilder<class_2168>> removeAlly() {
        return class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            class_3222 target = class_2186.method_9315((CommandContext)context, (String)"player");
            Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
            CommandHelper.runAction(() -> {
                GuildMember member = (GuildMember)guild.getMember((class_1657)player);
                if (!member.hasPermission("manage.members")) {
                    throw MemberException.YOU_CANT_MANAGE_MEMBERS_IN_GUILD;
                }
                if (player.method_5667().equals(target.method_5667())) {
                    throw MemberException.YOU_CANT_REMOVE_YOURSELF_FROM_GUILD;
                }
                if (((GuildMembers)guild.members()).isLeader(target.method_5667())) {
                    throw MemberException.YOU_CANT_REMOVE_GUILD_OWNER;
                }
                if (!((GuildMembers)guild.members()).isAllied(target.method_5667())) {
                    throw MemberException.NOT_AN_ALLY;
                }
                ((GuildMembers)guild.members()).remove(target.method_5667());
                player.method_7353(CommonUtils.serverTranslatable((String)"text.argonauts.remove_ally", (Object[])new Object[]{target.method_5477().getString()}), false);
                target.method_7353(CommonUtils.serverTranslatable((String)"text.argonauts.no_longer_allied", (Object[])new Object[]{guild.displayName()}), false);
            });
            return 1;
        }));
    }
}

