/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.commands.guild;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.commands.guild.GuildCommandHelper;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMembers;
import earth.terrarium.argonauts.common.utils.ModUtils;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2177;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5321;

public final class GuildSettingsCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"guild").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"settings").then(GuildSettingsCommands.hq())).then(GuildSettingsCommands.displayName())).then(GuildSettingsCommands.motd())).then(GuildSettingsCommands.color())).then(GuildSettingsCommands.allowFakePlayers())));
    }

    private static ArgumentBuilder<class_2168, LiteralArgumentBuilder<class_2168>> hq() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"hq").then(class_2170.method_9247((String)"set").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> {
                class_2338 pos = player.method_24515();
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                if (!((GuildMembers)guild.members()).isLeader(player.method_5667())) {
                    throw MemberException.YOU_ARE_NOT_THE_OWNER_OF_GUILD;
                }
                guild.settings().setHq(class_4208.method_19443((class_5321)player.method_37908().method_27983(), (class_2338)pos));
                player.method_7353(GuildSettingsCommands.setCurrentComponent("hq", player.method_37908().method_27983().method_29177() + ", " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260()), false);
            });
            return 1;
        }))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> {
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                Optional<class_4208> hq = guild.settings().hq();
                if (hq.isEmpty()) {
                    throw MemberException.HQ_NOT_SET;
                }
                hq.ifPresent(hq1 -> player.method_7353(GuildSettingsCommands.getCurrentComponent("hq", hq1.method_19442().method_29177() + ", " + hq1.method_19446().method_10263() + ", " + hq1.method_19446().method_10264() + ", " + hq1.method_19446().method_10260()), false));
            });
            return 1;
        });
    }

    private static ArgumentBuilder<class_2168, LiteralArgumentBuilder<class_2168>> displayName() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"displayName").then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> {
                String displayName = ModUtils.formatTextColors(StringArgumentType.getString((CommandContext)context, (String)"value"));
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                if (!((GuildMembers)guild.members()).isLeader(player.method_5667())) {
                    throw MemberException.YOU_ARE_NOT_THE_OWNER_OF_GUILD;
                }
                guild.settings().setDisplayName((class_2561)class_2561.method_43470((String)displayName));
                player.method_7353(GuildSettingsCommands.setCurrentComponent("displayName", displayName), false);
            });
            return 1;
        }))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> {
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                player.method_7353(GuildSettingsCommands.getCurrentComponent("displayName", guild.displayName()), false);
            });
            return 1;
        });
    }

    private static ArgumentBuilder<class_2168, LiteralArgumentBuilder<class_2168>> motd() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"motd").then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> {
                String name = ModUtils.formatTextColors(StringArgumentType.getString((CommandContext)context, (String)"value")).replace("\\n", "\n");
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                if (!((GuildMembers)guild.members()).isLeader(player.method_5667())) {
                    throw MemberException.YOU_ARE_NOT_THE_OWNER_OF_GUILD;
                }
                guild.settings().setMotd((class_2561)class_2561.method_43470((String)name));
                player.method_7353(GuildSettingsCommands.setCurrentComponent("motd", name), false);
            });
            return 1;
        }))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> {
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                player.method_7353(GuildSettingsCommands.getCurrentComponent("motd", guild.motd()), false);
            });
            return 1;
        });
    }

    private static ArgumentBuilder<class_2168, LiteralArgumentBuilder<class_2168>> color() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"color").then(class_2170.method_9244((String)"value", (ArgumentType)class_2177.method_9276()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> {
                class_124 color = class_2177.method_9277((CommandContext)context, (String)"value");
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                if (!((GuildMembers)guild.members()).isLeader(player.method_5667())) {
                    throw MemberException.YOU_ARE_NOT_THE_OWNER_OF_GUILD;
                }
                guild.settings().setColor(color);
                player.method_7353(GuildSettingsCommands.setCurrentComponent("color", guild.color().name().toLowerCase(Locale.ROOT)), false);
            });
            return 1;
        }))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> {
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                player.method_7353(GuildSettingsCommands.getCurrentComponent("color", guild.color().name().toLowerCase(Locale.ROOT)), false);
            });
            return 1;
        });
    }

    private static ArgumentBuilder<class_2168, LiteralArgumentBuilder<class_2168>> allowFakePlayers() {
        return class_2170.method_9247((String)"allowFakePlayers").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> {
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                guild.settings().setAllowFakePlayers(!guild.settings().allowFakePlayers());
                player.method_7353(GuildSettingsCommands.getCurrentComponent("allowFakePlayers", String.valueOf(guild.settings().allowFakePlayers())), false);
            });
            return 1;
        });
    }

    private static class_2561 getCurrentComponent(String command, Object value) {
        return CommonUtils.serverTranslatable((String)"text.argonauts.settings.current", (Object[])new Object[]{command, value});
    }

    private static class_2561 setCurrentComponent(String command, Object value) {
        return CommonUtils.serverTranslatable((String)"text.argonauts.settings.set", (Object[])new Object[]{command, value});
    }
}

