/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.commands.party;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import earth.terrarium.argonauts.api.party.Party;
import earth.terrarium.argonauts.api.party.PartyApi;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.constants.ConstantComponents;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.party.members.PartyMember;
import earth.terrarium.argonauts.common.handlers.party.members.PartyMembers;
import earth.terrarium.argonauts.common.handlers.party.settings.DefaultPartySettings;
import earth.terrarium.argonauts.common.menus.party.PartyMembersContent;
import earth.terrarium.argonauts.common.menus.party.PartySettingsContent;
import earth.terrarium.argonauts.common.network.NetworkHandler;
import earth.terrarium.argonauts.common.network.messages.ClientboundOpenPartyMemberMenuPacket;
import earth.terrarium.argonauts.common.network.messages.ClientboundOpenPartySettingsMenuPacket;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.HashSet;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;

public final class PartyMemberCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"party").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"member").then(PartyMemberCommands.list())).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> PartyMemberCommands.openMemberScreen(player));
            return 1;
        })));
    }

    private static ArgumentBuilder<class_2168, LiteralArgumentBuilder<class_2168>> list() {
        return class_2170.method_9247((String)"list").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> PartyMemberCommands.openMembersScreen(player, -1));
            return 1;
        });
    }

    public static void openMembersScreen(class_3222 player, int selected) throws MemberException {
        if (!NetworkHandler.CHANNEL.canSendPlayerPackets((class_1657)player)) {
            throw MemberException.NOT_INSTALLED_ON_CLIENT;
        }
        Party party = PartyApi.API.get((class_1657)player);
        if (party == null) {
            throw MemberException.YOU_ARE_NOT_IN_PARTY;
        }
        PartyMember member = (PartyMember)party.getMember((class_1657)player);
        NetworkHandler.CHANNEL.sendToPlayer((Packet)new ClientboundOpenPartyMemberMenuPacket(new PartyMembersContent(party.id(), selected, ((PartyMembers)party.members()).allMembers(), member.hasPermission("manage.members"), member.hasPermission("permissions.members")), ConstantComponents.PARTY_MEMBERS_TITLE), (class_1657)player);
    }

    public static void openMemberScreen(class_3222 player) throws MemberException {
        if (!NetworkHandler.CHANNEL.canSendPlayerPackets((class_1657)player)) {
            throw MemberException.NOT_INSTALLED_ON_CLIENT;
        }
        Party party = PartyApi.API.get((class_1657)player);
        if (party == null) {
            throw MemberException.YOU_ARE_NOT_IN_PARTY;
        }
        PartyMember member = (PartyMember)party.getMember((class_1657)player);
        Object2BooleanLinkedOpenHashMap settings = new Object2BooleanLinkedOpenHashMap();
        HashSet<String> oldSettings = new HashSet<String>(member.settings().settings());
        for (String setting : DefaultPartySettings.MEMBER_SETTINGS) {
            settings.put((Object)setting, oldSettings.contains(setting));
            oldSettings.remove(setting);
        }
        for (String setting : oldSettings) {
            settings.put((Object)setting, false);
        }
        NetworkHandler.CHANNEL.sendToPlayer((Packet)new ClientboundOpenPartySettingsMenuPacket(new PartySettingsContent(false, (Object2BooleanMap<String>)settings), ConstantComponents.MEMBER_SETTINGS_TITLE), (class_1657)player);
    }
}

