/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.commands.party;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.argonauts.api.party.Party;
import earth.terrarium.argonauts.api.party.PartyApi;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.commands.party.PartyCommandHelper;
import earth.terrarium.argonauts.common.constants.ConstantComponents;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.party.members.PartyMember;
import earth.terrarium.argonauts.common.handlers.party.settings.DefaultPartySettings;
import earth.terrarium.argonauts.common.menus.party.PartySettingsContent;
import earth.terrarium.argonauts.common.network.NetworkHandler;
import earth.terrarium.argonauts.common.network.messages.ClientboundOpenPartySettingsMenuPacket;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.HashSet;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class PartySettingsCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"party").then(PartySettingsCommands.settings())).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"settings").then(PartySettingsCommands.publicParty())).then(PartySettingsCommands.friendlyFire())).then(PartySettingsCommands.passiveTeleport())).then(PartySettingsCommands.list())));
    }

    private static ArgumentBuilder<class_2168, LiteralArgumentBuilder<class_2168>> publicParty() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"publicParty").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> {
                boolean publicParty = BoolArgumentType.getBool((CommandContext)context, (String)"value");
                Party party = PartyCommandHelper.getPartyOrThrow((class_1657)player, false);
                PartyMember member = (PartyMember)party.getMember((class_1657)player);
                if (!member.hasPermission("manage.settings")) {
                    throw MemberException.NO_PERMISSIONS;
                }
                party.settings().set("public", publicParty);
                player.method_7353(PartySettingsCommands.setCurrentComponent("publicParty", publicParty), false);
            });
            return 1;
        }))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> {
                Party party = PartyCommandHelper.getPartyOrThrow((class_1657)player, false);
                boolean publicParty = party.settings().settings().contains("public");
                player.method_7353(PartySettingsCommands.getCurrentComponent("publicParty", publicParty), false);
            });
            return 1;
        });
    }

    private static ArgumentBuilder<class_2168, LiteralArgumentBuilder<class_2168>> friendlyFire() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"friendlyFire").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> {
                boolean friendlyFire = BoolArgumentType.getBool((CommandContext)context, (String)"value");
                Party party = PartyCommandHelper.getPartyOrThrow((class_1657)player, false);
                PartyMember member = (PartyMember)party.getMember((class_1657)player);
                if (!member.hasPermission("manage.settings")) {
                    throw MemberException.NO_PERMISSIONS;
                }
                party.settings().set("friendly_fire", friendlyFire);
                player.method_7353(PartySettingsCommands.setCurrentComponent("friendlyFire", friendlyFire), false);
            });
            return 1;
        }))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> {
                Party party = PartyCommandHelper.getPartyOrThrow((class_1657)player, false);
                boolean friendlyFire = party.settings().settings().contains("friendly_fire");
                player.method_7353(PartySettingsCommands.getCurrentComponent("friendlyFire", friendlyFire), false);
            });
            return 1;
        });
    }

    private static ArgumentBuilder<class_2168, LiteralArgumentBuilder<class_2168>> passiveTeleport() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"passiveTeleport").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> {
                boolean passiveTeleport = BoolArgumentType.getBool((CommandContext)context, (String)"value");
                Party party = PartyCommandHelper.getPartyOrThrow((class_1657)player, false);
                PartyMember member = (PartyMember)party.getMember((class_1657)player);
                if (!member.hasPermission("manage.settings")) {
                    throw MemberException.NO_PERMISSIONS;
                }
                party.settings().set("passive_tp", passiveTeleport);
                player.method_7353(PartySettingsCommands.setCurrentComponent("passiveTeleport", passiveTeleport), false);
            });
            return 1;
        }))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> {
                Party party = PartyCommandHelper.getPartyOrThrow((class_1657)player, false);
                boolean passiveTeleport = party.settings().settings().contains("passive_tp");
                player.method_7353(PartySettingsCommands.getCurrentComponent("passiveTeleport", passiveTeleport), false);
            });
            return 1;
        });
    }

    private static ArgumentBuilder<class_2168, LiteralArgumentBuilder<class_2168>> list() {
        return class_2170.method_9247((String)"list").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> PartySettingsCommands.openSettingsScreen(player));
            return 1;
        });
    }

    private static ArgumentBuilder<class_2168, LiteralArgumentBuilder<class_2168>> settings() {
        return class_2170.method_9247((String)"settings").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> PartySettingsCommands.openSettingsScreen(player));
            return 1;
        });
    }

    public static void openSettingsScreen(class_3222 player) throws MemberException {
        if (!NetworkHandler.CHANNEL.canSendPlayerPackets((class_1657)player)) {
            throw MemberException.NOT_INSTALLED_ON_CLIENT;
        }
        Party party = PartyApi.API.get((class_1657)player);
        if (party == null) {
            throw MemberException.YOU_ARE_NOT_IN_PARTY;
        }
        PartyMember member = (PartyMember)party.getMember((class_1657)player);
        if (!member.hasPermission("manage.settings")) {
            throw MemberException.NO_PERMISSIONS;
        }
        Object2BooleanLinkedOpenHashMap settings = new Object2BooleanLinkedOpenHashMap();
        HashSet<String> oldSettings = new HashSet<String>(party.settings().settings());
        for (String setting : DefaultPartySettings.PARTY_SETTINGS) {
            settings.put((Object)setting, oldSettings.contains(setting));
            oldSettings.remove(setting);
        }
        for (String setting : oldSettings) {
            settings.put((Object)setting, false);
        }
        NetworkHandler.CHANNEL.sendToPlayer((Packet)new ClientboundOpenPartySettingsMenuPacket(new PartySettingsContent(true, (Object2BooleanMap<String>)settings), ConstantComponents.PARTY_SETTING_TITLE), (class_1657)player);
    }

    private static class_2561 getCurrentComponent(String command, Object value) {
        return CommonUtils.serverTranslatable((String)"text.argonauts.settings.current", (Object[])new Object[]{command, value});
    }

    private static class_2561 setCurrentComponent(String command, Object value) {
        return CommonUtils.serverTranslatable((String)"text.argonauts.settings.set", (Object[])new Object[]{command, value});
    }
}

