/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.network.messages;

import com.google.common.primitives.UnsignedInteger;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.api.party.Party;
import earth.terrarium.argonauts.api.party.PartyApi;
import earth.terrarium.argonauts.common.handlers.base.members.Group;
import earth.terrarium.argonauts.common.handlers.base.members.Member;
import earth.terrarium.argonauts.common.handlers.chat.ChatHandler;
import earth.terrarium.argonauts.common.handlers.chat.ChatMessage;
import earth.terrarium.argonauts.common.handlers.chat.ChatMessageType;
import earth.terrarium.argonauts.common.handlers.chat.MessageChannel;
import earth.terrarium.argonauts.common.network.NetworkHandler;
import earth.terrarium.argonauts.common.network.messages.ClientboundReceiveMessagePacket;
import java.time.Instant;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public record ServerboundChatWindowPacket(String message, ChatMessageType type) implements Packet<ServerboundChatWindowPacket>
{
    public static final class_2960 ID = new class_2960("argonauts", "send_chat_message");
    public static final PacketHandler<ServerboundChatWindowPacket> HANDLER = new Handler();

    public class_2960 getID() {
        return ID;
    }

    public PacketHandler<ServerboundChatWindowPacket> getHandler() {
        return HANDLER;
    }

    public static void sendMessage(class_3222 player, Group<?, ?> group, String message, MessageChannel channel) {
        ChatMessage chatMessage = new ChatMessage(player.method_7334(), message, Instant.now());
        UnsignedInteger id = channel.add(chatMessage);
        ClientboundReceiveMessagePacket packet = new ClientboundReceiveMessagePacket(id, chatMessage);
        for (Member member : group.members()) {
            class_3222 memberPlayer = player.field_13995.method_3760().method_14602(member.profile().getId());
            if (memberPlayer == null) continue;
            if (member.getState().isPermanentMember()) {
                class_2561 messageComponent = CommonUtils.serverTranslatable((String)"text.argonauts.chat_message", (Object[])new Object[]{group.displayName().method_27662().method_27692(group.color()), class_2556.method_44832((class_5321)class_2556.field_11737, (class_1297)player).comp_920(), message});
                memberPlayer.method_7353(messageComponent, false);
            }
            if (!NetworkHandler.CHANNEL.canSendPlayerPackets((class_1657)memberPlayer)) continue;
            NetworkHandler.CHANNEL.sendToPlayer((Packet)packet, (class_1657)memberPlayer);
        }
    }

    private static class Handler
    implements PacketHandler<ServerboundChatWindowPacket> {
        private Handler() {
        }

        public void encode(ServerboundChatWindowPacket message, class_2540 buffer) {
            buffer.method_10788(message.message, 512);
            buffer.method_10817((Enum)message.type);
        }

        public ServerboundChatWindowPacket decode(class_2540 buffer) {
            return new ServerboundChatWindowPacket(buffer.method_10800(512), (ChatMessageType)buffer.method_10818(ChatMessageType.class));
        }

        public PacketContext handle(ServerboundChatWindowPacket message) {
            return (player, level) -> {
                class_3222 serverPlayer = (class_3222)player;
                switch (message.type()) {
                    case PARTY: {
                        Party party = PartyApi.API.get((class_1657)serverPlayer);
                        if (party == null) {
                            return;
                        }
                        MessageChannel channel = ChatHandler.getChannel(party, message.type());
                        ServerboundChatWindowPacket.sendMessage(serverPlayer, party, message.message, channel);
                        break;
                    }
                    case GUILD: {
                        Guild guild = GuildApi.API.get(serverPlayer);
                        if (guild == null) {
                            return;
                        }
                        MessageChannel channel = ChatHandler.getChannel(guild, message.type());
                        ServerboundChatWindowPacket.sendMessage(serverPlayer, guild, message.message, channel);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + message.type());
                    }
                }
            };
        }
    }
}

