/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.network.messages;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import earth.terrarium.argonauts.api.party.Party;
import earth.terrarium.argonauts.api.party.PartyApi;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.party.members.PartyMember;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public record ServerboundSetSettingPacket(String setting, boolean value, UUID member, boolean partySettings) implements Packet<ServerboundSetSettingPacket>
{
    public static final class_2960 ID = new class_2960("argonauts", "set_setting");
    public static final PacketHandler<ServerboundSetSettingPacket> HANDLER = new Handler();

    public class_2960 getID() {
        return ID;
    }

    public PacketHandler<ServerboundSetSettingPacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements PacketHandler<ServerboundSetSettingPacket> {
        private Handler() {
        }

        public void encode(ServerboundSetSettingPacket message, class_2540 buffer) {
            buffer.method_10814(message.setting);
            buffer.writeBoolean(message.value);
            buffer.method_10797(message.member);
            buffer.writeBoolean(message.partySettings);
        }

        public ServerboundSetSettingPacket decode(class_2540 buffer) {
            return new ServerboundSetSettingPacket(buffer.method_19772(), buffer.readBoolean(), buffer.method_10790(), buffer.readBoolean());
        }

        public PacketContext handle(ServerboundSetSettingPacket message) {
            return (player, level) -> CommandHelper.runNetworkAction(player, () -> {
                Party party = PartyApi.API.getPlayerParty(message.member());
                if (party == null) {
                    return;
                }
                PartyMember member = party.getMember(message.member());
                if (!member.hasPermission("manage.settings")) {
                    throw MemberException.NO_PERMISSIONS;
                }
                if (message.partySettings()) {
                    party.settings().set(message.setting, message.value);
                } else {
                    member.settings().set(message.setting, message.value);
                }
            });
        }
    }
}

