/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.config;

import de.maxhenkel.audioplayer.configbuilder.ConfigBuilder;
import de.maxhenkel.audioplayer.configbuilder.entry.ConfigEntry;

public class WebServerConfig {
    public final ConfigEntry<Integer> port;
    public final ConfigEntry<String> url;
    public final ConfigEntry<Long> tokenTimeout;
    public final ConfigEntry<String> authUsername;
    public final ConfigEntry<String> authPassword;

    public WebServerConfig(ConfigBuilder builder) {
        this.port = builder.integerEntry("port", (Integer)8080, 1, (Integer)Short.MAX_VALUE, "The webserver port");
        this.url = builder.stringEntry("url", "", "The URL under which the webserver is reachable", "Example: https://test.example.com", "If this is left empty, the user will be prompted to copy the token manually", "If its set, the link will be generated automatically and the user can just open a link");
        this.tokenTimeout = builder.longEntry("token_timeout", (Long)300000L, "The timeout of the token in milliseconds");
        this.authUsername = builder.stringEntry("auth_username", "", "The username for basic auth", "If this is left empty, no auth will be used");
        this.authPassword = builder.stringEntry("auth_password", "", "The password for basic auth", "If this is left empty, no auth will be used");
    }
}

