/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render.monitor;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.client.integration.ShaderMod;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.monitor.MonitorRenderState;
import dan200.computercraft.client.render.monitor.MonitorTextureBufferShader;
import dan200.computercraft.client.render.text.DirectFixedWidthFontRenderer;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.client.render.vbo.DirectBuffers;
import dan200.computercraft.client.render.vbo.DirectVertexBuffer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.peripheral.monitor.MonitorRenderer;
import dan200.computercraft.shared.util.DirectionUtil;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_291;
import net.minecraft.class_311;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_8251;
import net.minecraft.class_827;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class MonitorBlockEntityRenderer
implements class_827<MonitorBlockEntity> {
    private static final float MARGIN = 0.034375f;
    private static final Matrix3f IDENTITY_NORMAL = new Matrix3f().identity();
    @Nullable
    private static ByteBuffer backingBuffer;
    private static long lastFrame;

    public MonitorBlockEntityRenderer(class_5614.class_5615 context) {
    }

    public void render(MonitorBlockEntity monitor, float partialTicks, class_4587 transform, class_4597 bufferSource, int lightmapCoord, int overlayLight) {
        ClientMonitor originTerminal = monitor.getOriginClientMonitor();
        if (originTerminal == null) {
            return;
        }
        MonitorBlockEntity origin = originTerminal.getOrigin();
        MonitorRenderState renderState = originTerminal.getRenderState(MonitorRenderState::new);
        class_2338 monitorPos = monitor.method_11016();
        long renderFrame = FrameInfo.getRenderFrame();
        if (renderState.lastRenderFrame == renderFrame && !monitorPos.equals((Object)renderState.lastRenderPos)) {
            return;
        }
        lastFrame = renderFrame;
        renderState.lastRenderFrame = renderFrame;
        renderState.lastRenderPos = monitorPos;
        class_2338 originPos = origin.method_11016();
        class_2350 dir = origin.getDirection();
        class_2350 front = origin.getFront();
        float yaw = dir.method_10144();
        float pitch = DirectionUtil.toPitchAngle(front);
        transform.method_22903();
        transform.method_22904((double)(originPos.method_10263() - monitorPos.method_10263()) + 0.5, (double)(originPos.method_10264() - monitorPos.method_10264()) + 0.5, (double)(originPos.method_10260() - monitorPos.method_10260()) + 0.5);
        transform.method_22907(class_7833.field_40715.rotationDegrees(yaw));
        transform.method_22907(class_7833.field_40714.rotationDegrees(pitch));
        transform.method_22904(-0.34375, (double)origin.getHeight() - 0.5 - 0.15625 + 0.0, 0.5);
        double xSize = (double)origin.getWidth() - 0.3125;
        double ySize = (double)origin.getHeight() - 0.3125;
        Terminal terminal = originTerminal.getTerminal();
        if (terminal != null && !ShaderMod.get().isRenderingShadowPass()) {
            int width = terminal.getWidth();
            int height = terminal.getHeight();
            int pixelWidth = width * 6;
            int pixelHeight = height * 9;
            double xScale = xSize / (double)pixelWidth;
            double yScale = ySize / (double)pixelHeight;
            transform.method_22903();
            transform.method_22905((float)xScale, (float)(-yScale), 1.0f);
            Matrix4f matrix = transform.method_23760().method_23761();
            MonitorBlockEntityRenderer.renderTerminal(matrix, originTerminal, renderState, terminal, (float)((double)0.034375f / xScale), (float)((double)0.034375f / yScale));
            transform.method_22909();
        } else {
            FixedWidthFontRenderer.drawEmptyTerminal(FixedWidthFontRenderer.toVertexConsumer(transform, bufferSource.getBuffer(RenderTypes.TERMINAL)), -0.034375f, 0.034375f, (float)(xSize + (double)0.06875f), (float)(-(ySize + (double)0.06875f)));
        }
        transform.method_22909();
    }

    private static void renderTerminal(Matrix4f matrix, ClientMonitor monitor, MonitorRenderState renderState, Terminal terminal, float xMargin, float yMargin) {
        int width = terminal.getWidth();
        int height = terminal.getHeight();
        int pixelWidth = width * 6;
        int pixelHeight = height * 9;
        MonitorRenderer renderType = MonitorBlockEntityRenderer.currentRenderer();
        boolean redraw = monitor.pollTerminalChanged();
        if (renderState.createBuffer(renderType)) {
            redraw = true;
        }
        switch (renderType) {
            case TBO: {
                if (redraw) {
                    ByteBuffer terminalBuffer = MonitorBlockEntityRenderer.getBuffer(width * height * 3);
                    MonitorTextureBufferShader.setTerminalData(terminalBuffer, terminal);
                    DirectBuffers.setBufferData(35882, renderState.tboBuffer, terminalBuffer, 35044);
                    ByteBuffer uniformBuffer = MonitorBlockEntityRenderer.getBuffer(276);
                    MonitorTextureBufferShader.setUniformData(uniformBuffer, terminal);
                    DirectBuffers.setBufferData(35345, renderState.tboUniform, uniformBuffer, 35044);
                }
                int active = GlStateManager._getActiveTexture();
                RenderSystem.activeTexture((int)33987);
                GL11.glBindTexture((int)35882, (int)renderState.tboTexture);
                RenderSystem.activeTexture((int)active);
                MonitorTextureBufferShader shader = RenderTypes.getMonitorTextureBufferShader();
                shader.setupUniform(renderState.tboUniform);
                class_287 buffer = class_289.method_1348().method_1349();
                buffer.method_1328(RenderTypes.MONITOR_TBO.method_23033(), RenderTypes.MONITOR_TBO.method_23031());
                MonitorBlockEntityRenderer.tboVertex((class_4588)buffer, matrix, -xMargin, -yMargin);
                MonitorBlockEntityRenderer.tboVertex((class_4588)buffer, matrix, -xMargin, (float)pixelHeight + yMargin);
                MonitorBlockEntityRenderer.tboVertex((class_4588)buffer, matrix, (float)pixelWidth + xMargin, -yMargin);
                MonitorBlockEntityRenderer.tboVertex((class_4588)buffer, matrix, (float)pixelWidth + xMargin, (float)pixelHeight + yMargin);
                RenderTypes.MONITOR_TBO.method_23012(buffer, class_8251.field_43360);
                break;
            }
            case VBO: {
                DirectVertexBuffer backgroundBuffer = Nullability.assertNonNull(renderState.backgroundBuffer);
                DirectVertexBuffer foregroundBuffer = Nullability.assertNonNull(renderState.foregroundBuffer);
                if (redraw) {
                    int size = DirectFixedWidthFontRenderer.getVertexCount(terminal);
                    MonitorBlockEntityRenderer.renderToBuffer(backgroundBuffer, size, sink -> DirectFixedWidthFontRenderer.drawTerminalBackground(sink, 0.0f, 0.0f, terminal, yMargin, yMargin, xMargin, xMargin));
                    MonitorBlockEntityRenderer.renderToBuffer(foregroundBuffer, size, sink -> {
                        DirectFixedWidthFontRenderer.drawTerminalForeground(sink, 0.0f, 0.0f, terminal);
                        DirectFixedWidthFontRenderer.drawCursor(sink, 0.0f, 0.0f, terminal);
                    });
                }
                Matrix3f oldInverseRotation = RenderSystem.getInverseViewRotationMatrix();
                RenderSystem.setInverseViewRotationMatrix((Matrix3f)IDENTITY_NORMAL);
                RenderTypes.TERMINAL.method_23516();
                backgroundBuffer.method_1353();
                backgroundBuffer.method_34427(matrix, RenderSystem.getProjectionMatrix(), RenderTypes.getTerminalShader());
                RenderSystem.polygonOffset((float)-1.0f, (float)-10.0f);
                RenderSystem.enablePolygonOffset();
                foregroundBuffer.method_1353();
                foregroundBuffer.drawWithShader(matrix, RenderSystem.getProjectionMatrix(), RenderTypes.getTerminalShader(), FixedWidthFontRenderer.isCursorVisible(terminal) && FrameInfo.getGlobalCursorBlink() ? foregroundBuffer.getIndexCount() + 6 : foregroundBuffer.getIndexCount());
                RenderSystem.polygonOffset((float)0.0f, (float)-0.0f);
                RenderSystem.disablePolygonOffset();
                RenderTypes.TERMINAL.method_23518();
                class_291.method_1354();
                RenderSystem.setInverseViewRotationMatrix((Matrix3f)oldInverseRotation);
                break;
            }
            case BEST: {
                throw new IllegalStateException("Impossible: Should never use BEST renderer");
            }
        }
    }

    private static void renderToBuffer(DirectVertexBuffer vbo, int size, Consumer<DirectFixedWidthFontRenderer.QuadEmitter> draw) {
        DirectFixedWidthFontRenderer.QuadEmitter sink = ShaderMod.get().getQuadEmitter(size, MonitorBlockEntityRenderer::getBuffer);
        ByteBuffer buffer = sink.buffer();
        draw.accept(sink);
        buffer.flip();
        vbo.upload(buffer.limit() / sink.format().method_1362(), RenderTypes.TERMINAL.method_23033(), sink.format(), buffer);
    }

    private static void tboVertex(class_4588 builder, Matrix4f matrix, float x, float y) {
        builder.method_22918(matrix, x, y, 0.0f).method_22913(x, y).method_1344();
    }

    private static ByteBuffer getBuffer(int capacity) {
        ByteBuffer buffer = backingBuffer;
        if (buffer == null || buffer.capacity() < capacity) {
            backingBuffer = buffer == null ? class_311.method_1596((int)capacity) : class_311.method_37465((ByteBuffer)buffer, (int)capacity);
            buffer = backingBuffer;
        }
        buffer.clear();
        return buffer;
    }

    public int method_33893() {
        return Config.monitorDistance;
    }

    public static boolean hasRenderedThisFrame() {
        return FrameInfo.getRenderFrame() == lastFrame;
    }

    public static MonitorRenderer currentRenderer() {
        MonitorRenderer current = Config.monitorRenderer;
        if (current == MonitorRenderer.BEST) {
            current = Config.monitorRenderer = MonitorBlockEntityRenderer.bestRenderer();
        }
        return current;
    }

    private static MonitorRenderer bestRenderer() {
        return MonitorRenderer.VBO;
    }

    static {
        lastFrame = -1L;
    }
}

