/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.menu.ServerInputHandler;
import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import net.minecraft.class_1703;
import net.minecraft.class_2540;

public class MouseEventServerMessage
extends ComputerServerMessage {
    private final Action type;
    private final int x;
    private final int y;
    private final int arg;

    public MouseEventServerMessage(class_1703 menu, Action type, int arg, int x, int y) {
        super(menu);
        this.type = type;
        this.arg = arg;
        this.x = x;
        this.y = y;
    }

    public MouseEventServerMessage(class_2540 buf) {
        super(buf);
        this.type = (Action)buf.method_10818(Action.class);
        this.arg = buf.method_10816();
        this.x = buf.method_10816();
        this.y = buf.method_10816();
    }

    @Override
    public void write(class_2540 buf) {
        super.write(buf);
        buf.method_10817((Enum)this.type);
        buf.method_10804(this.arg);
        buf.method_10804(this.x);
        buf.method_10804(this.y);
    }

    @Override
    protected void handle(ServerNetworkContext context, ComputerMenu container) {
        ServerInputHandler input = container.getInput();
        switch (this.type) {
            case CLICK: {
                input.mouseClick(this.arg, this.x, this.y);
                break;
            }
            case DRAG: {
                input.mouseDrag(this.arg, this.x, this.y);
                break;
            }
            case UP: {
                input.mouseUp(this.arg, this.x, this.y);
                break;
            }
            case SCROLL: {
                input.mouseScroll(this.arg, this.x, this.y);
            }
        }
    }

    @Override
    public MessageType<MouseEventServerMessage> type() {
        return NetworkMessages.MOUSE_EVENT;
    }

    public static enum Action {
        CLICK,
        DRAG,
        UP,
        SCROLL;

    }
}

