/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import dan200.computercraft.core.apis.http.NetworkUtils;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ResourceMount;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.metrics.ComputerMBean;
import dan200.computercraft.shared.peripheral.monitor.MonitorWatcher;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3176;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3302;
import net.minecraft.class_39;
import net.minecraft.class_44;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_7706;
import net.minecraft.class_79;
import net.minecraft.class_83;
import net.minecraft.server.MinecraftServer;

public final class CommonHooks {
    public static final class_2960 TREASURE_DISK_LOOT = new class_2960("computercraft", "treasure_disk");
    private static final Set<class_2960> TREASURE_DISK_LOOT_TABLES = Set.of(class_39.field_356, class_39.field_472, class_39.field_842, class_39.field_800, class_39.field_683, class_39.field_885, class_39.field_803, class_39.field_662, class_39.field_484, class_39.field_16751);

    private CommonHooks() {
    }

    public static void onServerTickStart(MinecraftServer server) {
        ServerContext.get(server).tick();
        TickScheduler.tick();
    }

    public static void onServerTickEnd() {
        MonitorWatcher.onTick();
    }

    public static void onServerStarting(MinecraftServer server) {
        if (server instanceof class_3176) {
            class_3176 dediServer = (class_3176)server;
            if (dediServer.method_16705().field_24056) {
                ComputerMBean.register();
            }
        }
        CommonHooks.resetState();
        ServerContext.create(server);
        ComputerMBean.start(server);
    }

    public static void onServerStopped() {
        CommonHooks.resetState();
    }

    private static void resetState() {
        ServerContext.close();
        NetworkUtils.reset();
    }

    public static void onServerChunkUnload(class_2818 chunk) {
        if (!(chunk.method_12200() instanceof class_3218)) {
            throw new IllegalArgumentException("Not a server chunk.");
        }
        TickScheduler.onChunkUnload(chunk);
    }

    public static void onChunkWatch(class_2818 chunk, class_3222 player) {
        MonitorWatcher.onWatch(chunk, player);
    }

    public static void onChunkTicketLevelChanged(class_3218 level, long chunkPos, int oldLevel, int newLevel) {
        TickScheduler.onChunkTicketChanged(level, chunkPos, oldLevel, newLevel);
    }

    @Nullable
    public static class_55.class_56 getExtraLootPool(class_2960 lootTable) {
        if (!lootTable.method_12836().equals("minecraft") || !TREASURE_DISK_LOOT_TABLES.contains(lootTable)) {
            return null;
        }
        return class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)TREASURE_DISK_LOOT)).method_352((class_5658)class_44.method_32448((float)1.0f));
    }

    public static void onDatapackReload(BiConsumer<String, class_3302> addReload) {
        addReload.accept("mounts", (class_3302)ResourceMount.RELOAD_LISTENER);
        addReload.accept("turtle_upgrades", (class_3302)TurtleUpgrades.instance());
        addReload.accept("pocket_upgrades", (class_3302)PocketUpgrades.instance());
    }

    public static boolean onEntitySpawn(class_1297 entity) {
        return DropConsumer.onEntitySpawn(entity);
    }

    public static boolean onLivingDrop(class_1297 entity, class_1799 stack) {
        return DropConsumer.onLivingDrop(entity, stack);
    }

    public static void onBuildCreativeTab(class_5321<class_1761> key, class_1761.class_8128 context, class_1761.class_7704 out) {
        if (key == class_7706.field_41063 && context.comp_1252()) {
            out.method_45421((class_1935)ModRegistry.Items.COMPUTER_COMMAND.get());
        }
    }
}

