/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.details;

import com.google.gson.JsonParseException;
import dan200.computercraft.shared.details.DetailHelpers;
import dan200.computercraft.shared.platform.RegistryWrappers;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class ItemDetails {
    public static void fillBasic(Map<? super String, Object> data, class_1799 stack) {
        data.put("name", DetailHelpers.getId(RegistryWrappers.ITEMS, stack.method_7909()));
        data.put("count", stack.method_7947());
        String hash = NBTUtil.getNBTHash(stack.method_7969());
        if (hash != null) {
            data.put("nbt", hash);
        }
    }

    public static void fill(Map<? super String, Object> data, class_1799 stack) {
        int hideFlags;
        List<Map<String, Object>> enchants;
        List<String> lore;
        class_2487 displayTag;
        data.put("displayName", stack.method_7964().getString());
        data.put("maxCount", stack.method_7914());
        if (stack.method_7963()) {
            data.put("damage", stack.method_7919());
            data.put("maxDamage", stack.method_7936());
        }
        if (stack.method_7909().method_31567(stack)) {
            data.put("durability", (double)stack.method_7909().method_31569(stack) / 13.0);
        }
        data.put("tags", DetailHelpers.getTags(stack.method_40133()));
        data.put("itemGroups", List.of());
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("display", 10) && (displayTag = tag.method_10562("display")).method_10573("Lore", 9) && !(lore = displayTag.method_10554("Lore", 8).stream().map(ItemDetails::parseTextComponent).filter(Objects::nonNull).map(class_2561::getString).toList()).isEmpty()) {
            data.put("lore", lore);
        }
        if (!(enchants = ItemDetails.getAllEnchants(stack, hideFlags = tag != null ? tag.method_10550("HideFlags") : 0)).isEmpty()) {
            data.put("enchantments", enchants);
        }
        if (tag != null && tag.method_10577("Unbreakable") && (hideFlags & 4) == 0) {
            data.put("unbreakable", true);
        }
    }

    @Nullable
    private static class_2561 parseTextComponent(class_2520 x) {
        try {
            return class_2561.class_2562.method_10877((String)x.method_10714());
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    private static List<Map<String, Object>> getAllEnchants(class_1799 stack, int hideFlags) {
        ArrayList<Map<String, Object>> enchants = new ArrayList<Map<String, Object>>(0);
        if (stack.method_7909() instanceof class_1772 && (hideFlags & 0x20) == 0) {
            ItemDetails.addEnchantments(class_1772.method_7806((class_1799)stack), enchants);
        }
        if (stack.method_7942() && (hideFlags & 1) == 0) {
            ItemDetails.addEnchantments(stack.method_7921(), enchants);
        }
        return enchants;
    }

    private static void addEnchantments(class_2499 rawEnchants, ArrayList<Map<String, Object>> enchants) {
        if (rawEnchants.isEmpty()) {
            return;
        }
        enchants.ensureCapacity(enchants.size() + rawEnchants.size());
        for (Map.Entry entry : class_1890.method_22445((class_2499)rawEnchants).entrySet()) {
            class_1887 enchantment = (class_1887)entry.getKey();
            Integer level = (Integer)entry.getValue();
            HashMap<String, Object> enchant = new HashMap<String, Object>(3);
            enchant.put("name", DetailHelpers.getId(RegistryWrappers.ENCHANTMENTS, enchantment));
            enchant.put("level", level);
            enchant.put("displayName", enchantment.method_8179(level.intValue()).getString());
            enchants.add(enchant);
        }
    }
}

