/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.printer;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.common.AbstractContainerBlockEntity;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.container.BasicWorldlyContainer;
import dan200.computercraft.shared.media.items.PrintoutItem;
import dan200.computercraft.shared.peripheral.printer.PrinterBlock;
import dan200.computercraft.shared.peripheral.printer.PrinterMenu;
import dan200.computercraft.shared.peripheral.printer.PrinterPeripheral;
import dan200.computercraft.shared.util.ColourUtils;
import javax.annotation.Nullable;
import net.minecraft.class_1262;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public final class PrinterBlockEntity
extends AbstractContainerBlockEntity
implements BasicWorldlyContainer {
    private static final String NBT_PRINTING = "Printing";
    private static final String NBT_PAGE_TITLE = "PageTitle";
    static final int SLOTS = 13;
    private static final int[] BOTTOM_SLOTS = new int[]{7, 8, 9, 10, 11, 12};
    private static final int[] TOP_SLOTS = new int[]{1, 2, 3, 4, 5, 6};
    private static final int[] SIDE_SLOTS = new int[]{0};
    private final PrinterPeripheral peripheral = new PrinterPeripheral(this);
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)13, (Object)class_1799.field_8037);
    private final NetworkedTerminal page = new NetworkedTerminal(25, 21, true);
    private String pageTitle = "";
    private boolean printing = false;

    public PrinterBlockEntity(class_2591<PrinterBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public IPeripheral peripheral() {
        return this.peripheral;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            this.printing = nbt.method_10577(NBT_PRINTING);
            this.pageTitle = nbt.method_10558(NBT_PAGE_TITLE);
            this.page.readFromNBT(nbt);
        }
        class_1262.method_5429((class_2487)nbt, this.inventory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_11007(class_2487 tag) {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            tag.method_10556(NBT_PRINTING, this.printing);
            tag.method_10582(NBT_PAGE_TITLE, this.pageTitle);
            this.page.writeToNBT(tag);
        }
        class_1262.method_5426((class_2487)tag, this.inventory);
        super.method_11007(tag);
    }

    boolean isPrinting() {
        return this.printing;
    }

    public class_2371<class_1799> getContents() {
        return this.inventory;
    }

    public void method_5431() {
        super.method_5431();
        this.updateBlockState();
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (slot == 0) {
            return PrinterBlockEntity.isInk(stack);
        }
        if (slot >= TOP_SLOTS[0] && slot <= TOP_SLOTS[TOP_SLOTS.length - 1]) {
            return PrinterBlockEntity.isPaper(stack);
        }
        return false;
    }

    public int[] method_5494(class_2350 side) {
        return switch (side) {
            case class_2350.field_11033 -> BOTTOM_SLOTS;
            case class_2350.field_11036 -> TOP_SLOTS;
            default -> SIDE_SLOTS;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    NetworkedTerminal getCurrentPage() {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            return this.printing ? this.page : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startNewPage() {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            if (!this.canInputPage()) {
                return false;
            }
            if (this.printing && !this.outputPage()) {
                return false;
            }
            return this.inputPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean endCurrentPage() {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            return this.printing && this.outputPage();
        }
    }

    int getInkLevel() {
        class_1799 inkStack = (class_1799)this.inventory.get(0);
        return PrinterBlockEntity.isInk(inkStack) ? inkStack.method_7947() : 0;
    }

    int getPaperLevel() {
        int count = 0;
        for (int i = 1; i < 7; ++i) {
            class_1799 paperStack = (class_1799)this.inventory.get(i);
            if (!PrinterBlockEntity.isPaper(paperStack)) continue;
            count += paperStack.method_7947();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPageTitle(String title) {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            if (this.printing) {
                this.pageTitle = title;
            }
        }
    }

    static boolean isInk(class_1799 stack) {
        return ColourUtils.getStackColour(stack) != null;
    }

    static boolean isPaper(class_1799 stack) {
        PrintoutItem printout;
        class_1792 item = stack.method_7909();
        return item == class_1802.field_8407 || item instanceof PrintoutItem && (printout = (PrintoutItem)item).getType() == PrintoutItem.Type.PAGE;
    }

    private boolean canInputPage() {
        class_1799 inkStack = (class_1799)this.inventory.get(0);
        return !inkStack.method_7960() && PrinterBlockEntity.isInk(inkStack) && this.getPaperLevel() > 0;
    }

    private boolean inputPage() {
        class_1799 inkStack = (class_1799)this.inventory.get(0);
        class_1767 dye = ColourUtils.getStackColour(inkStack);
        if (dye == null) {
            return false;
        }
        for (int i = 1; i < 7; ++i) {
            class_1799 paperStack = (class_1799)this.inventory.get(i);
            if (paperStack.method_7960() || !PrinterBlockEntity.isPaper(paperStack)) continue;
            this.page.setTextColour(dye.method_7789());
            this.page.clear();
            if (paperStack.method_7909() instanceof PrintoutItem) {
                this.pageTitle = PrintoutItem.getTitle(paperStack);
                String[] text = PrintoutItem.getText(paperStack);
                String[] textColour = PrintoutItem.getColours(paperStack);
                for (int y = 0; y < this.page.getHeight(); ++y) {
                    this.page.setLine(y, text[y], textColour[y], "");
                }
            } else {
                this.pageTitle = "";
            }
            this.page.setCursorPos(0, 0);
            inkStack.method_7934(1);
            if (inkStack.method_7960()) {
                this.inventory.set(0, (Object)class_1799.field_8037);
            }
            paperStack.method_7934(1);
            if (paperStack.method_7960()) {
                this.inventory.set(i, (Object)class_1799.field_8037);
                this.updateBlockState();
            }
            this.method_5431();
            this.printing = true;
            return true;
        }
        return false;
    }

    private boolean outputPage() {
        int height = this.page.getHeight();
        String[] lines = new String[height];
        String[] colours = new String[height];
        for (int i = 0; i < height; ++i) {
            lines[i] = this.page.getLine(i).toString();
            colours[i] = this.page.getTextColourLine(i).toString();
        }
        class_1799 stack = PrintoutItem.createSingleFromTitleAndText(this.pageTitle, lines, colours);
        for (int slot : BOTTOM_SLOTS) {
            if (!((class_1799)this.inventory.get(slot)).method_7960()) continue;
            this.inventory.set(slot, (Object)stack);
            this.updateBlockState();
            this.method_5431();
            this.printing = false;
            return true;
        }
        return false;
    }

    private void updateBlockState() {
        class_1799 stack;
        int i;
        boolean top = false;
        boolean bottom = false;
        for (i = 1; i < 7; ++i) {
            stack = (class_1799)this.inventory.get(i);
            if (stack.method_7960() || !PrinterBlockEntity.isPaper(stack)) continue;
            top = true;
            break;
        }
        for (i = 7; i < 13; ++i) {
            stack = (class_1799)this.inventory.get(i);
            if (stack.method_7960() || !PrinterBlockEntity.isPaper(stack)) continue;
            bottom = true;
            break;
        }
        this.updateBlockState(top, bottom);
    }

    private void updateBlockState(boolean top, boolean bottom) {
        if (this.field_11865 || this.field_11863 == null) {
            return;
        }
        class_2680 state = this.method_11010();
        if ((Boolean)state.method_11654((class_2769)PrinterBlock.TOP) == top && (Boolean)state.method_11654((class_2769)PrinterBlock.BOTTOM) == bottom) {
            return;
        }
        this.method_10997().method_8501(this.method_11016(), (class_2680)((class_2680)state.method_11657((class_2769)PrinterBlock.TOP, (Comparable)Boolean.valueOf(top))).method_11657((class_2769)PrinterBlock.BOTTOM, (Comparable)Boolean.valueOf(bottom)));
    }

    protected class_1703 method_5465(int id, class_1661 inventory) {
        return new PrinterMenu(id, inventory, this);
    }
}

