/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.lua;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaValues;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public interface LuaTable<K, V>
extends Map<K, V> {
    default public int length() {
        int size = 0;
        while (this.containsKey(size + 1)) {
            ++size;
        }
        return size;
    }

    default public double getDouble(int index) throws LuaException {
        Object value = this.get(index);
        if (!(value instanceof Number)) {
            throw LuaValues.badTableItem(index, "number", LuaValues.getType(value));
        }
        Number number = (Number)value;
        return number.doubleValue();
    }

    default public double getDouble(String key) throws LuaException {
        Object value = this.get(key);
        if (!(value instanceof Number)) {
            throw LuaValues.badField(key, "number", LuaValues.getType(value));
        }
        Number number = (Number)value;
        return number.doubleValue();
    }

    default public long getLong(int index) throws LuaException {
        Object value = this.get(index);
        if (!(value instanceof Number)) {
            throw LuaValues.badTableItem(index, "number", LuaValues.getType(value));
        }
        Number number = (Number)value;
        LuaValues.checkFiniteIndex(index, number.doubleValue());
        return number.longValue();
    }

    default public long getLong(String key) throws LuaException {
        Object value = this.get(key);
        if (!(value instanceof Number)) {
            throw LuaValues.badField(key, "number", LuaValues.getType(value));
        }
        Number number = (Number)value;
        LuaValues.checkFiniteField(key, number.doubleValue());
        return number.longValue();
    }

    default public int getInt(int index) throws LuaException {
        return (int)this.getLong(index);
    }

    default public int getInt(String key) throws LuaException {
        return (int)this.getLong(key);
    }

    default public double getFiniteDouble(int index) throws LuaException {
        return LuaValues.checkFiniteIndex(index, this.getDouble(index));
    }

    default public double getFiniteDouble(String key) throws LuaException {
        return LuaValues.checkFiniteField(key, this.getDouble(key));
    }

    default public boolean getBoolean(int index) throws LuaException {
        Object value = this.get(index);
        if (!(value instanceof Boolean)) {
            throw LuaValues.badTableItem(index, "boolean", LuaValues.getType(value));
        }
        Boolean bool = (Boolean)value;
        return bool;
    }

    default public boolean getBoolean(String key) throws LuaException {
        Object value = this.get(key);
        if (!(value instanceof Boolean)) {
            throw LuaValues.badField(key, "boolean", LuaValues.getType(value));
        }
        Boolean bool = (Boolean)value;
        return bool;
    }

    default public String getString(int index) throws LuaException {
        Object value = this.get(index);
        if (!(value instanceof String)) {
            throw LuaValues.badTableItem(index, "string", LuaValues.getType(value));
        }
        String string = (String)value;
        return string;
    }

    default public String getString(String key) throws LuaException {
        Object value = this.get(key);
        if (!(value instanceof String)) {
            throw LuaValues.badField(key, "string", LuaValues.getType(value));
        }
        String string = (String)value;
        return string;
    }

    default public Map<?, ?> getTable(int index) throws LuaException {
        Object value = this.get(index);
        if (!(value instanceof Map)) {
            throw LuaValues.badTableItem(index, "table", LuaValues.getType(value));
        }
        Map table = (Map)value;
        return table;
    }

    default public Map<?, ?> getTable(String key) throws LuaException {
        Object value = this.get(key);
        if (!(value instanceof Map)) {
            throw LuaValues.badField(key, "table", LuaValues.getType(value));
        }
        Map table = (Map)value;
        return table;
    }

    default public Optional<Double> optDouble(int index) throws LuaException {
        Object value = this.get(index);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Number)) {
            throw LuaValues.badTableItem(index, "number", LuaValues.getType(value));
        }
        Number number = (Number)value;
        return Optional.of(number.doubleValue());
    }

    default public Optional<Double> optDouble(String key) throws LuaException {
        Object value = this.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Number)) {
            throw LuaValues.badField(key, "number", LuaValues.getType(value));
        }
        Number number = (Number)value;
        return Optional.of(number.doubleValue());
    }

    default public Optional<Long> optLong(int index) throws LuaException {
        Object value = this.get(index);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Number)) {
            throw LuaValues.badTableItem(index, "number", LuaValues.getType(value));
        }
        Number number = (Number)value;
        LuaValues.checkFiniteIndex(index, number.doubleValue());
        return Optional.of(number.longValue());
    }

    default public Optional<Long> optLong(String key) throws LuaException {
        Object value = this.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Number)) {
            throw LuaValues.badField(key, "number", LuaValues.getType(value));
        }
        Number number = (Number)value;
        LuaValues.checkFiniteField(key, number.doubleValue());
        return Optional.of(number.longValue());
    }

    default public Optional<Integer> optInt(int index) throws LuaException {
        return this.optLong(index).map(Long::intValue);
    }

    default public Optional<Integer> optInt(String key) throws LuaException {
        return this.optLong(key).map(Long::intValue);
    }

    default public Optional<Double> optFiniteDouble(int index) throws LuaException {
        Optional<Double> value = this.optDouble(index);
        if (value.isPresent()) {
            LuaValues.checkFiniteIndex(index, value.get());
        }
        return value;
    }

    default public Optional<Double> optFiniteDouble(String key) throws LuaException {
        Optional<Double> value = this.optDouble(key);
        if (value.isPresent()) {
            LuaValues.checkFiniteField(key, value.get());
        }
        return value;
    }

    default public Optional<Boolean> optBoolean(int index) throws LuaException {
        Object value = this.get(index);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Boolean)) {
            throw LuaValues.badTableItem(index, "boolean", LuaValues.getType(value));
        }
        Boolean bool = (Boolean)value;
        return Optional.of(bool);
    }

    default public Optional<Boolean> optBoolean(String key) throws LuaException {
        Object value = this.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Boolean)) {
            throw LuaValues.badField(key, "boolean", LuaValues.getType(value));
        }
        Boolean bool = (Boolean)value;
        return Optional.of(bool);
    }

    default public Optional<String> optString(int index) throws LuaException {
        Object value = this.get(index);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof String)) {
            throw LuaValues.badTableItem(index, "string", LuaValues.getType(value));
        }
        String string = (String)value;
        return Optional.of(string);
    }

    default public Optional<String> optString(String key) throws LuaException {
        Object value = this.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof String)) {
            throw LuaValues.badField(key, "string", LuaValues.getType(value));
        }
        String string = (String)value;
        return Optional.of(string);
    }

    default public Optional<Map<?, ?>> optTable(int index) throws LuaException {
        Object value = this.get(index);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Map)) {
            throw LuaValues.badTableItem(index, "table", LuaValues.getType(value));
        }
        Map table = (Map)value;
        return Optional.of(table);
    }

    default public Optional<Map<?, ?>> optTable(String key) throws LuaException {
        Object value = this.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Map)) {
            throw LuaValues.badField(key, "table", LuaValues.getType(value));
        }
        Map table = (Map)value;
        return Optional.of(table);
    }

    @Override
    default public @Nullable V put(K o, V o2) {
        throw new UnsupportedOperationException("Cannot modify LuaTable");
    }

    @Override
    default public V remove(Object o) {
        throw new UnsupportedOperationException("Cannot modify LuaTable");
    }

    @Override
    default public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException("Cannot modify LuaTable");
    }

    @Override
    default public void clear() {
        throw new UnsupportedOperationException("Cannot modify LuaTable");
    }
}

