/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.shared.platform.ContainerTransfer;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2350;

public class TurtleUtil {
    public static ContainerTransfer getOffsetInventory(ITurtleAccess turtle) {
        return PlatformHelper.get().wrapContainer(turtle.getInventory()).rotate(turtle.getSelectedSlot());
    }

    public static ContainerTransfer getSelectedSlot(ITurtleAccess turtle) {
        return PlatformHelper.get().wrapContainer(turtle.getInventory()).singleSlot(turtle.getSelectedSlot());
    }

    public static void storeItemOrDrop(ITurtleAccess turtle, class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        if (turtle.isRemoved()) {
            WorldUtil.dropItemStack(turtle.getLevel(), turtle.getPosition(), null, stack);
            return;
        }
        class_1799 remainder = InventoryUtil.storeItemsFromOffset(turtle.getInventory(), stack, turtle.getSelectedSlot());
        if (remainder.method_7960()) {
            return;
        }
        WorldUtil.dropItemStack(turtle.getLevel(), turtle.getPosition(), turtle.getDirection().method_10153(), remainder);
    }

    public static Function<class_1799, class_1799> dropConsumer(ITurtleAccess turtle) {
        return stack -> turtle.isRemoved() ? stack : InventoryUtil.storeItemsFromOffset(turtle.getInventory(), stack, turtle.getSelectedSlot());
    }

    public static void stopConsuming(ITurtleAccess turtle) {
        class_2350 direction = turtle.isRemoved() ? null : turtle.getDirection().method_10153();
        DropConsumer.clearAndDrop(turtle.getLevel(), turtle.getPosition(), direction);
    }
}

