/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica;

import cc.cosmetica.api.Cape;
import cc.cosmetica.api.CosmeticaAPI;
import cc.cosmetica.api.CustomCape;
import cc.cosmetica.api.Model;
import cc.cosmetica.api.ShoulderBuddies;
import cc.cosmetica.api.User;
import cc.cosmetica.api.UserInfo;
import cc.cosmetica.cosmetica.Authentication;
import cc.cosmetica.cosmetica.CosmeticaSkinManager;
import cc.cosmetica.cosmetica.ThreadPool;
import cc.cosmetica.cosmetica.config.ArmourConflictHandlingMode;
import cc.cosmetica.cosmetica.config.CosmeticaConfig;
import cc.cosmetica.cosmetica.config.DefaultSettingsConfig;
import cc.cosmetica.cosmetica.cosmetics.CapeData;
import cc.cosmetica.cosmetica.cosmetics.Hats;
import cc.cosmetica.cosmetica.cosmetics.PlayerData;
import cc.cosmetica.cosmetica.cosmetics.model.BakableModel;
import cc.cosmetica.cosmetica.cosmetics.model.Models;
import cc.cosmetica.cosmetica.screens.LoadingScreen;
import cc.cosmetica.cosmetica.screens.fakeplayer.Playerish;
import cc.cosmetica.cosmetica.utils.DebugMode;
import cc.cosmetica.cosmetica.utils.NamedThreadFactory;
import cc.cosmetica.cosmetica.utils.TextComponents;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_327;
import net.minecraft.class_3300;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_591;
import net.minecraft.class_640;
import net.minecraft.class_742;
import net.minecraft.class_757;
import net.minecraft.class_898;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class Cosmetica
implements ClientModInitializer {
    public static String authServer;
    public static String websiteHost;
    public static CosmeticaAPI api;
    public static class_1657 farPickPlayer;
    public static class_239 farPickHitResult;
    public static class_2561 displayNext;
    public static String currentServerAddressCache;
    public static final Logger LOGGER;
    private static final ExecutorService MAIN_POOL;
    private static CosmeticaConfig config;
    private static DefaultSettingsConfig defaultSettingsConfig;
    private static Path configDirectory;
    private static Path cacheDirectory;
    private static boolean mayShowWelcomeScreen;
    private static OptionalLong toto;
    private static final Pattern UNDASHED_UUID_GAPS;
    private static final String UUID_DASHIFIER_REPLACEMENT = "$1-$2-$3-$4-$5";
    private static final List<String> splashes;
    private static int africaFails;

    private static void addSplash(String splash) {
        splashes.add(splash);
    }

    public static Collection<String> getSplashes() {
        return splashes;
    }

    public static CosmeticaConfig getConfig() {
        return config;
    }

    public static Path getConfigDirectory() {
        return configDirectory;
    }

    public static Path getCacheDirectory() {
        return cacheDirectory;
    }

    public static DefaultSettingsConfig getDefaultSettingsConfig() {
        return defaultSettingsConfig;
    }

    public static boolean mayShowWelcomeScreen() {
        return mayShowWelcomeScreen;
    }

    public void onInitializeClient() {
        block4: {
            config = new CosmeticaConfig(FabricLoader.getInstance().getConfigDir().resolve("cosmetica").resolve("cosmetica.properties"));
            Cosmetica.setupDirectories();
            try {
                config.initialize();
                defaultSettingsConfig.initialize();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to load config, falling back to defaults!");
                e.printStackTrace();
            }
            try {
                File apiCache = new File(cacheDirectory.toFile(), "cosmetica_get_api_cache.json");
                CosmeticaAPI.setAPICache((File)apiCache);
                CosmeticaAPI.setDefaultForceHttps((boolean)config.paranoidHttps());
                api = CosmeticaAPI.newUnauthenticatedInstance();
                Cosmetica.runOffthread(() -> {
                    try {
                        api.setUrlLogger(DebugMode::logURL);
                        DebugMode.log("Finished retrieving API Url. Conclusion: the API should be contacted at " + CosmeticaAPI.getAPIServer(), new Object[0]);
                        LOGGER.info(CosmeticaAPI.getMessage());
                        if (config.shouldAddCosmeticaSplashMessage()) {
                            Cosmetica.addSplash(CosmeticaAPI.getMessage());
                        }
                        authServer = CosmeticaAPI.getAuthServer();
                        websiteHost = CosmeticaAPI.getWebsite();
                        DebugMode.log("Checking Version...", new Object[0]);
                        api.checkVersion(class_155.method_16673().method_48018(), ((ModContainer)FabricLoader.getInstance().getModContainer("cosmetica").get()).getMetadata().getVersion().getFriendlyString()).ifSuccessfulOrElse(versionInfo -> {
                            DebugMode.log("Handling version check response", new Object[0]);
                            String s = versionInfo.minecraftMessage();
                            if (!s.isEmpty()) {
                                LOGGER.warn(versionInfo.plainMessage());
                                if (versionInfo.isVital() || Cosmetica.getConfig().shouldShowNonVitalUpdateMessages()) {
                                    displayNext = TextComponents.literal(s);
                                }
                            }
                            mayShowWelcomeScreen = versionInfo.megaInvasiveTutorial();
                        }, Cosmetica.logErr("Error checking version"));
                        Authentication.runAuthentication();
                    }
                    catch (Exception e) {
                        LOGGER.error("Error retrieving API Url. Mod functionality will be disabled!");
                        e.printStackTrace();
                    }
                }, ThreadPool.GENERAL_THREADS);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                if (!"Could not receive Cosmetica API host".equals(e.getMessage())) break block4;
                LOGGER.warn("Authenticated functionality will be disabled!");
            }
        }
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("cosmetica", "cache_clearer");
            }

            public void method_14491(class_3300 resourceManager) {
                Models.resetTextureBasedCaches();
            }
        });
        GameProfile userProfile = class_310.method_1551().method_1548().method_1677();
        GameProfile profileCopy = new GameProfile(userProfile.getId(), userProfile.getName());
        class_310.method_1551().method_1495().fillProfileProperties(profileCopy, true);
        Cosmetica.runOffthread(() -> Cosmetica.forwardPublicUserInfoToNametag(profileCopy), ThreadPool.GENERAL_THREADS);
        Authentication.runSyncSettingsThread();
    }

    private static void setupDirectories() {
        configDirectory = FabricLoader.getInstance().getConfigDir().resolve("cosmetica");
        defaultSettingsConfig = new DefaultSettingsConfig(FabricLoader.getInstance().getConfigDir().resolve("cosmetica").resolve("default-settings.properties"));
        Path minecraftDir = Cosmetica.findDefaultInstallDir("minecraft");
        cacheDirectory = Files.isDirectory(minecraftDir, new LinkOption[0]) ? minecraftDir.resolve(".cosmetica") : FabricLoader.getInstance().getGameDir().resolve(".cosmetica");
        if (!Files.exists(cacheDirectory, new LinkOption[0])) {
            try {
                Files.createDirectory(cacheDirectory, new FileAttribute[0]);
                if (class_156.method_668() == class_156.class_158.field_1133) {
                    try {
                        Files.setAttribute(cacheDirectory, "dos:hidden", true, new LinkOption[0]);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to set dos:hidden for cache file on windows", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating cache directory", e);
            }
        }
    }

    public static boolean isProbablyNPC(UUID uuid) {
        return uuid.version() == 2;
    }

    private static String loadOrCache(File file, @Nullable String value) {
        block13: {
            try {
                if (value != null) {
                    file.createNewFile();
                    try (FileWriter writer = new FileWriter(file);){
                        writer.write(value);
                        break block13;
                    }
                }
                if (!file.isFile()) break block13;
                try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                    value = reader.readLine().trim();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    private static Path findDefaultInstallDir(String application) {
        Path dir;
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        if (os.contains("win") && System.getenv("APPDATA") != null) {
            dir = Paths.get(System.getenv("APPDATA"), new String[0]).resolve("." + application);
        } else {
            String home = System.getProperty("user.home", ".");
            Path homeDir = Paths.get(home, new String[0]);
            dir = os.contains("mac") ? homeDir.resolve("Library").resolve("Application Support").resolve(application) : homeDir.resolve("." + application);
        }
        return dir.toAbsolutePath().normalize();
    }

    public static void onShutdownClient() {
        try {
            MAIN_POOL.shutdownNow();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public static String dashifyUUID(String uuid) {
        return UNDASHED_UUID_GAPS.matcher(uuid).replaceAll(UUID_DASHIFIER_REPLACEMENT);
    }

    public static String base64Ip(InetSocketAddress ip) {
        byte[] arr = (ip.getAddress().getHostAddress() + ":" + ip.getPort()).getBytes(StandardCharsets.UTF_8);
        return Base64.encodeBase64String((byte[])arr);
    }

    public static void safari(class_310 minecraft, boolean yourFirstRodeo, boolean ignoreSelf) {
        SocketAddress socketAddress;
        InetSocketAddress prideRock;
        InetSocketAddress inetSocketAddress = prideRock = minecraft.method_1542() ? new InetSocketAddress("127.0.0.1", 25565) : null;
        if (prideRock == null && (socketAddress = minecraft.method_1562().method_48296().method_10755()) instanceof InetSocketAddress) {
            InetSocketAddress ip;
            prideRock = ip = (InetSocketAddress)socketAddress;
        }
        if (prideRock != null) {
            Cosmetica.safari(prideRock, yourFirstRodeo, ignoreSelf);
        }
    }

    public static void safari(InetSocketAddress prideRock, boolean yourFirstRodeo, boolean ignoreSelf) {
        if (api != null && api.isAuthenticated()) {
            DebugMode.log("Thread for safari {}", Thread.currentThread().getName());
            api.everyThirtySecondsInAfricaHalfAMinutePasses(prideRock, yourFirstRodeo || !toto.isPresent() ? 0L : toto.getAsLong()).ifSuccessfulOrElse(theLionSleepsTonight -> {
                for (String notification : theLionSleepsTonight.getNotifications()) {
                    try {
                        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)TextComponents.literal("\u00a76\u00a7lCosmetica\u00a7f \u00a7l>\u00a77 ").method_10852(TextComponents.chatEncode(notification)));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error sending cosmetica notification.", (Throwable)e);
                    }
                }
                toto = OptionalLong.of(theLionSleepsTonight.getTimestamp());
                if (!yourFirstRodeo) {
                    DebugMode.log("Processing updates found on the safari.", new Object[0]);
                    for (User individual : theLionSleepsTonight.getNeedsUpdating()) {
                        UUID serverUuid;
                        UUID uuid = individual.getUUID();
                        DebugMode.log("Your amazing lion king with expected uuid {} seems to be requesting we update his (or her, their, faer, ...) cosmetics! :lion:", uuid);
                        if (PlayerData.has(uuid)) {
                            PlayerData.clear(uuid);
                            if (ignoreSelf || !uuid.equals(class_310.method_1551().field_1724.method_5667())) continue;
                            PlayerData.get((class_1657)class_310.method_1551().field_1724);
                            continue;
                        }
                        DebugMode.log("Lol cringe they went scampering into a bush or something!", new Object[0]);
                        String username = individual.getUsername();
                        class_640 info = class_310.method_1551().method_1562().method_2874(username);
                        if (info == null || !PlayerData.has(serverUuid = info.method_2966().getId())) continue;
                        DebugMode.log("Found them :). They were hiding at uuid {}", serverUuid);
                        PlayerData.clear(serverUuid);
                        if (ignoreSelf || !username.equals(String.valueOf(class_310.method_1551().field_1724.method_5477()))) continue;
                        PlayerData.get((class_1657)class_310.method_1551().field_1724);
                    }
                }
                africaFails = 0;
            }, Cosmetica.logErr("Error checking for cosmetic updates on the remote server", e -> {
                if (africaFails < 3) {
                    ++africaFails;
                    return true;
                }
                return DebugMode.elevatedLogging();
            }));
        }
    }

    public static void cinder(class_310 minecraft, float yawProbably) {
        class_1297 entity = minecraft.method_1560();
        if (entity != null && minecraft.field_1687 != null) {
            minecraft.method_16011().method_15396("snipe");
            farPickPlayer = null;
            double maxDist = 64.0;
            farPickHitResult = entity.method_5745(64.0, yawProbably, false);
            class_243 eyePosition = entity.method_5836(yawProbably);
            double maxDistSqr = 64.0;
            maxDistSqr *= maxDistSqr;
            if (farPickHitResult != null) {
                maxDistSqr = farPickHitResult.method_17784().method_1025(eyePosition);
            }
            class_243 view = entity.method_5828(1.0f);
            class_243 castTowards = eyePosition.method_1031(view.field_1352 * 64.0, view.field_1351 * 64.0, view.field_1350 * 64.0);
            float inflation = 1.0f;
            class_238 selectionBoundingBox = entity.method_5829().method_18804(view.method_1021(64.0)).method_1009(1.0, 1.0, 1.0);
            class_3966 entityHitResult = class_1675.method_18075((class_1297)entity, (class_243)eyePosition, (class_243)castTowards, (class_238)selectionBoundingBox, e -> !e.method_7325() && e.method_5863(), (double)maxDistSqr);
            if (entityHitResult != null) {
                class_1297 entity2 = entityHitResult.method_17782();
                class_243 resultLocation = entityHitResult.method_17784();
                double distance = eyePosition.method_1025(resultLocation);
                if (distance < maxDistSqr || farPickHitResult == null) {
                    farPickHitResult = entityHitResult;
                    if (entity2 instanceof class_1657) {
                        class_1657 player;
                        farPickPlayer = player = (class_1657)entity2;
                    }
                }
            }
            minecraft.method_16011().method_15407();
        }
    }

    public static boolean handleComponentClicked(class_310 minecraft, class_2583 style) {
        if (style != null && style.method_10970() != null && style.method_10970().method_10845() == class_2558.class_2559.field_11748 && style.method_10970().method_10844().equals("cosmetica.customise")) {
            minecraft.method_1507((class_437)new LoadingScreen(null, class_310.method_1551().field_1690, 1));
            return true;
        }
        return false;
    }

    public static void runOffthread(Runnable runnable, ThreadPool pool) {
        if (Thread.currentThread().getName().startsWith("Cosmetica")) {
            runnable.run();
        } else {
            MAIN_POOL.execute(runnable);
        }
    }

    public static boolean shouldRenderUpsideDown(class_1657 player) {
        return PlayerData.get(player).upsideDown();
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    public static <K, V, V2> Map<K, V2> map(Map<K, V> original, Function<V, V2> mapper) {
        HashMap result = new HashMap();
        original.forEach((k, v) -> result.put(k, mapper.apply(v)));
        return result;
    }

    public static String pickFirst(String ... strings) {
        for (String s : strings) {
            if (s.isEmpty()) continue;
            return s;
        }
        return "";
    }

    public static PlayerData newPlayerData(UserInfo info, UUID uuid) {
        List hats = info.getHats();
        Optional shoulderBuddies = info.getShoulderBuddies();
        Optional backBling = info.getBackBling();
        Optional cloak = info.getCape();
        String icon = info.getIcon();
        boolean isSelf = uuid.toString().equals(Cosmetica.dashifyUUID(class_310.method_1551().method_1548().method_1673()));
        Optional leftShoulderBuddy = shoulderBuddies.isEmpty() ? Optional.empty() : ((ShoulderBuddies)shoulderBuddies.get()).getLeft();
        Optional rightShoulderBuddy = shoulderBuddies.isEmpty() ? Optional.empty() : ((ShoulderBuddies)shoulderBuddies.get()).getRight();
        return new PlayerData(info.getLore(), info.isUpsideDown(), icon.isEmpty() ? null : CosmeticaSkinManager.processIcon(icon), info.isOnline() || isSelf, info.getPrefix(), info.getSuffix(), hats.stream().map(Models::createBakableModel).collect(Collectors.toList()), cloak.isPresent() ? new CapeData(CosmeticaSkinManager.processCape((Cape)cloak.get()), Cosmetica.pickFirst(((Cape)cloak.get()).getName(), ((Cape)cloak.get()).getOrigin() + " Cape"), ((Cape)cloak.get()).getId(), !((Cape)cloak.get()).isCosmeticaAlternative() && !(cloak.get() instanceof CustomCape), ((Cape)cloak.get()).getOrigin()) : CapeData.NO_CAPE, leftShoulderBuddy.isEmpty() ? null : Models.createBakableModel((Model)leftShoulderBuddy.get()), rightShoulderBuddy.isEmpty() ? null : Models.createBakableModel((Model)rightShoulderBuddy.get()), backBling.isEmpty() ? null : Models.createBakableModel((Model)backBling.get()), CosmeticaSkinManager.processSkin(info.getSkin(), uuid), info.isSlim());
    }

    public static void forwardPublicUserInfoToNametag(GameProfile profile) {
        Property textureProperty = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        if (textureProperty != null && textureProperty.hasSignature()) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setConnectTimeout(20000).setSocketTimeout(20000).build();
            try (CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();){
                HttpPut put = new HttpPut("https://ingest.namet.ag/");
                String request = String.format("{\"value\": \"%s\", \"signature\": \"%s\"}", textureProperty.getValue(), textureProperty.getSignature());
                put.setEntity((HttpEntity)new StringEntity(request, ContentType.APPLICATION_JSON));
                try (CloseableHttpResponse response = client.execute((HttpUriRequest)put);){
                    HttpEntity entity = response.getEntity();
                    String responseBody = EntityUtils.toString((HttpEntity)entity);
                    DebugMode.log("Namet.ag Response: {}", responseBody);
                }
            }
            catch (IOException e) {
                LOGGER.error("Error submitting to namet.ag", (Throwable)e);
            }
        }
    }

    public static void renderLore(class_898 entityRenderDispatcher, class_1297 entity, class_591<class_742> playerModel, class_4587 stack, class_4597 multiBufferSource, class_327 font, int packedLight) {
        class_1657 player;
        UUID lookupId;
        if (entity instanceof class_1657 && (lookupId = (player = (class_1657)entity).method_5667()) != null) {
            double squaredDistance = entityRenderDispatcher.method_23168(entity);
            PlayerData data = PlayerData.get(player);
            if (squaredDistance <= 4096.0) {
                Cosmetica.renderLore(stack, entityRenderDispatcher.method_24197(), font, multiBufferSource, data.lore(), Hats.OVERRIDDEN.getList(() -> data.hats()), player.method_6084(class_1304.field_6169), !player.method_6113(), entity.method_21751(), data.upsideDown(), entity.method_17682(), playerModel.field_3398.field_3654, packedLight);
            }
        }
    }

    public static void renderLore(class_4587 stack, Quaternionf cameraOrientation, class_327 font, class_4597 multiBufferSource, String lore, List<BakableModel> hats, boolean wearingHelmet, boolean doNametagShift, boolean discrete, boolean upsideDown, float playerHeight, float xRotHead, int packedLight) {
        if (!upsideDown) {
            float hatTopY = 0.0f;
            float torsoFixedHatTopY = 0.0f;
            if (doNametagShift) {
                for (BakableModel hat : hats) {
                    if (config.getHatConflictMode() == ArmourConflictHandlingMode.HIDE_COSMETICS && (hat.extraInfo() & 1) == 0 && wearingHelmet) continue;
                    if ((hat.extraInfo() & 2) == 0) {
                        hatTopY = Math.max(hatTopY, (float)hat.bounds().y1());
                        continue;
                    }
                    torsoFixedHatTopY = Math.max(torsoFixedHatTopY, (float)hat.bounds().y1());
                }
            }
            if (hatTopY > 0.0f || torsoFixedHatTopY > 0.0f) {
                float normalizedAngleMultiplier = (float)(-((double)Math.abs(xRotHead) / 1.57 - 1.0));
                float lookAngleMultiplier = normalizedAngleMultiplier == 0.49974638f ? 0.0f : normalizedAngleMultiplier;
                stack.method_46416(0.0f, Math.max(hatTopY * lookAngleMultiplier, torsoFixedHatTopY) / 16.0f, 0.0f);
            }
        }
        if (!lore.equals("")) {
            class_5250 component = TextComponents.literal(lore);
            boolean fullyRender = !discrete;
            float height = playerHeight + 0.25f;
            stack.method_22904(0.0, 0.1, 0.0);
            stack.method_22903();
            stack.method_22904(0.0, (double)height, 0.0);
            stack.method_22907(cameraOrientation);
            stack.method_22905(-0.025f, -0.025f, 0.025f);
            stack.method_22905(0.75f, 0.75f, 0.75f);
            Matrix4f textModel = stack.method_23760().method_23761();
            float backgroundOpacity = class_310.method_1551().field_1690.method_19343(0.25f);
            int alphaARGB = (int)(backgroundOpacity * 255.0f) << 24;
            float xOffset = -font.method_27525((class_5348)component) / 2;
            font.method_30882((class_2561)component, xOffset, 0.0f, 0x20FFFFFF, false, textModel, multiBufferSource, fullyRender ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, alphaARGB, packedLight);
            if (fullyRender) {
                font.method_30882((class_2561)component, xOffset, 0.0f, -1, false, textModel, multiBufferSource, class_327.class_6415.field_33993, 0, packedLight);
            }
            stack.method_22909();
        }
    }

    public static void renderTabIcon(class_4587 stack, int x, int y, UUID playerUUID, String name) {
        PlayerData data = PlayerData.get(playerUUID, name, false);
        class_2960 iconTexture = data.icon();
        if (iconTexture != null) {
            RenderSystem.enableBlend();
            Cosmetica.renderTexture(stack.method_23760().method_23761(), iconTexture, x + 1, x + 1 + 8, y, y + 8, 0, data.online() ? 1.0f : 0.5f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void renderIcon(class_4587 poseStack, class_4597 bufferSource, Playerish player, class_327 font, int packedLight, class_2561 component) {
        PlayerData playerData = player.getCosmeticaPlayerData();
        class_2960 iconTexture = playerData.icon();
        if (iconTexture != null) {
            float xOffset = (float)(-font.method_27525((class_5348)component)) / 2.0f;
            poseStack.method_22903();
            poseStack.method_46416(xOffset + 1.0f, 0.0f, 0.0f);
            Cosmetica.renderTextureLikeText(poseStack.method_23760().method_23761(), bufferSource, iconTexture, -1, 9, -1, 9, 0, packedLight, playerData.online() ? 1.0f : 0.5f, player.renderDiscreteNametag());
            poseStack.method_22909();
        }
    }

    private static Vector3f rotateVertex(Vector3f vertex, Vector3f origin, class_2350.class_2351 axis, float angle) {
        vertex.sub((Vector3fc)origin);
        if (axis == class_2350.class_2351.field_11048) {
            return new Vector3f(vertex.x() + origin.x(), (float)((double)vertex.y() * Math.cos(angle) - (double)vertex.z() * Math.sin(angle)) + origin.y(), (float)((double)vertex.z() * Math.cos(angle) + (double)vertex.y() * Math.sin(angle)) + origin.z());
        }
        if (axis == class_2350.class_2351.field_11052) {
            return new Vector3f((float)((double)vertex.x() * Math.cos(angle) + (double)vertex.z() * Math.sin(angle)) + origin.x(), vertex.y() + origin.y(), (float)((double)vertex.z() * Math.cos(angle) - (double)vertex.x() * Math.sin(angle)) + origin.z());
        }
        if (axis == class_2350.class_2351.field_11051) {
            return new Vector3f((float)((double)vertex.x() * Math.cos(angle) - (double)vertex.y() * Math.sin(angle)) + origin.x(), (float)((double)vertex.y() * Math.cos(angle) + (double)vertex.x() * Math.sin(angle)) + origin.y(), vertex.z() + origin.z());
        }
        throw new UnsupportedOperationException();
    }

    public static void renderTexture(Matrix4f matrix4f, class_2960 texture, int x0, int x1, int y0, int y1, int z, float transparency) {
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22918(matrix4f, (float)x0, (float)y1, (float)z).method_22913(0.0f, 1.0f).method_22915(1.0f, 1.0f, 1.0f, transparency).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)z).method_22913(1.0f, 1.0f).method_22915(1.0f, 1.0f, 1.0f, transparency).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y0, (float)z).method_22913(1.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, transparency).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x0, (float)y0, (float)z).method_22913(0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, transparency).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    private static int getMaxLight() {
        return 0xF000F0;
    }

    public static void renderTextureLikeText(Matrix4f matrix4f, class_4597 bufferSource, class_2960 texture, int x0, int x1, int y0, int y1, int z, int packedLight, float alpha, boolean discrete) {
        if (!discrete) {
            RenderSystem.enableBlend();
            RenderSystem.disableDepthTest();
            int skylight = packedLight >> 20 & 0xF;
            int blocklight = packedLight >> 4 & 0xF;
            float shaderColour = (float)Math.max(skylight, blocklight) / 15.0f;
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)texture);
            RenderSystem.setShaderColor((float)shaderColour, (float)shaderColour, (float)shaderColour, (float)(0.25f * alpha));
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_22918(matrix4f, (float)x0, (float)y1, (float)z).method_22913(0.0f, 1.0f).method_1344();
            bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)z).method_22913(1.0f, 1.0f).method_1344();
            bufferBuilder.method_22918(matrix4f, (float)x1, (float)y0, (float)z).method_22913(1.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(matrix4f, (float)x0, (float)y0, (float)z).method_22913(0.0f, 0.0f).method_1344();
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        }
        float mainRenderAlpha = (discrete ? 0.3f : 1.0f) * alpha;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23028((class_2960)texture));
        vertexConsumer.method_22918(matrix4f, (float)x0, (float)y1, (float)z).method_22915(1.0f, 1.0f, 1.0f, mainRenderAlpha).method_22913(0.0f, 1.0f).method_22916(packedLight).method_1344();
        vertexConsumer.method_22918(matrix4f, (float)x1, (float)y1, (float)z).method_22915(1.0f, 1.0f, 1.0f, mainRenderAlpha).method_22913(1.0f, 1.0f).method_22916(packedLight).method_1344();
        vertexConsumer.method_22918(matrix4f, (float)x1, (float)y0, (float)z).method_22915(1.0f, 1.0f, 1.0f, mainRenderAlpha).method_22913(1.0f, 0.0f).method_22916(packedLight).method_1344();
        vertexConsumer.method_22918(matrix4f, (float)x0, (float)y0, (float)z).method_22915(1.0f, 1.0f, 1.0f, mainRenderAlpha).method_22913(0.0f, 0.0f).method_22916(packedLight).method_1344();
    }

    public static void clearAllCaches() {
        DebugMode.log("Clearing all Cosmetica Caches", new Object[0]);
        PlayerData.clearCaches();
        Models.resetCaches();
        CosmeticaSkinManager.clearCaches();
        System.gc();
    }

    public static Consumer<RuntimeException> logErr(String message) {
        return e -> LOGGER.error(message + ": ", (Throwable)e);
    }

    public static Consumer<RuntimeException> logErr(String message, Predicate<RuntimeException> predicate) {
        return e -> {
            if (predicate.test((RuntimeException)e)) {
                LOGGER.error(message + ": ", (Throwable)e);
            }
        };
    }

    static {
        currentServerAddressCache = "";
        LOGGER = LogManager.getLogger((String)"Cosmetica");
        MAIN_POOL = Executors.newFixedThreadPool(Integer.parseInt(System.getProperty("cosmetica.lookupThreads", "8")), new NamedThreadFactory("Cosmetica Lookup Thread"));
        mayShowWelcomeScreen = false;
        toto = OptionalLong.empty();
        UNDASHED_UUID_GAPS = Pattern.compile("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})");
        splashes = new LinkedList<String>();
        africaFails = 0;
    }
}

