/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.config;

import cc.cosmetica.cosmetica.Cosmetica;
import cc.cosmetica.cosmetica.config.ArmourConflictHandlingMode;
import cc.cosmetica.cosmetica.config.WelcomeMessageState;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.function.Function;

public class CosmeticaConfig {
    private final Path propertiesPath;
    private final List<Option<?>> options = new ArrayList();
    private final Option<Boolean> showNametagInThirdPerson = new Option<Boolean>("show-nametag-in-third-person", true, Boolean::parseBoolean);
    private final Option<Boolean> hideNonVitalUpdateMessages = new Option<Boolean>("honestly-believe-me-i-know-what-the-heck-i-am-doing-trust-me-bro-ask-joe-if-you-dont-believe-me", false, Boolean::parseBoolean);
    private final Option<WelcomeMessageState> showWelcomeMessage = new Option<WelcomeMessageState>("show-welcome-message", WelcomeMessageState.FULL, WelcomeMessageState::of, s -> s.toString().toLowerCase(Locale.ROOT));
    private final Option<Boolean> addCosmeticaSplashMessage = new Option<Boolean>("add-cosmetica-splash-message", true, Boolean::parseBoolean);
    private final Option<Boolean> regionalEffectsPrompt = new Option<Boolean>("regional-effects-prompt", true, Boolean::parseBoolean);
    private final Option<Boolean> paranoidHttps = new Option<Boolean>("paranoid-https", false, Boolean::parseBoolean);
    private final Option<ArmourConflictHandlingMode> hatConflictMode = new Option<ArmourConflictHandlingMode>("hat-conflict-mode", ArmourConflictHandlingMode.HIDE_COSMETICS, s -> ArmourConflictHandlingMode.valueOf(s.toUpperCase(Locale.ROOT)), mode -> mode.toString().toLowerCase(Locale.ROOT));
    private final Option<ArmourConflictHandlingMode> backBlingConflictMode = new Option<ArmourConflictHandlingMode>("back-bling-conflict-mode", ArmourConflictHandlingMode.HIDE_COSMETICS, s -> ArmourConflictHandlingMode.valueOf(s.toUpperCase(Locale.ROOT)), mode -> mode.toString().toLowerCase(Locale.ROOT));
    private final Option<ArmourConflictHandlingMode> backBlingElytraConflictMode = new Option<ArmourConflictHandlingMode>("back-bling-elytra-conflict-mode", ArmourConflictHandlingMode.HIDE_COSMETICS, s -> ArmourConflictHandlingMode.valueOf(s.toUpperCase(Locale.ROOT)), mode -> mode.toString().toLowerCase(Locale.ROOT));

    public CosmeticaConfig(Path propertiesPath) {
        this.propertiesPath = propertiesPath;
    }

    public void initialize() throws IOException {
        this.load();
        this.save();
    }

    public void load() throws IOException {
        if (!Files.exists(this.propertiesPath, new LinkOption[0])) {
            return;
        }
        Properties properties = new Properties();
        for (Option<?> option : this.options) {
            properties.setProperty(option.getName(), option.getSerialisedValue());
        }
        properties.load(Files.newInputStream(this.propertiesPath, new OpenOption[0]));
        for (Option<?> option : this.options) {
            option.loadValue(properties.getProperty(option.getName()));
        }
        if (Cosmetica.api != null) {
            Cosmetica.api.setForceHttps(this.paranoidHttps.getValue().booleanValue());
        }
    }

    public void save() throws IOException {
        File parentDir = this.propertiesPath.getParent().toFile();
        if (!parentDir.exists()) {
            parentDir.mkdir();
        }
        Properties properties = new Properties();
        for (Option<?> option : this.options) {
            properties.setProperty(option.getName(), option.getSerialisedValue());
        }
        properties.store(Files.newOutputStream(this.propertiesPath, new OpenOption[0]), "Cosmetica Config");
    }

    public boolean shouldShowNametagInThirdPerson() {
        return this.showNametagInThirdPerson.getValue();
    }

    public void setShowNametagInThirdPerson(boolean showNametagInThirdPerson) {
        this.showNametagInThirdPerson.setValue(showNametagInThirdPerson);
    }

    public WelcomeMessageState showWelcomeMessage() {
        return this.showWelcomeMessage.getValue();
    }

    public boolean shouldShowNonVitalUpdateMessages() {
        return this.hideNonVitalUpdateMessages.getValue() == false;
    }

    public boolean shouldAddCosmeticaSplashMessage() {
        return this.addCosmeticaSplashMessage.getValue();
    }

    public boolean regionalEffectsPrompt() {
        return this.regionalEffectsPrompt.getValue();
    }

    public boolean paranoidHttps() {
        return this.paranoidHttps.getValue();
    }

    public ArmourConflictHandlingMode getHatConflictMode() {
        return this.hatConflictMode.getValue();
    }

    public void setHatConflictMode(ArmourConflictHandlingMode mode) {
        this.hatConflictMode.setValue(mode);
    }

    public ArmourConflictHandlingMode getBackBlingConflictMode() {
        return this.backBlingConflictMode.getValue();
    }

    public void setBackBlingConflictMode(ArmourConflictHandlingMode mode) {
        this.backBlingConflictMode.setValue(mode);
    }

    public ArmourConflictHandlingMode getBackBlingElytraConflictMode() {
        return this.backBlingElytraConflictMode.getValue();
    }

    public void setBackBlingElytraConflictMode(ArmourConflictHandlingMode mode) {
        this.backBlingElytraConflictMode.setValue(mode);
    }

    private class Option<T> {
        private final String name;
        private final Function<String, T> deserialiser;
        private final Function<T, String> serialiser;
        private T value;

        Option(String name, T defaultValue, Function<String, T> deserialiser) {
            this(name, defaultValue, deserialiser, String::valueOf);
        }

        Option(String name, T defaultValue, Function<String, T> deserialiser, Function<T, String> serialiser) {
            this.name = name;
            this.value = defaultValue;
            this.deserialiser = deserialiser;
            this.serialiser = serialiser;
            CosmeticaConfig.this.options.add(this);
        }

        public String getName() {
            return this.name;
        }

        public T getValue() {
            return this.value;
        }

        public String getSerialisedValue() {
            return this.serialiser.apply(this.value);
        }

        public void loadValue(String serialisedForm) {
            this.value = this.deserialiser.apply(serialisedForm);
        }

        public void setValue(T value) {
            this.value = value;
        }
    }
}

