/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.cosmetics;

import cc.cosmetica.cosmetica.Cosmetica;
import cc.cosmetica.cosmetica.ThreadPool;
import cc.cosmetica.cosmetica.cosmetics.CapeData;
import cc.cosmetica.cosmetica.cosmetics.model.BakableModel;
import cc.cosmetica.cosmetica.utils.DebugMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1068;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public final class PlayerData {
    private final String lore;
    private final boolean upsideDown;
    @Nullable
    private final class_2960 icon;
    private final boolean online;
    private final String prefix;
    private final String suffix;
    private final List<BakableModel> hats;
    private final CapeData cape;
    @Nullable
    private final BakableModel leftShoulderBuddy;
    @Nullable
    private final BakableModel rightShoulderBuddy;
    @Nullable
    private final BakableModel backBling;
    private final class_2960 skin;
    private final boolean slim;
    public static PlayerData NONE = new PlayerData("", false, null, false, "", "", new ArrayList<BakableModel>(), CapeData.NO_CAPE, null, null, null, class_1068.method_4649(), false);
    public static PlayerData TEMPORARY = new PlayerData("", false, null, false, "", "", new ArrayList<BakableModel>(), CapeData.NO_CAPE, null, null, null, class_1068.method_4649(), false);
    private static Map<UUID, PlayerData> playerDataCache = new HashMap<UUID, PlayerData>();
    private static Set<UUID> lookingUp = new HashSet<UUID>();

    public PlayerData(String lore, boolean upsideDown, @Nullable class_2960 icon, boolean online, String prefix, String suffix, List<BakableModel> hats, CapeData cape, @Nullable BakableModel leftShoulderBuddy, @Nullable BakableModel rightShoulderBuddy, @Nullable BakableModel backBling, class_2960 skin, boolean slim) {
        this.lore = lore;
        this.upsideDown = upsideDown;
        this.prefix = prefix;
        this.suffix = suffix;
        this.hats = hats;
        this.cape = cape;
        this.leftShoulderBuddy = leftShoulderBuddy;
        this.rightShoulderBuddy = rightShoulderBuddy;
        this.backBling = backBling;
        this.skin = skin;
        this.slim = slim;
        this.icon = icon;
        this.online = online;
    }

    public String lore() {
        return this.lore;
    }

    public boolean upsideDown() {
        return this.upsideDown;
    }

    public String prefix() {
        return this.prefix;
    }

    public String suffix() {
        return this.suffix;
    }

    public List<BakableModel> hats() {
        return this.hats;
    }

    public BakableModel leftShoulderBuddy() {
        return this.leftShoulderBuddy;
    }

    public BakableModel rightShoulderBuddy() {
        return this.rightShoulderBuddy;
    }

    public BakableModel backBling() {
        return this.backBling;
    }

    public CapeData cape() {
        return this.cape;
    }

    public class_2960 skin() {
        return this.skin;
    }

    public boolean slim() {
        return this.slim;
    }

    @Nullable
    public class_2960 icon() {
        return this.icon;
    }

    public boolean online() {
        return this.online;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PlayerData that = (PlayerData)obj;
        return Objects.equals(this.lore, that.lore) && this.upsideDown == that.upsideDown && Objects.equals(this.icon, that.icon) && this.online == that.online && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.suffix, that.suffix) && Objects.equals(this.cape, that.cape) && Objects.equals(this.hats, that.hats) && Objects.equals(this.leftShoulderBuddy, that.leftShoulderBuddy) && Objects.equals(this.rightShoulderBuddy, that.rightShoulderBuddy) && Objects.equals(this.backBling, that.backBling) && Objects.equals(this.skin, that.skin) && this.slim == that.slim;
    }

    public int hashCode() {
        return Objects.hash(this.lore, this.upsideDown, this.icon, this.online, this.prefix, this.suffix, this.cape, this.hats, this.leftShoulderBuddy, this.rightShoulderBuddy, this.backBling, this.skin, this.slim);
    }

    public String toString() {
        return "PlayerData[lore=" + this.lore + ", upsideDown=" + this.upsideDown + ", icon=" + this.icon + ", online=" + this.online + ", prefix=" + this.prefix + ", suffix=" + this.suffix + ", cape=" + this.cape + ", hats=" + this.hats + ", leftShoulderBuddy=" + this.leftShoulderBuddy + ", rightShoulderBuddy=" + this.rightShoulderBuddy + ", backBling=" + this.backBling + ", skin=" + this.skin + ", slim=" + this.slim + "]";
    }

    public static PlayerData get(class_1657 player) {
        return PlayerData.get(player.method_5667(), player.method_5477().getString(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlayerData get(UUID uuid, String username, boolean sync) {
        if (Cosmetica.isProbablyNPC(uuid)) {
            return NONE;
        }
        class_638 level = class_310.method_1551().field_1687;
        Map<UUID, PlayerData> map = playerDataCache;
        synchronized (map) {
            PlayerData existing = playerDataCache.get(uuid);
            if (existing != null) {
                if (!sync || existing != TEMPORARY) {
                    return existing;
                }
            } else {
                lookingUp.add(uuid);
                playerDataCache.put(uuid, TEMPORARY);
            }
        }
        if (sync) {
            return PlayerData.lookupPlayerData(uuid, username, (class_1937)level);
        }
        Cosmetica.runOffthread(() -> PlayerData.lambda$get$0((class_1937)level, uuid, username), ThreadPool.GENERAL_THREADS);
        return NONE;
    }

    private static PlayerData lookupPlayerData(UUID uuid, String username, class_1937 level) {
        DebugMode.log("Looking up player info for " + uuid + " (" + username + ")", new Object[0]);
        AtomicReference<PlayerData> newDataHolder = new AtomicReference<PlayerData>(NONE);
        Cosmetica.api.getUserInfo(uuid, username).ifSuccessfulOrElse(info -> {
            PlayerData newData = Cosmetica.newPlayerData(info, uuid);
            Map<UUID, PlayerData> map = playerDataCache;
            synchronized (map) {
                playerDataCache.put(uuid, newData);
                lookingUp.remove(uuid);
            }
            newDataHolder.set(newData);
        }, Cosmetica.logErr("Error getting user info for " + uuid + " / " + username).andThen(re -> {
            Map<UUID, PlayerData> map = playerDataCache;
            synchronized (map) {
                if (class_310.method_1551().field_1687 == level && playerDataCache.get(uuid) == TEMPORARY) {
                    lookingUp.remove(uuid);
                }
            }
        }));
        return newDataHolder.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean has(UUID uuid) {
        Map<UUID, PlayerData> map = playerDataCache;
        synchronized (map) {
            return playerDataCache.containsKey(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlayerData getCached(UUID player) {
        Map<UUID, PlayerData> map = playerDataCache;
        synchronized (map) {
            return playerDataCache.get(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear(UUID uuid) {
        Map<UUID, PlayerData> map = playerDataCache;
        synchronized (map) {
            playerDataCache.remove(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCacheSize() {
        Map<UUID, PlayerData> map = playerDataCache;
        synchronized (map) {
            return playerDataCache.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<UUID> getCachedPlayers() {
        Map<UUID, PlayerData> map = playerDataCache;
        synchronized (map) {
            return playerDataCache.keySet();
        }
    }

    public static void clearCaches() {
        playerDataCache = new HashMap<UUID, PlayerData>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$get$0(class_1937 level, UUID uuid, String username) {
        if (Cosmetica.api == null || class_310.method_1551().field_1687 != level) {
            Map<UUID, PlayerData> map = playerDataCache;
            synchronized (map) {
                playerDataCache.remove(uuid);
                lookingUp.remove(uuid);
            }
        }
        PlayerData.lookupPlayerData(uuid, username, level);
    }
}

