/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.cosmetics.model;

import cc.cosmetica.api.Box;
import cc.cosmetica.api.Model;
import cc.cosmetica.cosmetica.CosmeticaSkinManager;
import cc.cosmetica.cosmetica.cosmetics.model.BakableModel;
import cc.cosmetica.cosmetica.utils.DebugMode;
import cc.cosmetica.cosmetica.utils.Scheduler;
import cc.cosmetica.cosmetica.utils.textures.AnimatedTexture;
import cc.cosmetica.cosmetica.utils.textures.ModelSprite;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1044;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_811;

public class Models {
    private static Map<String, class_1087> BAKED_MODELS = new HashMap<String, class_1087>();
    private static Set<class_1087> NEW_BAKED_MODELS = new HashSet<class_1087>();
    private static Map<String, BakableModel> LOADED_MODELS = new HashMap<String, BakableModel>();
    private static final float RANDOM_NEXT_FLOAT = 0.211f;
    public static class_1088 thePieShopDownTheRoad;

    public static void resetCaches() {
        LOADED_MODELS = new HashMap<String, BakableModel>();
        Models.resetTextureBasedCaches();
    }

    public static void resetTextureBasedCaches() {
        BAKED_MODELS = new HashMap<String, class_1087>();
    }

    public static Collection<String> getCachedModels() {
        return LOADED_MODELS.keySet();
    }

    @Nullable
    public static class_1087 getBakedModel(final BakableModel unbaked) {
        class_1087 result;
        boolean compute;
        if (unbaked.id().charAt(0) == '-') {
            return null;
        }
        boolean bl = compute = !BAKED_MODELS.containsKey(unbaked.id());
        if (compute) {
            DebugMode.log("Computing Baked Model: " + unbaked.id(), new Object[0]);
            BAKED_MODELS.put(unbaked.id(), null);
            class_2960 location = unbaked.image();
            class_1044 modelTexture = class_310.method_1551().method_1531().method_34590(location, null);
            if (modelTexture instanceof AnimatedTexture) {
                final ModelSprite sprite = new ModelSprite(location, (AnimatedTexture)modelTexture);
                class_7775 ratatouille = new class_7775(){

                    public class_1100 method_45872(class_2960 resourceLocation) {
                        return unbaked.model();
                    }

                    @Nullable
                    public class_1087 method_45873(class_2960 resourceLocation, class_3665 modelState) {
                        return this.method_45872(resourceLocation).method_4753((class_7775)this, l -> sprite, modelState, resourceLocation);
                    }
                };
                class_1087 model = ratatouille.method_45873(location, (class_3665)class_1086.field_5350);
                NEW_BAKED_MODELS.add(model);
                BAKED_MODELS.put(unbaked.id(), model);
                Scheduler.scheduleTask(Scheduler.Location.TEXTURE_TICK, () -> NEW_BAKED_MODELS.remove(model));
                return model;
            }
        }
        if (NEW_BAKED_MODELS.contains(result = BAKED_MODELS.get(unbaked.id()))) {
            return null;
        }
        return result;
    }

    public static void removeBakedModel(String id) {
        DebugMode.log("Deallocating baked model, {}", id);
        BAKED_MODELS.remove(id);
    }

    @Nullable
    public static BakableModel createBakableModel(Model model) {
        String location = model.getId();
        if (location.isEmpty()) {
            return null;
        }
        Box bounds = model.getBoundingBox();
        if (model.isBuiltin()) {
            return LOADED_MODELS.computeIfAbsent(location, l -> new BakableModel(location, model.getName(), null, null, 0, bounds));
        }
        return LOADED_MODELS.computeIfAbsent(location, l -> {
            BakableModel bakableModel;
            ByteArrayInputStream is = new ByteArrayInputStream(model.getModel().getBytes(StandardCharsets.UTF_8));
            try {
                class_793 blockModel = class_793.method_3437((Reader)new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
                blockModel.field_4252 = l;
                bakableModel = new BakableModel(location, model.getName(), blockModel, CosmeticaSkinManager.processModel(model), model.flags(), bounds);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            ((InputStream)is).close();
            return bakableModel;
        });
    }

    public static void renderModel(class_1087 model, class_4587 stack, class_4597 multiBufferSource, class_2960 texture, int packedLight) {
        stack.method_22903();
        boolean isGUI3D = model.method_4712();
        float transformStrength = 0.25f;
        float rotation = 0.0f;
        float transform = model.method_4709().method_3503((class_811)class_811.field_4318).field_4285.y();
        stack.method_22904(0.0, (double)(rotation + transformStrength * transform), 0.0);
        float xScale = model.method_4709().field_4303.field_4285.x();
        float yScale = model.method_4709().field_4303.field_4285.y();
        float zScale = model.method_4709().field_4303.field_4285.z();
        stack.method_22903();
        class_811 transformType = class_811.field_4319;
        int overlayTyp = class_4608.field_21444;
        stack.method_22903();
        model.method_4709().method_3503(transformType).method_23075(false, stack);
        stack.method_22904(-0.5, -0.5, -0.5);
        class_1921 renderType = class_1921.method_23580((class_2960)texture);
        class_4588 vertexConsumer4 = multiBufferSource.getBuffer(renderType);
        Models.renderModelLists(model, packedLight, overlayTyp, stack, vertexConsumer4);
        stack.method_22909();
        stack.method_22909();
        if (!isGUI3D) {
            stack.method_46416(0.0f * xScale, 0.0f * yScale, 0.09375f * zScale);
        }
        stack.method_22909();
    }

    private static void renderModelLists(class_1087 bakedModel, int packedLight, int overlayType, class_4587 poseStack, class_4588 vertexConsumer) {
        class_5819 randomSource = class_5819.method_43047();
        long seed = 42L;
        for (class_2350 direction : class_2350.values()) {
            randomSource.method_43052(42L);
            Models.renderQuadList(poseStack, vertexConsumer, bakedModel.method_4707(null, direction, randomSource), packedLight, overlayType);
        }
        randomSource.method_43052(42L);
        Models.renderQuadList(poseStack, vertexConsumer, bakedModel.method_4707(null, null, randomSource), packedLight, overlayType);
    }

    private static void renderQuadList(class_4587 poseStack, class_4588 vertexConsumer, List<class_777> list, int i, int j) {
        class_4587.class_4665 pose = poseStack.method_23760();
        for (class_777 bakedQuad : list) {
            int k = -1;
            float f = (float)(k >> 16 & 0xFF) / 255.0f;
            float g = (float)(k >> 8 & 0xFF) / 255.0f;
            float h = (float)(k & 0xFF) / 255.0f;
            vertexConsumer.method_22919(pose, bakedQuad, f, g, h, i, j);
        }
    }
}

