/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.screens;

import benzenestudios.sulphate.Anchor;
import benzenestudios.sulphate.ClassicButton;
import benzenestudios.sulphate.ExtendedScreen;
import cc.cosmetica.api.Cape;
import cc.cosmetica.api.CosmeticType;
import cc.cosmetica.api.CosmeticsPage;
import cc.cosmetica.api.CustomCosmetic;
import cc.cosmetica.api.Model;
import cc.cosmetica.cosmetica.Cosmetica;
import cc.cosmetica.cosmetica.CosmeticaSkinManager;
import cc.cosmetica.cosmetica.cosmetics.model.CosmeticStack;
import cc.cosmetica.cosmetica.cosmetics.model.Models;
import cc.cosmetica.cosmetica.screens.ApplyCosmeticsScreen;
import cc.cosmetica.cosmetica.screens.PlayerRenderScreen;
import cc.cosmetica.cosmetica.screens.widget.CosmeticSelection;
import cc.cosmetica.cosmetica.screens.widget.FetchingCosmetics;
import cc.cosmetica.cosmetica.screens.widget.SearchEditBox;
import cc.cosmetica.cosmetica.screens.widget.TextWidget;
import cc.cosmetica.cosmetica.utils.LoadState;
import cc.cosmetica.cosmetica.utils.TextComponents;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.jetbrains.annotations.Nullable;

public class BrowseCosmeticsScreen<T extends CustomCosmetic, E>
extends PlayerRenderScreen {
    private final CosmeticType<T> type;
    private final CosmeticStack<E> overrider;
    private String searchQuery = "";
    private LoadState state = LoadState.LOADING;
    @Nullable
    private CosmeticSelection<T> dataSelection;
    private CosmeticSelection<T> viewSelection;
    private FetchingCosmetics<CosmeticsPage<T>> currentFetcher;
    private int page = 1;
    private boolean nextPage;
    private SearchEditBox searchBox;
    private class_4185 proceed;
    private float yRotBodyPrev;
    private float yRotPrev;
    private T lastSelected;
    private E lastSelectedButE;
    private static final class_2561 SEARCH_ELLIPSIS = TextComponents.translatable("cosmetica.selection.search");
    private static final int SEARCH_Y = 32;

    protected BrowseCosmeticsScreen(@Nullable PlayerRenderScreen parent, CosmeticType<T> type, CosmeticStack<E> overrider) {
        super((class_2561)TextComponents.translatable("cosmetica.selection.select").method_10852((class_2561)TextComponents.translatable("cosmetica.entry." + BrowseCosmeticsScreen.getTranslationPart(type))), (class_437)parent, parent.fakePlayer);
        this.type = type;
        this.overrider = overrider;
        this.rightMouseGrabBuffer = 80;
        this.setTransitionProgress(1.0);
        this.yRotBodyPrev = parent.fakePlayer.yRotBody;
        this.yRotPrev = parent.fakePlayer.yRot;
        parent.fakePlayer.yRotBody = this.type == CosmeticType.CAPE ? 200.0f : 0.0f;
        parent.fakePlayer.yRot = parent.fakePlayer.yRotBody;
    }

    protected void addWidgets() {
        this.setAnchorY(Anchor.CENTRE, () -> this.field_22790 / 2);
        this.setRows(3);
        this.searchBox = null;
        this.proceed = null;
        switch (this.state) {
            case RELOADING: {
                this.addMainGUI(true);
            }
            case LOADING: {
                this.currentFetcher = (FetchingCosmetics)this.method_25429((class_364)new FetchingCosmetics(BrowseCosmeticsScreen.getTranslationPart(this.type), () -> ImmutableList.of((Object)Cosmetica.api.getRecentCosmetics(this.type, this.page, 8, Optional.ofNullable(this.searchQuery))), (fetcher, results) -> {
                    if (results.isEmpty()) {
                        this.state = LoadState.FAILED;
                    } else {
                        this.dataSelection = new CosmeticSelection(this.field_22787, (class_437)this, this.type.getUrlString(), this.field_22793, s -> {});
                        CosmeticsPage page = (CosmeticsPage)results.get(0);
                        for (CustomCosmetic result : page.getCosmetics()) {
                            this.dataSelection.addWithoutRegisteringTexture(result);
                        }
                        this.nextPage = page.hasNextPage();
                    }
                    RenderSystem.recordRenderCall(() -> {
                        this.state = LoadState.LOADED;
                        this.rebuildGUI();
                    });
                }));
                this.currentFetcher.method_46419(this.field_22790 / 2 - 20);
                this.currentFetcher.method_46421(this.field_22789 / 2 - this.currentFetcher.method_25368() / 2);
                if (this.state != LoadState.LOADING) break;
                this.method_37063((class_364)new ClassicButton(this.field_22789 / 2 - 100, this.field_22790 / 2 + 20, 200, 20, class_5244.field_24335, b -> this.method_25419()));
                break;
            }
            case LOADED: {
                if (this.dataSelection == null) {
                    Cosmetica.LOGGER.warn("In state \"LOADED\" but dataSelection is null. Switching to state \"LOADING\"!");
                    this.state = LoadState.LOADING;
                    this.addWidgets();
                    return;
                }
                this.addMainGUI(false);
                break;
            }
            case FAILED: {
                this.addWidget((x, y, w, h, component) -> new TextWidget(x, y, w, h, true, component), (class_2561)TextComponents.translatable("cosmetica.selection.err"));
                this.addButton((class_2561)TextComponents.translatable("cosmetica.okay"), b -> this.method_25419());
            }
        }
        this.initialPlayerLeft = this.field_22789 / 4 - 10;
        this.deltaPlayerLeft = 0;
    }

    public void method_16014(double mouseX, double mouseY) {
        if (this.viewSelection != null) {
            this.viewSelection.method_16014(mouseX, mouseY);
        }
    }

    public void method_25419() {
        this.fakePlayer.yRotBody = this.yRotBodyPrev;
        this.fakePlayer.yRot = this.yRotPrev;
        super.method_25419();
    }

    private CosmeticSelection<T> createViewSelection() {
        this.viewSelection = new CosmeticSelection(this.field_22787, (class_437)this, this.type.getUrlString(), this.field_22793, s -> {
            if (this.proceed != null) {
                this.proceed.field_22763 = true;
            }
        });
        this.viewSelection.copy(this.dataSelection);
        this.viewSelection.matchSelected(this.dataSelection);
        return this.viewSelection;
    }

    public void method_25410(class_310 minecraft, int i, int j) {
        boolean wasFocusedOnSearch = this.searchBox != null && this.method_25399() == this.searchBox;
        @Nullable class_4185 lastProceed = this.proceed;
        if (this.viewSelection != null) {
            this.dataSelection.matchSelected(this.viewSelection);
        }
        if (this.searchBox == null) {
            super.method_25410(minecraft, i, j);
        } else {
            String query = this.searchBox.method_1882();
            this.method_25423(minecraft, i, j);
            if (this.searchBox != null) {
                this.searchBox.method_1852(query);
            }
        }
        if (lastProceed != null && this.proceed != null) {
            this.proceed.field_22763 = lastProceed.field_22763;
        }
        if (this.searchBox != null && wasFocusedOnSearch) {
            this.method_25395((class_364)this.searchBox);
            this.searchBox.method_25365(true);
        }
    }

    private void addMainGUI(boolean loadEdition) {
        this.searchBox = (SearchEditBox)this.method_37063((class_364)new SearchEditBox(this.field_22793, this.field_22789 / 2 - 100, 32, 200, 20, (class_2561)TextComponents.translatable("cosmetica.selection.search")));
        this.searchBox.method_1880(128);
        this.searchBox.setOnEnter(value -> {
            this.searchQuery = value;
            this.page = 1;
            this.state = LoadState.RELOADING;
            this.rebuildGUI();
        });
        this.method_25429((class_364)this.searchBox);
        if (loadEdition) {
            this.method_37060((class_4068)this.createViewSelection());
        } else {
            this.method_37063((class_364)this.createViewSelection());
        }
        this.setAnchorY(Anchor.TOP, () -> this.field_22790 - 50);
        class_4185 pageBack = this.addButton(100, 20, (class_2561)TextComponents.translatable("cosmetica.selection.pageBack"), b -> {
            --this.page;
            this.state = LoadState.RELOADING;
            this.rebuildGUI();
        });
        if (this.page == 1 || loadEdition) {
            pageBack.field_22763 = false;
        }
        class_4185 clear = this.addButton(this.type == CosmeticType.SHOULDER_BUDDY || this.type == CosmeticType.BACK_BLING ? 150 : 100, 20, (class_2561)TextComponents.translatable("cosmetica.selection.remove").method_10852((class_2561)TextComponents.translatable("cosmetica.entry." + ApplyCosmeticsScreen.getTranslationPart(this.type))), b -> this.field_22787.method_1507(new ApplyCosmeticsScreen<Object, E>((class_437)this, (PlayerRenderScreen)this.parent, this.type, this.overrider, null, this.yRotBodyPrev, this.yRotPrev)));
        if (loadEdition) {
            clear.field_22763 = false;
        }
        class_4185 pageForward = this.addButton(100, 20, (class_2561)TextComponents.translatable("cosmetica.selection.pageForward"), b -> {
            ++this.page;
            this.state = LoadState.RELOADING;
            this.rebuildGUI();
        });
        if (!this.nextPage || loadEdition) {
            pageForward.field_22763 = false;
        }
        this.addButton(150, 20, class_5244.field_24335, b -> this.method_25419());
        this.proceed = this.addButton(150, 20, (class_2561)TextComponents.translatable("cosmetica.selection.proceed"), b -> this.field_22787.method_1507(new ApplyCosmeticsScreen<T, E>((class_437)this, (PlayerRenderScreen)this.parent, this.type, this.overrider, this.viewSelection.getSelectedCosmetic(), this.yRotBodyPrev, this.yRotPrev)));
        this.proceed.field_22763 = false;
    }

    private void rebuildGUI() {
        if (this.proceed != null) {
            this.proceed.field_22763 = false;
        }
        this.method_25410(this.field_22787, this.field_22789, this.field_22790);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        for (class_4068 widget : List.copyOf(((ExtendedScreen)this).getWidgets())) {
            widget.method_25394(graphics, mouseX, mouseY, delta);
        }
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        if (this.searchBox != null) {
            this.searchBox.method_25394(graphics, mouseX, mouseY, delta);
            if (this.searchBox.isEmpty()) {
                graphics.method_27535(this.field_22793, SEARCH_ELLIPSIS, this.field_22789 / 2 - 96, 38, 0xA0A0A0);
            }
        }
        if (this.state == LoadState.RELOADING) {
            graphics.method_25296(0, 57, this.field_22789, this.field_22790 - 65 + 4, -1072689136, -804253680);
        }
        if (this.state == LoadState.RELOADING || this.state == LoadState.LOADING) {
            this.currentFetcher.method_25394(graphics, mouseX, mouseY, delta);
        }
        if (this.state != LoadState.LOADING && this.viewSelection != null) {
            T cosmetic = this.viewSelection.getSelectedCosmetic();
            if (cosmetic == null) {
                this.lastSelected = null;
                this.lastSelectedButE = null;
                CosmeticStack.strip();
            } else {
                if (cosmetic != this.lastSelected) {
                    this.lastSelected = cosmetic;
                    this.lastSelectedButE = this.getStack(cosmetic);
                }
                if (this.lastSelectedButE == null) {
                    CosmeticStack.strip();
                } else {
                    this.overrider.solo();
                    this.overrider.push(this.lastSelectedButE);
                }
            }
            this.updateSpin(mouseX, mouseY);
            this.fakePlayer.renderNametag = false;
            this.renderFakePlayer(mouseX, mouseY);
            this.fakePlayer.renderNametag = true;
            if (this.overrider.isSolo()) {
                this.overrider.pop();
            }
            CosmeticStack.normal();
        }
    }

    @Nullable
    private E getStack(T cosmetic) {
        if (cosmetic == null) {
            if (this.type == CosmeticType.CAPE) {
                return (E)CosmeticStack.NO_RESOURCE_LOCATION;
            }
            return (E)CosmeticStack.NO_BAKABLE_MODEL;
        }
        if (cosmetic instanceof Cape) {
            Cape cape = (Cape)cosmetic;
            class_2960 result = CosmeticaSkinManager.textureId("cape", cosmetic.getId());
            CosmeticaSkinManager.processCape(cape);
            return (E)result;
        }
        if (cosmetic instanceof Model) {
            Model model = (Model)cosmetic;
            return (E)Models.createBakableModel(model);
        }
        throw new IllegalStateException("wtf (pls let valoeghese know that your game just said wtf)");
    }

    @Override
    public void method_25393() {
        if (this.field_22787.field_1687 == null) {
            this.field_22787.method_16011().method_15396("textures");
            this.field_22787.method_1531().method_4622();
            this.field_22787.method_16011().method_15407();
        }
    }

    private static String getTranslationPart(CosmeticType<?> type) {
        return switch (type.getUrlString()) {
            case "cape" -> "Capes";
            case "hat" -> "Hats";
            case "shoulderbuddy" -> "ShoulderBuddies";
            default -> "BackBlings";
        };
    }
}

