/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.screens;

import benzenestudios.sulphate.ClassicButton;
import cc.cosmetica.cosmetica.Authentication;
import cc.cosmetica.cosmetica.Cosmetica;
import cc.cosmetica.cosmetica.screens.LoadingScreen;
import cc.cosmetica.cosmetica.screens.MainScreen;
import cc.cosmetica.cosmetica.utils.DebugMode;
import cc.cosmetica.cosmetica.utils.TextComponents;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_440;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5489;
import org.jetbrains.annotations.Nullable;

public class UnauthenticatedScreen
extends class_437 {
    private class_437 parentScreen;
    private boolean fromSave;
    private final class_2561 reason;
    private class_5489 message;
    private List<TextWithWidth> messageContent;
    private int textHeight;

    public UnauthenticatedScreen(class_437 parentScreen, boolean fromSave, UnauthenticatedReason reason) {
        super((class_2561)TextComponents.translatable(reason.description == UnauthenticatedReason.OFFLINE ? "cosmetica.offline" : "cosmetica.unauthenticated"));
        this.parentScreen = parentScreen;
        this.fromSave = fromSave;
        this.reason = reason.displayError == null ? reason.description : reason.description.method_27661().method_10852((class_2561)TextComponents.literal("\n\n\u00a77(" + reason.displayError + ")"));
    }

    protected void method_25426() {
        this.message = class_5489.method_30890((class_327)this.field_22793, (class_5348)this.reason, (int)(this.field_22789 - 50));
        this.messageContent = UnauthenticatedScreen.createMultiLineContent(this.field_22793, (class_5348)this.reason, this.field_22789 - 50);
        Objects.requireNonNull(this.field_22793);
        this.textHeight = this.message.method_30887() * 9;
        int buttonX = this.field_22789 / 2 - 100;
        int buttonStartY = Math.min(this.field_22790 / 2 + this.textHeight / 2 + 9, this.field_22790 - 30);
        if (this.fromSave) {
            this.method_37063((class_364)new ClassicButton(buttonX, buttonStartY, 200, 20, (class_2561)class_2561.method_43471((String)"cosmetica.okay"), button -> this.method_25419()));
        } else {
            if (DebugMode.ENABLED) {
                this.method_37063((class_364)new ClassicButton(buttonX, buttonStartY + 48, 100, 20, (class_2561)TextComponents.literal("Clear Caches"), btn -> {
                    Cosmetica.clearAllCaches();
                    DebugMode.reloadTestModels();
                }));
            }
            this.method_37063((class_364)new ClassicButton(buttonX, buttonStartY, 200, 20, (class_2561)class_2561.method_43471((String)"options.skinCustomisation"), button -> this.field_22787.method_1507((class_437)new class_440(this.parentScreen, class_310.method_1551().field_1690))));
            this.method_37063((class_364)new ClassicButton(buttonX, buttonStartY + 24, 200, 20, (class_2561)class_2561.method_43471((String)"cosmetica.unauthenticated.retry"), button -> this.field_22787.method_1507((class_437)new LoadingScreen(this.parentScreen, this.field_22787.field_1690, Authentication.settingLoadTarget))));
            this.method_37063((class_364)new ClassicButton(DebugMode.ENABLED ? buttonX + 100 : buttonX, buttonStartY + 48, DebugMode.ENABLED ? 100 : 200, 20, (class_2561)TextComponents.translatable("gui.cancel"), button -> this.method_25419()));
        }
    }

    public boolean method_25402(double x, double y, int button) {
        int renderX = this.field_22789 / 2;
        int renderY = this.field_22790 / 2 - this.textHeight / 2;
        for (TextWithWidth textWithWidth : this.messageContent) {
            int lineWidth = this.field_22793.method_30880(textWithWidth.text);
            int startX = renderX - lineWidth / 2;
            if (y >= (double)renderY) {
                class_2558 event;
                class_2583 style;
                Objects.requireNonNull(this.field_22793);
                if (y < (double)(renderY + 9) && x >= (double)startX && x < (double)(startX + lineWidth) && (style = this.field_22793.method_27527().method_30876(textWithWidth.text, (int)x - startX)) != null && (event = style.method_10970()) != null && event.method_10845() == class_2558.class_2559.field_11749) {
                    MainScreen.copyAndOpenURL(event.method_10844());
                }
            }
            Objects.requireNonNull(this.field_22793);
            renderY += 9;
        }
        return super.method_25402(x, y, button);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parentScreen);
    }

    public void method_25394(class_332 poseStack, int i, int j, float f) {
        this.method_25420(poseStack);
        class_327 var10001 = this.field_22793;
        class_2561 var10002 = this.field_22785;
        int var10003 = this.field_22789 / 2;
        int var10004 = this.field_22790 / 2 - this.textHeight / 2;
        Objects.requireNonNull(this.field_22793);
        poseStack.method_27534(var10001, var10002, var10003, var10004 - 18, 0xAAAAAA);
        this.message.method_30888(poseStack, this.field_22789 / 2, this.field_22790 / 2 - this.textHeight / 2);
        super.method_25394(poseStack, i, j, f);
    }

    static List<TextWithWidth> createMultiLineContent(class_327 font, class_5348 formattedText, int width) {
        return (List)font.method_1728(formattedText, width).stream().map(formattedCharSequence -> new TextWithWidth((class_5481)formattedCharSequence, font.method_30880(formattedCharSequence))).collect(ImmutableList.toImmutableList());
    }

    public static class UnauthenticatedReason {
        private final class_2561 description;
        private final Exception displayError;
        private static final class_5250 STATUS_PAGE = TextComponents.translatable("cosmetica.unauthenticated.here");
        private static final class_5250 DISCORD_LINK = TextComponents.translatable("cosmetica.unauthenticated.discordSupport");
        public static final class_2561 OFFLINE;
        public static final class_2561 UNKNOWN_HOST;
        public static final class_2561 CONNECTION_ISSUE;
        public static final class_2561 CRACKED;
        public static final class_2561 FIVE_HUNDRED;
        public static final class_2561 GENERIC;

        public UnauthenticatedReason(class_2561 description, @Nullable Exception displayError) {
            this.description = description;
            this.displayError = displayError;
        }

        static {
            STATUS_PAGE.method_10862(STATUS_PAGE.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11749, "https://status.cosmetica.cc/")));
            DISCORD_LINK.method_10862(DISCORD_LINK.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11749, "https://cosmetica.cc/discord")));
            OFFLINE = TextComponents.translatable("cosmetica.offline.message");
            UNKNOWN_HOST = TextComponents.formattedTranslatable("cosmetica.unauthenticated.unknownHost", STATUS_PAGE, DISCORD_LINK);
            CONNECTION_ISSUE = TextComponents.formattedTranslatable("cosmetica.unauthenticated.connectionError", DISCORD_LINK);
            CRACKED = TextComponents.translatable("cosmetica.unauthenticated.cracked");
            FIVE_HUNDRED = TextComponents.formattedTranslatable("cosmetica.unauthenticated.serverError", DISCORD_LINK);
            GENERIC = TextComponents.formattedTranslatable("cosmetica.unauthenticated.generic", DISCORD_LINK);
        }
    }

    private static class TextWithWidth {
        final class_5481 text;
        final int width;

        public TextWithWidth(class_5481 text, int width) {
            this.text = text;
            this.width = width;
        }
    }
}

