/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.utils;

import cc.cosmetica.api.Box;
import cc.cosmetica.cosmetica.Cosmetica;
import cc.cosmetica.cosmetica.CosmeticaSkinManager;
import cc.cosmetica.cosmetica.config.DebugModeConfig;
import cc.cosmetica.cosmetica.cosmetics.BackBling;
import cc.cosmetica.cosmetica.cosmetics.CustomLayer;
import cc.cosmetica.cosmetica.cosmetics.Hats;
import cc.cosmetica.cosmetica.cosmetics.ShoulderBuddies;
import cc.cosmetica.cosmetica.cosmetics.model.BakableModel;
import cc.cosmetica.cosmetica.cosmetics.model.CosmeticStack;
import cc.cosmetica.cosmetica.utils.textures.LocalCapeTexture;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_793;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugMode {
    public static final boolean ENABLED = FabricLoader.getInstance().isDevelopmentEnvironment() || Boolean.getBoolean("cosmetica.debug");
    private static final boolean EXTRA_LOGGING = Boolean.getBoolean("cosmetica.extraLogging");
    private static final File CONFIG_DIR;
    private static final File DEBUG_SETTINGS;
    private static final Logger DEBUG_LOGGER;
    public static final class_2960 TEST_CAPE;
    public static int frameDelayMs;
    private static DebugModeConfig debugSettings;
    private static final Set<String> complainedAbout;
    private static final Set<String> warnedAbout;

    public static void complainOnce(String key, String str, Object ... objects) {
        if (DebugMode.elevatedLogging() && !complainedAbout.contains(key)) {
            complainedAbout.add(key);
            DEBUG_LOGGER.info("[COMPLAINT] " + str, objects);
        }
    }

    public static void warnOnce(String key, String str, Object ... objects) {
        if (!warnedAbout.contains(key)) {
            warnedAbout.add(key);
            Cosmetica.LOGGER.warn(str, objects);
        }
    }

    public static void log(String str, Object ... objects) {
        if (DebugMode.elevatedLogging()) {
            DEBUG_LOGGER.info(str, objects);
        } else {
            Cosmetica.LOGGER.debug(str, objects);
        }
    }

    public static void logError(String message, Exception e) {
        if (DebugMode.elevatedLogging()) {
            DEBUG_LOGGER.info(message, (Throwable)e);
        } else {
            Cosmetica.LOGGER.debug(message + " " + e.getClass().getName() + " " + e.getMessage());
        }
    }

    public static void logURL(String str) {
        if (DebugMode.urlLogging()) {
            DEBUG_LOGGER.info(str);
        }
    }

    public static void log(Supplier<String> str) {
        if (DebugMode.elevatedLogging()) {
            DEBUG_LOGGER.info(str.get());
        } else {
            Cosmetica.LOGGER.debug(str.get());
        }
    }

    public static boolean debugCommands() {
        return ENABLED && DebugMode.debugSettings.debugCommands;
    }

    public static boolean alwaysShowCosmeticaSplash() {
        return ENABLED && DebugMode.debugSettings.forceCosmeticaSplash;
    }

    public static boolean elevatedLogging() {
        return EXTRA_LOGGING || ENABLED && DebugMode.debugSettings.elevateDebugLogging;
    }

    private static boolean urlLogging() {
        return EXTRA_LOGGING || ENABLED && DebugMode.debugSettings.logURLs;
    }

    public static boolean forceRSEScreen() {
        return ENABLED && DebugMode.debugSettings.forceRseScreen;
    }

    private static boolean loadTestModel(CosmeticStack<BakableModel> model, String modelLoc, int extraInfo) {
        File modelJsonF = new File(CONFIG_DIR, modelLoc + ".json");
        if (modelJsonF.isFile()) {
            File imageF = new File(CONFIG_DIR, modelLoc + ".png");
            if (imageF.isFile()) {
                class_793 blockModel;
                try (FileReader reader = new FileReader(modelJsonF);){
                    blockModel = class_793.method_3437((Reader)reader);
                }
                catch (JsonParseException | IOException e) {
                    Cosmetica.LOGGER.error("Error reading test block model for " + modelLoc, e);
                    return false;
                }
                class_2960 resourceLocation = new class_2960("cosmetica_debug", "test/" + modelLoc.toLowerCase(Locale.ROOT));
                class_310.method_1551().method_1531().method_4616(resourceLocation, (class_1044)new LocalCapeTexture(new class_2960("cosmetica_debug", modelLoc.toLowerCase(Locale.ROOT)), 1, () -> {
                    class_1011 class_10112;
                    BufferedInputStream stream = new BufferedInputStream(new FileInputStream(imageF));
                    try {
                        class_10112 = class_1011.method_4309((InputStream)stream);
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                ((InputStream)stream).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            Cosmetica.LOGGER.error("Error reading test model texture for " + modelLoc, (Throwable)e);
                            return null;
                        }
                    }
                    ((InputStream)stream).close();
                    return class_10112;
                }));
                model.push(new BakableModel("test-" + modelLoc, modelLoc, blockModel, resourceLocation, extraInfo, new Box(0.0, 0.0, 0.0, 0.0, 0.0, 0.0)));
                return true;
            }
            Cosmetica.LOGGER.warn("Json for test model {} found but no associated 32x32 image. Skipping loading the model override!", (Object)modelLoc);
        }
        return false;
    }

    public static void reloadTestModels() {
        try {
            DebugMode.loadDebugSettings();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DebugMode.loadTestModel(LocalModelType.HAT);
        DebugMode.loadTestModel(LocalModelType.LEFT_SHOULDERBUDDY);
        DebugMode.loadTestModel(LocalModelType.RIGHT_SHOULDERBUDDY);
        DebugMode.loadTestModel(LocalModelType.BACK_BLING);
        DebugMode.loadTestCape();
    }

    public static boolean loadTestModel(LocalModelType type) {
        String model = type.localIdProvider.get();
        if (model.isBlank()) {
            type.modelOverride.clear();
            return false;
        }
        return DebugMode.loadTestModel(type.modelOverride, model, type.extraInfoLoader.getAsInt());
    }

    public static boolean loadTestCape() {
        String location = DebugMode.debugSettings.cape.location;
        File imageF = new File(CONFIG_DIR, location + ".png");
        if (imageF.isFile()) {
            class_310.method_1551().method_1531().method_4616(TEST_CAPE, (class_1044)new LocalCapeTexture(new class_2960("cosmetica_debug", location.toLowerCase(Locale.ROOT)), 2, () -> {
                class_1011 class_10112;
                BufferedInputStream stream = new BufferedInputStream(new FileInputStream(imageF));
                try {
                    class_10112 = class_1011.method_4309((InputStream)stream);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Cosmetica.LOGGER.error("Error reading test cape image for " + location, (Throwable)e);
                        return null;
                    }
                }
                ((InputStream)stream).close();
                return class_10112;
            }));
            CustomLayer.CAPE_OVERRIDER.push(TEST_CAPE);
            CosmeticaSkinManager.setTestUploaded("loaded_cape");
            frameDelayMs = DebugMode.debugSettings.cape.frameDelay;
            return true;
        }
        Cosmetica.LOGGER.warn("No cape image found at {}. Skipping loading the cape override!", (Object)location);
        CustomLayer.CAPE_OVERRIDER.clear();
        return false;
    }

    public static boolean loadDebugSettings() throws IOException {
        if (!DEBUG_SETTINGS.exists()) {
            return false;
        }
        try (FileReader reader = new FileReader(DEBUG_SETTINGS);){
            debugSettings = (DebugModeConfig)new Gson().fromJson((Reader)reader, DebugModeConfig.class);
        }
        return true;
    }

    public static void saveDebugSettings() throws IOException {
        try (FileWriter writer = new FileWriter(DEBUG_SETTINGS);){
            new Gson().toJson((Object)debugSettings, (Appendable)writer);
        }
    }

    static {
        DEBUG_LOGGER = LogManager.getLogger((String)"Cosmetica Debug");
        TEST_CAPE = new class_2960("cosmetica", "test/loaded_cape");
        frameDelayMs = 50;
        debugSettings = new DebugModeConfig();
        complainedAbout = new HashSet<String>();
        warnedAbout = new HashSet<String>();
        CONFIG_DIR = new File(FabricLoader.getInstance().getConfigDir().toFile(), "cosmetica");
        DEBUG_SETTINGS = new File(CONFIG_DIR, "debug_settings.json");
        if (ENABLED) {
            CONFIG_DIR.mkdirs();
            DEBUG_LOGGER.info("Debug Mode Enabled.");
            try {
                if (!DebugMode.loadDebugSettings()) {
                    DEBUG_SETTINGS.createNewFile();
                }
                DebugMode.saveDebugSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            class_310.method_1551().method_18858(() -> {
                DebugMode.log("Loading test models and capes...", new Object[0]);
                DebugMode.loadTestModel(LocalModelType.HAT);
                DebugMode.loadTestModel(LocalModelType.LEFT_SHOULDERBUDDY);
                DebugMode.loadTestModel(LocalModelType.RIGHT_SHOULDERBUDDY);
                DebugMode.loadTestModel(LocalModelType.BACK_BLING);
                DebugMode.loadTestCape();
            });
        }
    }

    public record LocalModelType(CosmeticStack<BakableModel> modelOverride, Supplier<String> localIdProvider, IntSupplier extraInfoLoader) {
        public static final LocalModelType HAT = new LocalModelType(Hats.OVERRIDDEN, () -> DebugMode.debugSettings.hat.location, () -> DebugMode.debugSettings.hat.flags);
        public static final LocalModelType LEFT_SHOULDERBUDDY = new LocalModelType(ShoulderBuddies.LEFT_OVERRIDDEN, () -> DebugMode.debugSettings.leftShoulderBuddy.location, () -> DebugMode.debugSettings.rightShoulderBuddy.flags);
        public static final LocalModelType RIGHT_SHOULDERBUDDY = new LocalModelType(ShoulderBuddies.RIGHT_OVERRIDDEN, () -> DebugMode.debugSettings.rightShoulderBuddy.location, () -> DebugMode.debugSettings.rightShoulderBuddy.flags);
        public static final LocalModelType BACK_BLING = new LocalModelType(BackBling.OVERRIDDEN, () -> DebugMode.debugSettings.backBling.location, () -> DebugMode.debugSettings.backBling.flags);
    }
}

