/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.utils.textures;

import cc.cosmetica.cosmetica.mixin.textures.NativeImageAccessorMixin;
import cc.cosmetica.cosmetica.utils.DebugMode;
import com.mojang.blaze3d.platform.TextureUtil;
import net.minecraft.class_1011;
import net.minecraft.class_1044;

public abstract class AnimatedTexture
extends class_1044 {
    protected class_1011 image;
    protected int frameCounterTicks = 1;
    protected final int aspectRatio;
    private int frames = 1;
    private int frameHeight;
    private int frame;
    private int tick;

    public AnimatedTexture(int aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    protected void setupAnimations() throws IllegalStateException {
        if (!this.isAnimatable()) {
            throw new IllegalStateException("Not an animatable texture but setupAnimations() was called!");
        }
        this.frame = 0;
        this.frames = this.aspectRatio * this.image.method_4323() / this.image.method_4307();
        this.frameHeight = this.image.method_4323() / this.frames;
        DebugMode.log("Setting up animations for " + this.frames + " frames", new Object[0]);
        if (this.frames <= 0) {
            throw new IllegalStateException("Frames cannot be less than one! If you're not using a cape loaded locally, please contact the Cosmetica devs asap. Debug data: frames=" + this.frames + ",frameHeight=" + this.frameHeight + ",frameDelayTicks=" + this.frameCounterTicks + ",width=" + this.image.method_4307() + ",height=" + this.image.method_4323());
        }
    }

    protected void setupStatic() {
        this.frameHeight = this.image.method_4323();
    }

    protected void upload() {
        TextureUtil.prepareImage((int)this.method_4624(), (int)0, (int)this.image.method_4307(), (int)this.frameHeight);
        this.image.method_22619(0, 0, 0, 0, this.frameHeight * this.frame, this.image.method_4307(), this.frameHeight, this.field_5205, false, false, false);
    }

    protected void doTick() {
        if (((NativeImageAccessorMixin)this.image).getPixels() != 0L) {
            this.tick = (this.tick + 1) % this.frameCounterTicks;
            if (this.tick == 0) {
                this.frame = (this.frame + 1) % this.frames;
                this.upload();
            }
        }
    }

    public class_1011 getRawImage() {
        return this.image;
    }

    public boolean isAnimatable() {
        return this.aspectRatio > 0;
    }

    public int getFrameHeight() {
        return this.isAnimatable() ? this.frameHeight : this.image.method_4323();
    }

    public int getFrameCount() {
        return this.frames;
    }

    public String toString() {
        return "AnimatedTexture{image=" + this.image + ", frameCounterTicks=" + this.frameCounterTicks + ", aspectRatio=" + this.aspectRatio + ", frames=" + this.frames + ", frameHeight=" + this.frameHeight + ", frame=" + this.frame + ", tick=" + this.tick + "}";
    }
}

