/*
 * Decompiled with CFR 0.152.
 */
package cc.cosmetica.cosmetica.utils.textures;

import cc.cosmetica.cosmetica.Cosmetica;
import cc.cosmetica.cosmetica.mixin.textures.NativeImageAccessorMixin;
import cc.cosmetica.cosmetica.utils.DebugMode;
import cc.cosmetica.cosmetica.utils.textures.AnimatedTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import net.minecraft.class_1061;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class LocalCapeTexture
extends AnimatedTexture
implements class_1061 {
    private final class_2960 debugPath;
    private final Supplier<class_1011> imageSupplier;

    public LocalCapeTexture(class_2960 debugPath, int aspectRatio, Supplier<class_1011> image) {
        super(aspectRatio);
        this.imageSupplier = image;
        this.debugPath = debugPath;
        DebugMode.log("Uploading native texture {}", this.debugPath);
        this.image = this.imageSupplier.get();
        if (this.image == null) {
            Cosmetica.LOGGER.warn("Sorry texture machine broke for {}", (Object)this.debugPath);
        } else {
            this.setupAnimations();
        }
    }

    @Override
    protected void setupAnimations() throws IllegalStateException {
        super.setupAnimations();
        this.frameCounterTicks = Math.max(1, DebugMode.frameDelayMs / 50);
    }

    public void method_4625(class_3300 resourceManager) {
        if (this.image == null) {
            return;
        }
        if (((NativeImageAccessorMixin)this.image).getPixels() == 0L) {
            if (RenderSystem.isOnRenderThreadOrInit()) {
                this.reload();
            } else {
                RenderSystem.recordRenderCall(this::reload);
            }
            return;
        }
        this.upload();
    }

    private void reload() {
        DebugMode.log("Re-uploading native texture {}", this.debugPath);
        this.image = this.imageSupplier.get();
        if (this.image == null) {
            Cosmetica.LOGGER.warn("Sorry texture machine broke for {}", (Object)this.debugPath);
        } else {
            this.setupAnimations();
            this.upload();
        }
    }

    public void method_4622() {
        this.doTick();
    }
}

