/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.request;

import io.ktor.client.engine.HttpClientEngineCapability;
import io.ktor.client.engine.HttpClientEngineCapabilityKt;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestData;
import io.ktor.client.request.RequestBodyKt;
import io.ktor.client.utils.EmptyContent;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpMethod;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.Attributes;
import io.ktor.util.AttributesJvmKt;
import io.ktor.util.AttributesKt;
import io.ktor.util.InternalAPI;
import io.ktor.util.StringValuesKt;
import io.ktor.util.reflect.TypeInfo;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 G2\u00020\u0001:\u0001GB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J'\u0010\u000b\u001a\u0004\u0018\u00018\u0000\"\b\b\u0000\u0010\b*\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\u000b\u0010\fJ&\u0010\u0012\u001a\u00020\u000f2\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J-\u0010\u0015\u001a\u00020\u000f\"\b\b\u0000\u0010\b*\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u0019J,\u0010\u001d\u001a\u00020\u000f2\u001d\u0010\u0011\u001a\u0019\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u000f0\u001b\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R*\u0010$\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00078\u0006@GX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R(\u00100\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010*8F@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R*\u00102\u001a\u0002012\u0006\u0010#\u001a\u0002018\u0006@@X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00109\u001a\u0002088\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<R\"\u0010>\u001a\u00020=8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b>\u0010?\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u0017\u0010\u001d\u001a\u00020\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010D\u001a\u0004\bE\u0010F\u00a8\u0006H"}, d2={"Lio/ktor/client/request/HttpRequestBuilder;", "Lio/ktor/http/HttpMessageBuilder;", "<init>", "()V", "Lio/ktor/client/request/HttpRequestData;", "build", "()Lio/ktor/client/request/HttpRequestData;", "", "T", "Lio/ktor/client/engine/HttpClientEngineCapability;", "key", "getCapabilityOrNull", "(Lio/ktor/client/engine/HttpClientEngineCapability;)Ljava/lang/Object;", "Lkotlin/Function1;", "Lio/ktor/util/Attributes;", "", "Lkotlin/ExtensionFunctionType;", "block", "setAttributes", "(Lkotlin/jvm/functions/Function1;)V", "capability", "setCapability", "(Lio/ktor/client/engine/HttpClientEngineCapability;Ljava/lang/Object;)V", "builder", "takeFrom", "(Lio/ktor/client/request/HttpRequestBuilder;)Lio/ktor/client/request/HttpRequestBuilder;", "takeFromWithExecutionContext", "Lkotlin/Function2;", "Lio/ktor/http/URLBuilder;", "url", "(Lkotlin/jvm/functions/Function2;)V", "attributes", "Lio/ktor/util/Attributes;", "getAttributes", "()Lio/ktor/util/Attributes;", "<set-?>", "body", "Ljava/lang/Object;", "getBody", "()Ljava/lang/Object;", "setBody", "(Ljava/lang/Object;)V", "Lio/ktor/util/reflect/TypeInfo;", "value", "getBodyType", "()Lio/ktor/util/reflect/TypeInfo;", "setBodyType", "(Lio/ktor/util/reflect/TypeInfo;)V", "bodyType", "Lkotlinx/coroutines/Job;", "executionContext", "Lkotlinx/coroutines/Job;", "getExecutionContext", "()Lkotlinx/coroutines/Job;", "setExecutionContext$ktor_client_core", "(Lkotlinx/coroutines/Job;)V", "Lio/ktor/http/HeadersBuilder;", "headers", "Lio/ktor/http/HeadersBuilder;", "getHeaders", "()Lio/ktor/http/HeadersBuilder;", "Lio/ktor/http/HttpMethod;", "method", "Lio/ktor/http/HttpMethod;", "getMethod", "()Lio/ktor/http/HttpMethod;", "setMethod", "(Lio/ktor/http/HttpMethod;)V", "Lio/ktor/http/URLBuilder;", "getUrl", "()Lio/ktor/http/URLBuilder;", "Companion", "ktor-client-core"})
public final class HttpRequestBuilder
implements HttpMessageBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URLBuilder url = new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null);
    @NotNull
    private HttpMethod method = HttpMethod.Companion.getGet();
    @NotNull
    private final HeadersBuilder headers = new HeadersBuilder(0, 1, null);
    @NotNull
    private Object body = EmptyContent.INSTANCE;
    @NotNull
    private Job executionContext = (Job)SupervisorKt.SupervisorJob$default(null, (int)1, null);
    @NotNull
    private final Attributes attributes = AttributesJvmKt.Attributes(true);

    @NotNull
    public final URLBuilder getUrl() {
        return this.url;
    }

    @NotNull
    public final HttpMethod getMethod() {
        return this.method;
    }

    public final void setMethod(@NotNull HttpMethod httpMethod) {
        Intrinsics.checkNotNullParameter((Object)httpMethod, (String)"<set-?>");
        this.method = httpMethod;
    }

    @Override
    @NotNull
    public HeadersBuilder getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Object getBody() {
        return this.body;
    }

    @InternalAPI
    public final void setBody(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
        this.body = object;
    }

    @Nullable
    public final TypeInfo getBodyType() {
        return this.attributes.getOrNull(RequestBodyKt.getBodyTypeAttributeKey());
    }

    @InternalAPI
    public final void setBodyType(@Nullable TypeInfo value) {
        if (value != null) {
            this.attributes.put(RequestBodyKt.getBodyTypeAttributeKey(), value);
        } else {
            this.attributes.remove(RequestBodyKt.getBodyTypeAttributeKey());
        }
    }

    @NotNull
    public final Job getExecutionContext() {
        return this.executionContext;
    }

    public final void setExecutionContext$ktor_client_core(@NotNull Job job2) {
        Intrinsics.checkNotNullParameter((Object)job2, (String)"<set-?>");
        this.executionContext = job2;
    }

    @NotNull
    public final Attributes getAttributes() {
        return this.attributes;
    }

    public final void url(@NotNull Function2<? super URLBuilder, ? super URLBuilder, Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        block2.invoke((Object)this.url, (Object)this.url);
    }

    @NotNull
    public final HttpRequestData build() {
        Object object = this.body;
        OutgoingContent outgoingContent = object instanceof OutgoingContent ? (OutgoingContent)object : null;
        if (outgoingContent == null) {
            throw new IllegalStateException(("No request transformation found: " + this.body).toString());
        }
        return new HttpRequestData(this.url.build(), this.method, this.getHeaders().build(), outgoingContent, this.executionContext, this.attributes);
    }

    public final void setAttributes(@NotNull Function1<? super Attributes, Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        Attributes attributes2 = this.attributes;
        block2.invoke((Object)attributes2);
    }

    @InternalAPI
    @NotNull
    public final HttpRequestBuilder takeFromWithExecutionContext(@NotNull HttpRequestBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.executionContext = builder.executionContext;
        return this.takeFrom(builder);
    }

    @NotNull
    public final HttpRequestBuilder takeFrom(@NotNull HttpRequestBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.method = builder.method;
        this.body = builder.body;
        this.setBodyType(builder.getBodyType());
        URLUtilsKt.takeFrom(this.url, builder.url);
        this.url.setEncodedPathSegments(this.url.getEncodedPathSegments());
        StringValuesKt.appendAll(this.getHeaders(), builder.getHeaders());
        AttributesKt.putAll(this.attributes, builder.attributes);
        return this;
    }

    public final <T> void setCapability(@NotNull HttpClientEngineCapability<T> key, @NotNull T capability) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(capability, (String)"capability");
        Map<HttpClientEngineCapability<?>, Object> capabilities2 = this.attributes.computeIfAbsent(HttpClientEngineCapabilityKt.getENGINE_CAPABILITIES_KEY(), setCapability.capabilities.1.INSTANCE);
        capabilities2.put(key, capability);
    }

    @Nullable
    public final <T> T getCapabilityOrNull(@NotNull HttpClientEngineCapability<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Map<HttpClientEngineCapability<?>, Object> map2 = this.attributes.getOrNull(HttpClientEngineCapabilityKt.getENGINE_CAPABILITIES_KEY());
        return (T)(map2 != null ? map2.get(key) : null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/ktor/client/request/HttpRequestBuilder$Companion;", "", "<init>", "()V", "ktor-client-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

