/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.http.ContentType;
import io.ktor.http.FileContentTypeKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.cio.ByteBufferPoolKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.jvm.javaio.ReadingKt;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B%\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0006\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\n8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lio/ktor/http/content/URIFileContent;", "Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "Ljava/net/URL;", "url", "Lio/ktor/http/ContentType;", "contentType", "<init>", "(Ljava/net/URL;Lio/ktor/http/ContentType;)V", "Ljava/net/URI;", "uri", "", "contentLength", "(Ljava/net/URI;Lio/ktor/http/ContentType;Ljava/lang/Long;)V", "Lio/ktor/utils/io/ByteReadChannel;", "readFrom", "()Lio/ktor/utils/io/ByteReadChannel;", "Ljava/lang/Long;", "getContentLength", "()Ljava/lang/Long;", "Lio/ktor/http/ContentType;", "getContentType", "()Lio/ktor/http/ContentType;", "Ljava/net/URI;", "getUri", "()Ljava/net/URI;", "ktor-http"})
public final class URIFileContent
extends OutgoingContent.ReadChannelContent {
    @NotNull
    private final URI uri;
    @NotNull
    private final ContentType contentType;
    @Nullable
    private final Long contentLength;

    public URIFileContent(@NotNull URI uri, @NotNull ContentType contentType2, @Nullable Long contentLength) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)contentType2, (String)"contentType");
        this.uri = uri;
        this.contentType = contentType2;
        this.contentLength = contentLength;
    }

    public /* synthetic */ URIFileContent(URI uRI, ContentType contentType2, Long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string = uRI.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.path");
            contentType2 = FileContentTypeKt.defaultForFilePath(ContentType.Companion, string);
        }
        if ((n & 4) != 0) {
            l = null;
        }
        this(uRI, contentType2, l);
    }

    @NotNull
    public final URI getUri() {
        return this.uri;
    }

    @Override
    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    @Nullable
    public Long getContentLength() {
        return this.contentLength;
    }

    public URIFileContent(@NotNull URL url2, @NotNull ContentType contentType2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Intrinsics.checkNotNullParameter((Object)contentType2, (String)"contentType");
        URI uRI = url2.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"url.toURI()");
        this(uRI, contentType2, null, 4, null);
    }

    public /* synthetic */ URIFileContent(URL uRL, ContentType contentType2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string = uRL.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.path");
            contentType2 = FileContentTypeKt.defaultForFilePath(ContentType.Companion, string);
        }
        this(uRL, contentType2);
    }

    @Override
    @NotNull
    public ByteReadChannel readFrom() {
        InputStream inputStream2 = this.uri.toURL().openStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"uri.toURL().openStream()");
        return ReadingKt.toByteReadChannel$default(inputStream2, null, ByteBufferPoolKt.getKtorDefaultPool(), 1, null);
    }
}

