/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CIOCipherSuites;
import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.TLSVersion;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.SignatureAlgorithmKt;
import io.ktor.network.tls.extensions.TLSExtension;
import io.ktor.network.tls.extensions.TLSExtensionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\r\u0010\u000eR\u0017\u0010\u0010\u001a\u00020\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\t\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\n8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0017\u001a\u0004\b\u001c\u0010\u0019R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001d\u001a\u0004\b \u0010\u001fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lio/ktor/network/tls/TLSServerHello;", "", "Lio/ktor/network/tls/TLSVersion;", "version", "", "serverSeed", "sessionId", "", "suite", "compressionMethod", "", "Lio/ktor/network/tls/extensions/TLSExtension;", "extensions", "<init>", "(Lio/ktor/network/tls/TLSVersion;[B[BSSLjava/util/List;)V", "Lio/ktor/network/tls/CipherSuite;", "cipherSuite", "Lio/ktor/network/tls/CipherSuite;", "getCipherSuite", "()Lio/ktor/network/tls/CipherSuite;", "S", "getCompressionMethod", "()S", "Ljava/util/List;", "getExtensions", "()Ljava/util/List;", "Lio/ktor/network/tls/extensions/HashAndSign;", "hashAndSignAlgorithms", "getHashAndSignAlgorithms", "[B", "getServerSeed", "()[B", "getSessionId", "Lio/ktor/network/tls/TLSVersion;", "getVersion", "()Lio/ktor/network/tls/TLSVersion;", "ktor-network-tls"})
public final class TLSServerHello {
    @NotNull
    private final TLSVersion version;
    @NotNull
    private final byte[] serverSeed;
    @NotNull
    private final byte[] sessionId;
    private final short compressionMethod;
    @NotNull
    private final List<TLSExtension> extensions;
    @NotNull
    private final CipherSuite cipherSuite;
    @NotNull
    private final List<HashAndSign> hashAndSignAlgorithms;

    public TLSServerHello(@NotNull TLSVersion version, @NotNull byte[] serverSeed, @NotNull byte[] sessionId, short suite, short compressionMethod, @NotNull List<TLSExtension> extensions) {
        Object v0;
        Object it;
        block3: {
            Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
            Intrinsics.checkNotNullParameter((Object)serverSeed, (String)"serverSeed");
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
            this.version = version;
            this.serverSeed = serverSeed;
            this.sessionId = sessionId;
            this.compressionMethod = compressionMethod;
            this.extensions = extensions;
            Iterable iterable = CIOCipherSuites.INSTANCE.getSupportedSuites();
            TLSServerHello tLSServerHello = this;
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                it = (CipherSuite)t;
                boolean bl = false;
                if (!(((CipherSuite)it).getCode() == suite)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        CipherSuite cipherSuite = v0;
        if (cipherSuite == null) {
            throw new IllegalStateException(("Server cipher suite is not supported: " + suite).toString());
        }
        tLSServerHello.cipherSuite = cipherSuite;
        List algorithms = new ArrayList();
        Iterable $this$forEach$iv = this.extensions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (TLSExtension)element$iv;
            boolean bl = false;
            if (WhenMappings.$EnumSwitchMapping$0[((TLSExtension)it).getType().ordinal()] != 1) continue;
            CollectionsKt.addAll((Collection)algorithms, (Iterable)SignatureAlgorithmKt.parseSignatureAlgorithms(((TLSExtension)it).getPacket()));
        }
        this.hashAndSignAlgorithms = algorithms;
    }

    public /* synthetic */ TLSServerHello(TLSVersion tLSVersion, byte[] byArray, byte[] byArray2, short s, short s2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(tLSVersion, byArray, byArray2, s, s2, list);
    }

    @NotNull
    public final TLSVersion getVersion() {
        return this.version;
    }

    @NotNull
    public final byte[] getServerSeed() {
        return this.serverSeed;
    }

    @NotNull
    public final byte[] getSessionId() {
        return this.sessionId;
    }

    public final short getCompressionMethod() {
        return this.compressionMethod;
    }

    @NotNull
    public final List<TLSExtension> getExtensions() {
        return this.extensions;
    }

    @NotNull
    public final CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    @NotNull
    public final List<HashAndSign> getHashAndSignAlgorithms() {
        return this.hashAndSignAlgorithms;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TLSExtensionType.values().length];
            nArray[TLSExtensionType.SIGNATURE_ALGORITHMS.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

