/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.pool;

import io.ktor.utils.io.pool.DefaultPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\t\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lio/ktor/utils/io/pool/DirectByteBufferPool;", "Lio/ktor/utils/io/pool/DefaultPool;", "Ljava/nio/ByteBuffer;", "", "capacity", "bufferSize", "<init>", "(II)V", "instance", "clearInstance", "(Ljava/nio/ByteBuffer;)Ljava/nio/ByteBuffer;", "produceInstance", "()Ljava/nio/ByteBuffer;", "", "validateInstance", "(Ljava/nio/ByteBuffer;)V", "I", "getBufferSize", "()I", "ktor-io"})
public final class DirectByteBufferPool
extends DefaultPool<ByteBuffer> {
    private final int bufferSize;

    public DirectByteBufferPool(int capacity, int bufferSize) {
        super(capacity);
        this.bufferSize = bufferSize;
    }

    public /* synthetic */ DirectByteBufferPool(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 2000;
        }
        if ((n3 & 2) != 0) {
            n2 = 4096;
        }
        this(n, n2);
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    @NotNull
    protected ByteBuffer produceInstance() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.bufferSize);
        Intrinsics.checkNotNull((Object)byteBuffer);
        return byteBuffer;
    }

    @Override
    @NotNull
    protected ByteBuffer clearInstance(@NotNull ByteBuffer instance) {
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        ByteBuffer $this$clearInstance_u24lambda_u2d0 = byteBuffer = instance;
        boolean bl = false;
        $this$clearInstance_u24lambda_u2d0.clear();
        $this$clearInstance_u24lambda_u2d0.order(ByteOrder.BIG_ENDIAN);
        return byteBuffer;
    }

    @Override
    protected void validateInstance(@NotNull ByteBuffer instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        if (!(instance.capacity() == this.bufferSize)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!instance.isDirect()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    public DirectByteBufferPool() {
        this(0, 0, 3, null);
    }
}

