/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.streams;

import io.ktor.utils.io.bits.MemoryJvmKt;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import io.ktor.utils.io.pool.ObjectPool;
import io.ktor.utils.io.streams.ByteArraysKt;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0014\u00a2\u0006\u0004\b\n\u0010\u000bJ-\u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0014\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0014\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0015"}, d2={"Lio/ktor/utils/io/streams/OutputStreamAdapter;", "Lio/ktor/utils/io/core/Output;", "Lio/ktor/utils/io/pool/ObjectPool;", "Lio/ktor/utils/io/core/internal/ChunkBuffer;", "pool", "Ljava/io/OutputStream;", "stream", "<init>", "(Lio/ktor/utils/io/pool/ObjectPool;Ljava/io/OutputStream;)V", "", "closeDestination", "()V", "Lio/ktor/utils/io/bits/Memory;", "source", "", "offset", "length", "flush-62zg_DM", "(Ljava/nio/ByteBuffer;II)V", "flush", "Ljava/io/OutputStream;", "ktor-io"})
final class OutputStreamAdapter
extends Output {
    @NotNull
    private final OutputStream stream;

    public OutputStreamAdapter(@NotNull ObjectPool<ChunkBuffer> pool, @NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter(pool, (String)"pool");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        super(pool);
        this.stream = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flush-62zg_DM(@NotNull ByteBuffer source, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        ByteBuffer nioBuffer = source;
        if (nioBuffer.hasArray() && !nioBuffer.isReadOnly()) {
            this.stream.write(nioBuffer.array(), nioBuffer.arrayOffset() + offset, length);
            return;
        }
        byte[] array = ByteArraysKt.getByteArrayPool().borrow();
        ByteBuffer slice = MemoryJvmKt.sliceSafe(nioBuffer, offset, length);
        try {
            int partSize;
            while ((partSize = Math.min(slice.remaining(), array.length)) != 0) {
                slice.get(array, 0, partSize);
                this.stream.write(array, 0, partSize);
            }
        }
        finally {
            ByteArraysKt.getByteArrayPool().recycle(array);
        }
    }

    @Override
    protected void closeDestination() {
        this.stream.close();
    }
}

