/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.craftify.themes.library;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.Color;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.craftify.themes.ColorSerializer;
import tech.thatgravyboat.craftify.themes.Theme;
import tech.thatgravyboat.craftify.themes.UrlSerializer;
import tech.thatgravyboat.craftify.themes.library.LibraryTheme;
import tech.thatgravyboat.craftify.utils.Utils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0003R\u001c\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\"\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Ltech/thatgravyboat/craftify/themes/library/LibraryStorage;", "", "<init>", "()V", "", "createMap", "download", "", "id", "Ltech/thatgravyboat/craftify/themes/library/LibraryTheme;", "getTheme", "(Ljava/lang/String;)Ltech/thatgravyboat/craftify/themes/library/LibraryTheme;", "", "getThemes", "()Ljava/util/Collection;", "refresh", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "GSON", "Lcom/google/gson/Gson;", "JSON_URL", "Ljava/lang/String;", "", "storage", "Ljava/util/Map;", "Craftify"})
public final class LibraryStorage {
    @NotNull
    public static final LibraryStorage INSTANCE = new LibraryStorage();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)Color.class), (Object)ColorSerializer.INSTANCE).registerTypeAdapter((Type)((Object)URL.class), (Object)UrlSerializer.INSTANCE).create();
    @NotNull
    private static final String JSON_URL = "https://raw.githubusercontent.com/Craftify-Mod/Data/main/themes.json";
    @NotNull
    private static Map<String, LibraryTheme> storage = new LinkedHashMap();

    private LibraryStorage() {
    }

    @NotNull
    public final LibraryTheme getTheme(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        LibraryTheme libraryTheme = storage.get("default");
        Intrinsics.checkNotNull((Object)libraryTheme);
        return storage.getOrDefault(id, libraryTheme);
    }

    @NotNull
    public final Collection<LibraryTheme> getThemes() {
        return storage.values();
    }

    public final void refresh() {
        this.createMap();
        this.download();
    }

    private final void createMap() {
        Pair[] pairArray = new Pair[]{new Pair((Object)"default", (Object)new LibraryTheme("default", "Default Theme", "ThatGravyBoat", new URL("https://files.teamresourceful.com/r/ctWcDL.png"), new URL("https://files.teamresourceful.com/r/TeRHEF.png"), "This is the default theme provided by the mod.", new Theme(null, null, null, 0, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x1FFFFF, null)))};
        storage = MapsKt.mutableMapOf((Pair[])pairArray);
    }

    private final void download() {
        try {
            LibraryTheme[] fromJson = (LibraryTheme[])GSON.fromJson(Utils.INSTANCE.fetchString(JSON_URL), LibraryTheme[].class);
            Intrinsics.checkNotNullExpressionValue((Object)fromJson, (String)"fromJson");
            for (LibraryTheme libraryTheme : fromJson) {
                storage.put(libraryTheme.getId(), libraryTheme);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        INSTANCE.refresh();
    }
}

