/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.craftify.ui;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.UIConstraints;
import gg.essential.elementa.components.UIContainer;
import gg.essential.elementa.components.UIImage;
import gg.essential.elementa.components.image.ImageCache;
import gg.essential.elementa.constraints.HeightConstraint;
import gg.essential.elementa.constraints.WidthConstraint;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.events.UIClickEvent;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.craftify.themes.ThemeConfig;
import tech.thatgravyboat.craftify.utils.MemoryImageCache;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00120\b\u0002\u0010\r\u001a*\u0012\u0004\u0012\u00020\b\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007\u00a2\u0006\u0002\b\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0016\u0010\u001aJ\u001d\u0010\u0016\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0016\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001dR\u0016\u0010\u0004\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001fR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010 R\u0016\u0010\u0019\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010!R\u0016\u0010\u0003\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001fR\u0016\u0010\u000b\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010 \u00a8\u0006\""}, d2={"Ltech/thatgravyboat/craftify/ui/UIButton;", "Lgg/essential/elementa/components/UIContainer;", "Ljava/net/URL;", "original", "clicked", "", "color", "Lkotlin/Function2;", "Lgg/essential/elementa/UIComponent;", "Lkotlin/ParameterName;", "name", "state", "Lkotlin/ExtensionFunctionType;", "click", "<init>", "(Ljava/net/URL;Ljava/net/URL;ZLkotlin/jvm/functions/Function2;)V", "url", "Lgg/essential/elementa/components/UIImage;", "createButtonImageFromUrl", "(Ljava/net/URL;)Lgg/essential/elementa/components/UIImage;", "og", "", "updateImage", "(Ljava/net/URL;Ljava/net/URL;)V", "", "icon", "(Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "updateState", "(Z)V", "updateStateWithHover", "Ljava/net/URL;", "Z", "Lgg/essential/elementa/components/UIImage;", "Craftify"})
@SourceDebugExtension(value={"SMAP\nUIButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UIButton.kt\ntech/thatgravyboat/craftify/ui/UIButton\n+ 2 components.kt\ngg/essential/elementa/dsl/ComponentsKt\n*L\n1#1,84:1\n9#2,3:85\n*S KotlinDebug\n*F\n+ 1 UIButton.kt\ntech/thatgravyboat/craftify/ui/UIButton\n*L\n78#1:85,3\n*E\n"})
public final class UIButton
extends UIContainer {
    @NotNull
    private URL original;
    @NotNull
    private URL clicked;
    private final boolean color;
    private boolean state;
    @NotNull
    private UIImage icon;

    public UIButton(@NotNull URL original, @NotNull URL clicked, boolean color, final @Nullable Function2<? super UIComponent, ? super Boolean, Boolean> click) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)clicked, (String)"clicked");
        this.original = original;
        this.clicked = clicked;
        this.color = color;
        this.icon = this.createButtonImageFromUrl(this.original);
        this.onMouseClick((Function2)new Function2<UIComponent, UIClickEvent, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent event) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getMouseButton() == 0 && click != null && ((Boolean)click.invoke((Object)$this$onMouseClick, (Object)state)).booleanValue()) {
                    this.updateStateWithHover(!state);
                }
            }
        });
        this.onMouseEnter((Function1)new Function1<UIComponent, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onMouseEnter) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseEnter, (String)"$this$onMouseEnter");
                icon.setColor(state && color ? ThemeConfig.INSTANCE.getSelectedHoverControlColor() : ThemeConfig.INSTANCE.getHoverControlColor());
            }
        });
        this.onMouseLeave((Function1)new Function1<UIComponent, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onMouseLeave) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseLeave, (String)"$this$onMouseLeave");
                icon.setColor(state && color ? ThemeConfig.INSTANCE.getSelectedControlColor() : ThemeConfig.INSTANCE.getControlColor());
            }
        });
    }

    public /* synthetic */ UIButton(URL uRL, URL uRL2, boolean bl, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            function2 = null;
        }
        this(uRL, uRL2, bl, (Function2<? super UIComponent, ? super Boolean, Boolean>)function2);
    }

    public final void updateState(boolean state) {
        if (this.state != state) {
            this.state = state;
            this.updateImage(this.clicked, this.original);
            this.icon.setColor(state && this.color ? ThemeConfig.INSTANCE.getSelectedControlColor() : ThemeConfig.INSTANCE.getControlColor());
        }
    }

    private final void updateStateWithHover(boolean state) {
        this.state = state;
        this.updateImage(this.clicked, this.original);
        this.icon.setColor(state && this.color ? (this.isHovered() ? ThemeConfig.INSTANCE.getSelectedHoverControlColor() : ThemeConfig.INSTANCE.getSelectedControlColor()) : (this.isHovered() ? ThemeConfig.INSTANCE.getHoverControlColor() : ThemeConfig.INSTANCE.getControlColor()));
    }

    public final void updateImage(@NotNull String icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        URL url2 = new URL(icon);
        this.updateImage(url2, url2);
    }

    public final void updateImage(@NotNull String click, @NotNull String og) {
        Intrinsics.checkNotNullParameter((Object)click, (String)"click");
        Intrinsics.checkNotNullParameter((Object)og, (String)"og");
        this.updateImage(new URL(click), new URL(og));
    }

    private final void updateImage(URL click, URL og) {
        this.clicked = click;
        this.original = og;
        try {
            this.removeChild((UIComponent)this.icon);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.icon = this.createButtonImageFromUrl(this.state ? this.clicked : this.original);
        this.addChild((UIComponent)this.icon);
    }

    private final UIImage createButtonImageFromUrl(URL url2) {
        UIComponent uIComponent;
        UIComponent $this$constrain$iv = (UIComponent)UIImage.Companion.ofURL(url2, (ImageCache)MemoryImageCache.INSTANCE);
        boolean $i$f$constrain = false;
        UIComponent $this$constrain_u24lambda_u2d0$iv = uIComponent = $this$constrain$iv;
        boolean bl = false;
        UIConstraints $this$createButtonImageFromUrl_u24lambda_u240 = $this$constrain_u24lambda_u2d0$iv.getConstraints();
        boolean bl2 = false;
        $this$createButtonImageFromUrl_u24lambda_u240.setHeight((HeightConstraint)UtilitiesKt.percent((Number)100));
        $this$createButtonImageFromUrl_u24lambda_u240.setWidth((WidthConstraint)UtilitiesKt.percent((Number)100));
        return (UIImage)uIComponent;
    }
}

