/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.jukebox.api.state;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.jukebox.api.state.PlayerState;
import tech.thatgravyboat.jukebox.api.state.ShuffleState;
import tech.thatgravyboat.jukebox.api.state.Song;
import tech.thatgravyboat.jukebox.api.state.SongState;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ.\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010#\u001a\u0004\b$\u0010\rR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010%\u001a\u0004\b&\u0010\u000f\u00a8\u0006'"}, d2={"Ltech/thatgravyboat/jukebox/api/state/State;", "", "Ltech/thatgravyboat/jukebox/api/state/PlayerState;", "player", "Ltech/thatgravyboat/jukebox/api/state/Song;", "song", "Ltech/thatgravyboat/jukebox/api/state/SongState;", "songState", "<init>", "(Ltech/thatgravyboat/jukebox/api/state/PlayerState;Ltech/thatgravyboat/jukebox/api/state/Song;Ltech/thatgravyboat/jukebox/api/state/SongState;)V", "component1", "()Ltech/thatgravyboat/jukebox/api/state/PlayerState;", "component2", "()Ltech/thatgravyboat/jukebox/api/state/Song;", "component3", "()Ltech/thatgravyboat/jukebox/api/state/SongState;", "copy", "(Ltech/thatgravyboat/jukebox/api/state/PlayerState;Ltech/thatgravyboat/jukebox/api/state/Song;Ltech/thatgravyboat/jukebox/api/state/SongState;)Ltech/thatgravyboat/jukebox/api/state/State;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "isSame", "(Ltech/thatgravyboat/jukebox/api/state/State;)Z", "", "toString", "()Ljava/lang/String;", "isPlaying", "()Z", "isShuffling", "Ltech/thatgravyboat/jukebox/api/state/PlayerState;", "getPlayer", "Ltech/thatgravyboat/jukebox/api/state/Song;", "getSong", "Ltech/thatgravyboat/jukebox/api/state/SongState;", "getSongState", "jukebox"})
public final class State {
    @NotNull
    private final PlayerState player;
    @NotNull
    private final Song song;
    @NotNull
    private final SongState songState;

    public State(@NotNull PlayerState player, @NotNull Song song, @NotNull SongState songState) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)song, (String)"song");
        Intrinsics.checkNotNullParameter((Object)songState, (String)"songState");
        this.player = player;
        this.song = song;
        this.songState = songState;
    }

    @NotNull
    public final PlayerState getPlayer() {
        return this.player;
    }

    @NotNull
    public final Song getSong() {
        return this.song;
    }

    @NotNull
    public final SongState getSongState() {
        return this.songState;
    }

    public final boolean isPlaying() {
        return this.songState.isPlaying();
    }

    public final boolean isShuffling() {
        return this.player.getShuffle() == ShuffleState.ON;
    }

    public final boolean isSame(@NotNull State other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)this.song.getTitle(), (Object)other.song.getTitle());
    }

    @NotNull
    public final PlayerState component1() {
        return this.player;
    }

    @NotNull
    public final Song component2() {
        return this.song;
    }

    @NotNull
    public final SongState component3() {
        return this.songState;
    }

    @NotNull
    public final State copy(@NotNull PlayerState player, @NotNull Song song, @NotNull SongState songState) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)song, (String)"song");
        Intrinsics.checkNotNullParameter((Object)songState, (String)"songState");
        return new State(player, song, songState);
    }

    public static /* synthetic */ State copy$default(State state, PlayerState playerState, Song song, SongState songState, int n, Object object) {
        if ((n & 1) != 0) {
            playerState = state.player;
        }
        if ((n & 2) != 0) {
            song = state.song;
        }
        if ((n & 4) != 0) {
            songState = state.songState;
        }
        return state.copy(playerState, song, songState);
    }

    @NotNull
    public String toString() {
        return "State(player=" + this.player + ", song=" + this.song + ", songState=" + this.songState + ')';
    }

    public int hashCode() {
        int result2 = this.player.hashCode();
        result2 = result2 * 31 + this.song.hashCode();
        result2 = result2 * 31 + this.songState.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof State)) {
            return false;
        }
        State state = (State)other;
        if (!Intrinsics.areEqual((Object)this.player, (Object)state.player)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.song, (Object)state.song)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.songState, (Object)state.songState);
    }
}

