/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.jukebox.impl.tidal;

import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.Job;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.jukebox.api.service.BaseService;
import tech.thatgravyboat.jukebox.api.service.ServiceFunction;
import tech.thatgravyboat.jukebox.api.service.ServicePhase;
import tech.thatgravyboat.jukebox.api.state.RepeatState;
import tech.thatgravyboat.jukebox.api.state.ShuffleState;
import tech.thatgravyboat.jukebox.api.state.State;
import tech.thatgravyboat.jukebox.impl.tidal.TidalService;
import tech.thatgravyboat.jukebox.impl.tidal.TidalServiceKt;
import tech.thatgravyboat.jukebox.impl.tidal.state.TidalErrorState;
import tech.thatgravyboat.jukebox.impl.tidal.state.TidalPlayerState;
import tech.thatgravyboat.jukebox.impl.tidal.state.TidalState;
import tech.thatgravyboat.jukebox.impl.tidal.state.TidalStateSerializer;
import tech.thatgravyboat.jukebox.utils.Http;
import tech.thatgravyboat.jukebox.utils.Scheduler;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0013\u0010\u0012\u001a\u00020\u0011H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0010J\u0017\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u0010J\u001f\u0010 \u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\"\u0010\u0015J\u000f\u0010#\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b#\u0010$R\u0018\u0010&\u001a\u0004\u0018\u00010%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010*\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"Ltech/thatgravyboat/jukebox/impl/tidal/TidalService;", "Ltech/thatgravyboat/jukebox/api/service/BaseService;", "", "port", "<init>", "(I)V", "", "Ltech/thatgravyboat/jukebox/api/service/ServiceFunction;", "getFunctions", "()Ljava/util/Set;", "Ltech/thatgravyboat/jukebox/api/service/ServicePhase;", "getPhase", "()Ltech/thatgravyboat/jukebox/api/service/ServicePhase;", "", "forward", "move", "(Z)Z", "", "requestPlayer", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "restart", "()V", "paused", "setPaused", "Ltech/thatgravyboat/jukebox/api/state/RepeatState;", "repeat", "setRepeat", "(Ltech/thatgravyboat/jukebox/api/state/RepeatState;)Z", "shuffle", "setShuffle", "volume", "notify", "setVolume", "(IZ)Z", "start", "stop", "()Z", "Lkotlinx/coroutines/Job;", "poller", "Lkotlinx/coroutines/Job;", "Lio/ktor/http/Url;", "pollingUrl", "Lio/ktor/http/Url;", "url", "jukebox"})
public final class TidalService
extends BaseService {
    @NotNull
    private final Url url;
    @NotNull
    private final Url pollingUrl;
    @Nullable
    private Job poller;

    public TidalService(int port) {
        this.url = URLUtilsKt.Url("http://localhost:" + port + "/player/");
        this.pollingUrl = URLUtilsKt.Url("http://localhost:" + port + "/current");
    }

    public /* synthetic */ TidalService(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 47836;
        }
        this(n);
    }

    @Override
    public void start() {
        this.poller = Scheduler.INSTANCE.schedule(0L, 2L, DurationUnit.SECONDS, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TidalService this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = TidalService.access$requestPlayer(this.this$0, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    public boolean stop() {
        Job job2 = this.poller;
        return job2 != null ? Scheduler.INSTANCE.invokeCancel(job2) : false;
    }

    @Override
    public void restart() {
        if (!this.stop()) {
            Scheduler.INSTANCE.schedule(2L, DurationUnit.SECONDS, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ TidalService this$0;
                {
                    this.this$0 = $receiver;
                    super(1, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.this$0.start();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        } else {
            this.start();
        }
    }

    @Override
    @NotNull
    public ServicePhase getPhase() {
        return this.poller != null && this.getState() == null ? ServicePhase.STARTING : (this.poller != null && this.getState() != null ? ServicePhase.RUNNING : ServicePhase.STOPPED);
    }

    private final Object requestPlayer(Continuation<? super Unit> $completion) {
        Http.get$default(Http.INSTANCE, this.pollingUrl, null, null, null, (Function2)new Function2<HttpResponse, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ TidalService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        response = (HttpResponse)this.L$0;
                        if (!Intrinsics.areEqual((Object)response.getStatus(), (Object)HttpStatusCode.Companion.getOK())) ** GOTO lbl34
                        json = JsonKt.Json$default(null, (Function1)requestPlayer.json.1.INSTANCE, (int)1, null);
                        this.L$0 = json;
                        this.label = 1;
                        v0 = HttpResponseKt.bodyAsText$default(response, null, (Continuation)this, 1, null);
                        if (v0 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        json = (Json)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        if (StringsKt.isBlank((CharSequence)(body = (String)v0)) == false) {
                            try {
                                var6_6 = (TidalState)json.decodeFromString((DeserializationStrategy)TidalStateSerializer.INSTANCE, body);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                var8_8 = "Json Error: " + body;
                                System.out.println((Object)var8_8);
                                var6_6 = new TidalErrorState("Error parsing Player JSON");
                            }
                            data = var6_6;
                            if (data instanceof TidalErrorState) {
                                this.this$0.onError("Polling error: " + ((TidalErrorState)data).getError());
                            } else if (data instanceof TidalPlayerState) {
                                this.this$0.onSuccess(((TidalPlayerState)data).getState());
                            }
                        }
lbl34:
                        // 7 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<HttpResponse, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull HttpResponse p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 7, null);
        return Unit.INSTANCE;
    }

    @Override
    public boolean setPaused(boolean paused) {
        if (this.getState() == null) {
            return false;
        }
        String action = paused ? "pause" : "play";
        Http.post$default(Http.INSTANCE, Http.INSTANCE.plus(this.url, action), null, null, null, (Function2)new Function2<HttpResponse, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ TidalService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        HttpResponse it = (HttpResponse)this.L$0;
                        if (!Intrinsics.areEqual((Object)it.getStatus(), (Object)HttpStatusCode.Companion.getOK())) {
                            this.this$0.onError("Error setting paused state");
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<HttpResponse, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull HttpResponse p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 7, null);
        return true;
    }

    @Override
    public boolean setShuffle(boolean shuffle) {
        State state = this.getState();
        if (state == null) {
            return false;
        }
        State state2 = state;
        if (state2.getPlayer().getShuffle() == ShuffleState.ON == shuffle) {
            return true;
        }
        Http.post$default(Http.INSTANCE, Http.INSTANCE.plus(this.url, "/shuffle/toggle"), null, null, null, (Function2)new Function2<HttpResponse, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ TidalService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        HttpResponse it = (HttpResponse)this.L$0;
                        if (!Intrinsics.areEqual((Object)it.getStatus(), (Object)HttpStatusCode.Companion.getOK())) {
                            this.this$0.onError("Error setting shuffle state");
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<HttpResponse, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull HttpResponse p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 7, null);
        return true;
    }

    @Override
    public boolean setRepeat(@NotNull RepeatState repeat) {
        Intrinsics.checkNotNullParameter((Object)((Object)repeat), (String)"repeat");
        State state = this.getState();
        if (state == null) {
            return false;
        }
        State state2 = state;
        if (state2.getPlayer().getRepeat() == repeat) {
            return true;
        }
        Http.post$default(Http.INSTANCE, Http.INSTANCE.plus(this.url, "/repeat/toggle"), null, null, null, (Function2)new Function2<HttpResponse, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ TidalService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        HttpResponse it = (HttpResponse)this.L$0;
                        if (!Intrinsics.areEqual((Object)it.getStatus(), (Object)HttpStatusCode.Companion.getOK())) {
                            this.this$0.onError("Error setting repeat state");
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<HttpResponse, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull HttpResponse p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 7, null);
        return true;
    }

    @Override
    public boolean setVolume(int volume, boolean notify) {
        return false;
    }

    @Override
    public boolean move(boolean forward) {
        if (this.getState() == null) {
            return false;
        }
        String action = forward ? "next" : "previous";
        Http.post$default(Http.INSTANCE, Http.INSTANCE.plus(this.url, action), null, null, null, (Function2)new Function2<HttpResponse, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ TidalService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        HttpResponse it = (HttpResponse)this.L$0;
                        if (!Intrinsics.areEqual((Object)it.getStatus(), (Object)HttpStatusCode.Companion.getOK())) {
                            this.this$0.onError("Error moving to next track");
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<HttpResponse, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull HttpResponse p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 7, null);
        return true;
    }

    @Override
    @NotNull
    public Set<ServiceFunction> getFunctions() {
        return TidalServiceKt.access$getFUNCTIONS$p();
    }

    public TidalService() {
        this(0, 1, null);
    }

    public static final /* synthetic */ Object access$requestPlayer(TidalService $this, Continuation $completion) {
        return $this.requestPlayer((Continuation<? super Unit>)$completion);
    }
}

