/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.electric_motor;

import com.mrh0.createaddition.blocks.electric_motor.ElectricMotorBlock;
import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoilBlock;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.sound.CASoundScapes;
import com.mrh0.createaddition.transfer.EnergyTransferable;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.motor.KineticScrollValueBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class ElectricMotorBlockEntity
extends GeneratingKineticBlockEntity
implements EnergyTransferable {
    protected ScrollValueBehaviour generatedSpeed;
    protected final InternalEnergyStorage energy = new InternalEnergyStorage((Long)Config.ELECTRIC_MOTOR_CAPACITY.get(), (Long)Config.ELECTRIC_MOTOR_MAX_INPUT.get(), 0L);
    private final LazyOptional<EnergyStorage> lazyEnergy = LazyOptional.of(() -> this.energy);
    private boolean cc_update_rpm = false;
    private int cc_new_rpm = 32;
    private boolean active = false;
    int cc_antiSpam = 0;
    boolean first = true;

    public ElectricMotorBlockEntity(class_2591<? extends ElectricMotorBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(20);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        CenteredSideValueBoxTransform slot = new CenteredSideValueBoxTransform((motor, side) -> motor.method_11654((class_2769)ElectricMotorBlock.FACING) == side.method_10153());
        this.generatedSpeed = new KineticScrollValueBehaviour((class_2561)Lang.translateDirect((String)"generic.speed", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)slot);
        this.generatedSpeed.between(-((Integer)Config.ELECTRIC_MOTOR_RPM_RANGE.get()).intValue(), ((Integer)Config.ELECTRIC_MOTOR_RPM_RANGE.get()).intValue());
        this.generatedSpeed.value = 32;
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation((int)i));
        behaviours.add((BlockEntityBehaviour)this.generatedSpeed);
    }

    public static int step(ScrollValueBehaviour.StepContext context) {
        int current = context.currentValue;
        int step = 1;
        if (!context.shift) {
            int magnitude = Math.abs(current) - (context.forward == current > 0 ? 0 : 1);
            if (magnitude >= 4) {
                step *= 4;
            }
            if (magnitude >= 32) {
                step *= 4;
            }
            if (magnitude >= 128) {
                step *= 4;
            }
        }
        return step;
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = (float)((Integer)Config.MAX_STRESS.get()).intValue() / 256.0f;
        return capacity;
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43471((String)"createaddition.tooltip.energy.consumption").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43470((String)(" " + Util.format(ElectricMotorBlockEntity.getEnergyConsumptionRate(this.generatedSpeed.getValue())) + "fe/t ")).method_27692(class_124.field_1075)).method_10852((class_2561)Lang.translateDirect((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).method_27692(class_124.field_1063)));
        return true;
    }

    public void updateGeneratedRotation(int i) {
        super.updateGeneratedRotation();
        this.cc_new_rpm = i;
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        if (!CABlocks.ELECTRIC_MOTOR.has(this.method_11010())) {
            return 0.0f;
        }
        return ElectricMotorBlockEntity.convertToDirection((float)(this.active ? (float)this.generatedSpeed.getValue() : 0.0f), (class_2350)((class_2350)this.method_11010().method_11654((class_2769)ElectricMotorBlock.FACING)));
    }

    protected class_2248 getStressConfigKey() {
        return (class_2248)AllBlocks.WATER_WHEEL.get();
    }

    public InternalEnergyStorage getEnergyStorage() {
        return this.energy;
    }

    @Override
    @Nullable
    public EnergyStorage getEnergyStorage(@Nullable class_2350 side) {
        return (EnergyStorage)this.lazyEnergy.getValueUnsafer();
    }

    public boolean isEnergyInput(class_2350 side) {
        return true;
    }

    public boolean isEnergyOutput(class_2350 side) {
        return false;
    }

    public void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.energy.read(compound);
        this.active = compound.method_10577("active");
    }

    public void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.energy.write(compound);
        compound.method_10556("active", this.active);
    }

    public void lazyTick() {
        super.lazyTick();
        this.cc_antiSpam = 5;
    }

    public static int getEnergyConsumptionRate(int rpm) {
        return Math.abs(rpm) > 0 ? (int)Math.max((double)((Integer)Config.FE_RPM.get()).intValue() * ((double)Math.abs(rpm) / 256.0), (double)((Integer)Config.ELECTRIC_MOTOR_MINIMUM_CONSUMPTION.get()).intValue()) : 0;
    }

    public void remove() {
        this.lazyEnergy.invalidate();
        super.remove();
    }

    public void tick() {
        super.tick();
        if (this.first) {
            this.updateGeneratedRotation();
            this.first = false;
        }
        if (this.cc_update_rpm && this.cc_antiSpam > 0) {
            this.generatedSpeed.setValue(this.cc_new_rpm);
            this.cc_update_rpm = false;
            --this.cc_antiSpam;
            this.updateGeneratedRotation();
        }
        if (this.field_11863.method_8608()) {
            return;
        }
        int con = ElectricMotorBlockEntity.getEnergyConsumptionRate(this.generatedSpeed.getValue());
        if (!this.active) {
            if (this.energy.getAmount() > (long)con * 2L && !((Boolean)this.method_11010().method_11654((class_2769)ElectricMotorBlock.POWERED)).booleanValue()) {
                this.active = true;
                this.updateGeneratedRotation();
            }
        } else {
            long ext = this.energy.internalConsumeEnergy(con);
            if (ext < (long)con || ((Boolean)this.method_11010().method_11654((class_2769)ElectricMotorBlock.POWERED)).booleanValue()) {
                this.active = false;
                this.updateGeneratedRotation();
            }
        }
    }

    public void tickAudio() {
        super.tickAudio();
        if (!this.active) {
            return;
        }
        if (((Boolean)Config.AUDIO_ENABLED.get()).booleanValue()) {
            CASoundScapes.play(CASoundScapes.AmbienceGroup.DYNAMO, this.field_11867, 1.0f);
        }
    }

    public static int getDurationAngle(int deg, float initialProgress, float speed) {
        speed = Math.abs(speed);
        deg = Math.abs(deg);
        if (speed < 0.1f) {
            return 0;
        }
        double degreesPerTick = speed * 360.0f / 60.0f / 20.0f;
        return (int)((double)((1.0f - initialProgress) * (float)deg) / degreesPerTick + 1.0);
    }

    public static int getDurationDistance(int dis, float initialProgress, float speed) {
        speed = Math.abs(speed);
        dis = Math.abs(dis);
        if (speed < 0.1f) {
            return 0;
        }
        double metersPerTick = speed / 512.0f;
        return (int)((double)((1.0f - initialProgress) * (float)dis) / metersPerTick);
    }

    public boolean setRPM(int rpm) {
        this.cc_new_rpm = rpm = Math.max(Math.min(rpm, (Integer)Config.ELECTRIC_MOTOR_RPM_RANGE.get()), -((Integer)Config.ELECTRIC_MOTOR_RPM_RANGE.get()).intValue());
        this.cc_update_rpm = true;
        return this.cc_antiSpam > 0;
    }

    public int getRPM() {
        return this.cc_new_rpm;
    }

    public int getGeneratedStress() {
        return (int)this.calculateAddedStressCapacity();
    }

    public int getEnergyConsumption() {
        return ElectricMotorBlockEntity.getEnergyConsumptionRate(this.generatedSpeed.getValue());
    }

    public boolean isPoweredState() {
        return (Boolean)this.method_11010().method_11654((class_2769)TeslaCoilBlock.POWERED);
    }
}

