/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.filter.premade;

import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.creativecore.common.util.CompoundSerializer;
import team.creative.creativecore.common.util.filter.Filter;

public class BlockFilters {
    public static Filter<class_2248> block(class_2248 block) {
        return new BlockFilter(block);
    }

    public static Filter<class_2248> blocks(class_2248 ... blocks) {
        return new BlocksFilter(blocks);
    }

    public static Filter<class_2248> instance(Class<? extends class_2248> clazz) {
        return new BlockClassFilter(clazz);
    }

    public static Filter<class_2248> and(Filter<class_2248> ... filters) {
        return Filter.and(filters);
    }

    public static Filter<class_2248> or(Filter<class_2248> ... filters) {
        return Filter.or(filters);
    }

    public static Filter<class_2248> not(Filter<class_2248> filter) {
        return Filter.not(filter);
    }

    public static Filter<class_2248> property(class_2769<?> property) {
        return new BlockPropertyFilter(property);
    }

    public static Filter<class_2248> tag(class_6862<class_2248> tag) {
        return new BlockTagFilter(tag);
    }

    static {
        Filter.SERIALIZER.register("block", BlockFilter.class);
        Filter.SERIALIZER.register("blocks", BlocksFilter.class);
        Filter.SERIALIZER.register("bclass", BlockClassFilter.class);
    }

    private static class BlockFilter
    implements Filter<class_2248>,
    CompoundSerializer {
        public final class_2248 block;

        public BlockFilter(class_2248 block) {
            this.block = block;
        }

        public BlockFilter(class_2487 nbt) {
            this.block = (class_2248)class_7923.field_41175.method_10223(new class_2960(nbt.method_10558("b")));
        }

        @Override
        public boolean is(class_2248 t) {
            return t == this.block;
        }

        @Override
        public class_2487 write() {
            class_2487 nbt = new class_2487();
            nbt.method_10582("b", class_7923.field_41175.method_10221((Object)this.block).toString());
            return nbt;
        }
    }

    private static class BlocksFilter
    implements Filter<class_2248>,
    CompoundSerializer {
        public final class_2248[] blocks;

        public BlocksFilter(class_2248 ... blocks) {
            this.blocks = blocks;
        }

        public BlocksFilter(class_2487 nbt) {
            class_2499 list = nbt.method_10554("b", 8);
            this.blocks = new class_2248[list.size()];
            for (int i = 0; i < this.blocks.length; ++i) {
                this.blocks[i] = (class_2248)class_7923.field_41175.method_10223(new class_2960(list.method_10608(i)));
            }
        }

        @Override
        public boolean is(class_2248 t) {
            return ArrayUtils.contains((Object[])this.blocks, (Object)t);
        }

        @Override
        public class_2487 write() {
            class_2487 nbt = new class_2487();
            class_2499 list = new class_2499();
            for (int i = 0; i < this.blocks.length; ++i) {
                list.add((Object)class_2519.method_23256((String)class_7923.field_41175.method_10221((Object)this.blocks[i]).toString()));
            }
            nbt.method_10566("b", (class_2520)list);
            return nbt;
        }
    }

    private static class BlockClassFilter
    implements Filter<class_2248>,
    CompoundSerializer {
        public final Class<? extends class_2248> clazz;

        public BlockClassFilter(Class<? extends class_2248> clazz) {
            this.clazz = clazz;
        }

        public BlockClassFilter(class_2487 nbt) {
            Class<?> temp = null;
            try {
                temp = Class.forName(nbt.method_10558("c"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.clazz = temp;
        }

        @Override
        public boolean is(class_2248 t) {
            return this.clazz != null && this.clazz.isInstance(t);
        }

        @Override
        public class_2487 write() {
            class_2487 nbt = new class_2487();
            nbt.method_10582("c", this.clazz.getName());
            return nbt;
        }
    }

    private record BlockPropertyFilter(class_2769<?> property) implements Filter<class_2248>
    {
        @Override
        public boolean is(class_2248 t) {
            return t.method_9564().method_28498(this.property);
        }
    }

    private record BlockTagFilter(class_6862<class_2248> tag) implements Filter<class_2248>
    {
        @Override
        public boolean is(class_2248 t) {
            return t.method_40142().method_40220(this.tag);
        }
    }
}

