/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.compat.adventurez;

import mod.crend.dynamiccrosshair.DynamicCrosshair;
import mod.crend.dynamiccrosshair.api.CrosshairContext;
import mod.crend.dynamiccrosshair.api.DynamicCrosshairApi;
import mod.crend.dynamiccrosshair.api.ItemCategory;
import mod.crend.dynamiccrosshair.component.Crosshair;
import mod.crend.dynamiccrosshair.config.UsableCrosshairPolicy;
import net.adventurez.block.ChiseledPolishedBlackstoneHolder;
import net.adventurez.block.entity.ChiseledPolishedBlackstoneHolderEntity;
import net.adventurez.entity.EnderWhaleEntity;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.TagInit;
import net.adventurez.item.BlackstoneGolemArm;
import net.adventurez.item.BlackstoneGolemHeart;
import net.adventurez.item.EnderFlute;
import net.adventurez.item.GildedBlackstoneShard;
import net.adventurez.item.Handbook;
import net.adventurez.item.PrimeEyeItem;
import net.adventurez.item.SourceStone;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class ApiImplAdventureZ
implements DynamicCrosshairApi {
    public String getNamespace() {
        return "adventurez";
    }

    public boolean isInteractableBlock(class_2680 blockState) {
        return blockState.method_26204() instanceof ChiseledPolishedBlackstoneHolder;
    }

    public Crosshair computeFromBlock(CrosshairContext context) {
        class_2586 class_25862;
        class_2680 blockState = context.getBlockState();
        class_2248 block = blockState.method_26204();
        if (block instanceof ChiseledPolishedBlackstoneHolder && (class_25862 = context.getBlockEntity()) instanceof ChiseledPolishedBlackstoneHolderEntity) {
            ChiseledPolishedBlackstoneHolderEntity blockEntity = (ChiseledPolishedBlackstoneHolderEntity)class_25862;
            class_1799 blockStack = blockEntity.method_5438(0);
            if (!blockStack.method_7960()) {
                return Crosshair.INTERACTABLE;
            }
            if ((context.getItemStack().method_31573(TagInit.HOLDER_ITEMS) || ConfigInit.CONFIG.allow_all_items_on_holder) && context.world.method_8320(context.getBlockPos().method_10084()).method_26215()) {
                return Crosshair.USABLE;
            }
        }
        return null;
    }

    public ItemCategory getItemCategory(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        if (item instanceof GildedBlackstoneShard && ConfigInit.CONFIG.allow_gilded_blackstone_shard_throw) {
            return ItemCategory.THROWABLE;
        }
        if (item instanceof PrimeEyeItem) {
            return ItemCategory.THROWABLE;
        }
        if (item instanceof BlackstoneGolemArm) {
            return ItemCategory.RANGED_WEAPON;
        }
        return super.getItemCategory(itemStack);
    }

    public boolean isAlwaysUsableItem(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        return item instanceof EnderFlute || item instanceof Handbook || item instanceof SourceStone;
    }

    public boolean isUsableItem(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        return item instanceof BlackstoneGolemHeart;
    }

    public Crosshair computeFromItem(CrosshairContext context) {
        class_1799 handItemStack = context.getItemStack();
        class_1792 item = handItemStack.method_7909();
        if (context.includeUsableItem() && item instanceof BlackstoneGolemHeart && context.player.method_5715()) {
            return Crosshair.USABLE;
        }
        if (context.includeThrowable()) {
            if (item instanceof GildedBlackstoneShard && ConfigInit.CONFIG.allow_gilded_blackstone_shard_throw && !context.player.method_5715()) {
                return Crosshair.THROWABLE;
            }
            if (item instanceof PrimeEyeItem && handItemStack.method_7919() <= handItemStack.method_7936() - 1) {
                return Crosshair.THROWABLE;
            }
        }
        if (context.includeRangedWeapon() && item instanceof BlackstoneGolemArm) {
            if (DynamicCrosshair.config.dynamicCrosshairHoldingRangedWeapon() == UsableCrosshairPolicy.Always) {
                return Crosshair.RANGED_WEAPON;
            }
            if (context.isRangedWeaponCharged(30)) {
                return Crosshair.RANGED_WEAPON;
            }
            return Crosshair.REGULAR;
        }
        return null;
    }

    public boolean isInteractableEntity(class_1297 entity) {
        return entity instanceof EnderWhaleEntity;
    }

    public Crosshair computeFromEntity(CrosshairContext context) {
        class_1297 entity = context.getEntity();
        if (entity instanceof EnderWhaleEntity) {
            EnderWhaleEntity enderWhale = (EnderWhaleEntity)entity;
            if (!context.player.method_21823()) {
                class_1792 item = context.getItem();
                if ((item == class_1802.field_8233 || item == class_1802.field_8882) && enderWhale.method_6063() - enderWhale.method_6032() > 0.1f) {
                    return Crosshair.USABLE;
                }
                if (!enderWhale.method_5782() || enderWhale.method_5685().size() < 2) {
                    return Crosshair.INTERACTABLE;
                }
            }
        }
        return null;
    }
}

