/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.compat.bewitchment;

import java.util.UUID;
import mod.crend.dynamiccrosshair.api.CrosshairContext;
import mod.crend.dynamiccrosshair.compat.mixin.bewitchment.BWTameableEntityAccessor;
import mod.crend.dynamiccrosshair.compat.mixin.bewitchment.SaltLineBlockAccessor;
import mod.crend.dynamiccrosshair.component.Crosshair;
import moriyashiine.bewitchment.api.BewitchmentAPI;
import moriyashiine.bewitchment.api.entity.Pledgeable;
import moriyashiine.bewitchment.common.block.BrambleBlock;
import moriyashiine.bewitchment.common.block.BrazierBlock;
import moriyashiine.bewitchment.common.block.CrystalBallBlock;
import moriyashiine.bewitchment.common.block.SaltLineBlock;
import moriyashiine.bewitchment.common.block.WitchCauldronBlock;
import moriyashiine.bewitchment.common.block.entity.LockableBlockEntity;
import moriyashiine.bewitchment.common.block.entity.interfaces.Lockable;
import moriyashiine.bewitchment.common.block.entity.interfaces.SigilHolder;
import moriyashiine.bewitchment.common.block.entity.interfaces.TaglockHolder;
import moriyashiine.bewitchment.common.entity.DemonMerchant;
import moriyashiine.bewitchment.common.entity.living.BaphometEntity;
import moriyashiine.bewitchment.common.entity.living.HerneEntity;
import moriyashiine.bewitchment.common.entity.living.LeonardEntity;
import moriyashiine.bewitchment.common.entity.living.LilithEntity;
import moriyashiine.bewitchment.common.entity.living.util.BWHostileEntity;
import moriyashiine.bewitchment.common.entity.living.util.BWTameableEntity;
import moriyashiine.bewitchment.common.item.AthameItem;
import moriyashiine.bewitchment.common.item.ChalkItem;
import moriyashiine.bewitchment.common.item.TaglockItem;
import moriyashiine.bewitchment.common.item.WaystoneItem;
import moriyashiine.bewitchment.common.item.util.BWBookItem;
import moriyashiine.bewitchment.common.misc.BWUtil;
import moriyashiine.bewitchment.common.recipe.AthameStrippingRecipe;
import moriyashiine.bewitchment.common.registry.BWObjects;
import moriyashiine.bewitchment.common.registry.BWProperties;
import moriyashiine.bewitchment.common.registry.BWRecipeTypes;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1752;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1807;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;

public class BewitchmentHandler {
    public static boolean isAlwaysUsableItem(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        return item instanceof BWBookItem || item instanceof WaystoneItem;
    }

    public static Crosshair computeFromItem(CrosshairContext context) {
        Lockable lockable;
        class_2586 blockEntity;
        class_2680 blockState;
        class_1799 itemStack = context.getItemStack();
        class_1792 item = itemStack.method_7909();
        if (item instanceof AthameItem && context.isWithBlock()) {
            blockState = context.getBlockState();
            AthameStrippingRecipe entry = context.world.method_8433().method_30027(BWRecipeTypes.ATHAME_STRIPPING_RECIPE_TYPE).stream().filter(recipe -> recipe.log == blockState.method_26204()).findFirst().orElse(null);
            if (entry != null) {
                return Crosshair.USABLE;
            }
            blockEntity = blockState.method_26204() instanceof class_2323 && blockState.method_11654((class_2769)class_2323.field_10946) == class_2756.field_12609 ? context.world.method_8321(context.getBlockPos().method_10074()) : context.getBlockEntity();
            if (blockEntity instanceof SigilHolder) {
                SigilHolder sigilHolder = (SigilHolder)blockEntity;
                if (context.player.method_5667().equals(sigilHolder.getOwner())) {
                    return Crosshair.USABLE;
                }
            } else if (blockEntity instanceof TaglockHolder) {
                TaglockHolder taglockHolder = (TaglockHolder)blockEntity;
                if (context.player.method_5667().equals(taglockHolder.getOwner())) {
                    return Crosshair.USABLE;
                }
            } else if (blockEntity instanceof Lockable) {
                lockable = (Lockable)blockEntity;
                if (context.player.method_5667().equals(lockable.getOwner()) && !lockable.getEntities().isEmpty()) {
                    return Crosshair.USABLE;
                }
            }
        }
        if (item instanceof ChalkItem && context.isWithBlock()) {
            class_1750 placementContext = new class_1750((class_1937)context.world, (class_1657)context.player, context.getHand(), itemStack, context.getBlockHitResult());
            class_2338 pos = context.getBlockPos();
            if (!context.world.method_8320(pos).method_26166(placementContext)) {
                pos = pos.method_10093(context.getBlockHitSide());
            }
            if (context.world.method_8320(pos).method_26166(placementContext)) {
                return Crosshair.HOLDING_BLOCK;
            }
        }
        if (item instanceof TaglockItem && context.isWithBlock()) {
            blockState = context.getBlockState();
            if (blockState.method_26204() instanceof class_2244) {
                if (context.player.method_5715()) {
                    return Crosshair.USABLE;
                }
            } else {
                class_1799 stack = context.getItemStack();
                blockEntity = blockState.method_26204() instanceof class_2323 && blockState.method_11654((class_2769)class_2323.field_10946) == class_2756.field_12609 ? context.world.method_8321(context.getBlockPos().method_10074()) : context.getBlockEntity();
                if (blockEntity instanceof TaglockHolder) {
                    int firstEmpty;
                    TaglockHolder taglockHolder = (TaglockHolder)blockEntity;
                    if (context.player.method_5667().equals(taglockHolder.getOwner()) && (firstEmpty = taglockHolder.getFirstEmptySlot()) != -1) {
                        return Crosshair.USABLE;
                    }
                } else if (blockEntity instanceof Lockable) {
                    lockable = (Lockable)blockEntity;
                    if (TaglockItem.hasTaglock((class_1799)stack) && context.player.method_5667().equals(lockable.getOwner()) && lockable.getLocked()) {
                        UUID uuid = TaglockItem.getTaglockUUID((class_1799)stack);
                        if (!lockable.getEntities().contains(uuid)) {
                            return Crosshair.USABLE;
                        }
                    }
                } else if (blockEntity instanceof SigilHolder && TaglockItem.hasTaglock((class_1799)stack)) {
                    return Crosshair.USABLE;
                }
            }
        }
        return null;
    }

    public static boolean isAlwaysInteractableBlock(class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        return block instanceof CrystalBallBlock || block == BWObjects.GOLDEN_GLYPH;
    }

    public static boolean isInteractableBlock(class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        return block instanceof BrazierBlock || block instanceof SaltLineBlock || block instanceof WitchCauldronBlock;
    }

    public static Crosshair computeFromBlock(CrosshairContext context) {
        LockableBlockEntity lockable;
        class_2680 blockState = context.getBlockState();
        class_2248 block = blockState.method_26204();
        class_1799 itemStack = context.getItemStack();
        class_2586 class_25862 = context.getBlockEntity();
        if (class_25862 instanceof LockableBlockEntity && !(lockable = (LockableBlockEntity)class_25862).test((class_1297)context.player)) {
            return Crosshair.NONE.withFlag(Crosshair.Flag.FixedModifierUse);
        }
        if (block instanceof BrambleBlock.Fruiting) {
            if (((Boolean)blockState.method_11654((class_2769)BWProperties.HAS_FRUIT)).booleanValue()) {
                return Crosshair.INTERACTABLE;
            }
            if (itemStack.method_7909() instanceof class_1752) {
                return Crosshair.USABLE;
            }
        }
        if (block instanceof BrazierBlock && !((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            if (((Boolean)blockState.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                return Crosshair.INTERACTABLE;
            }
            if (!itemStack.method_7960()) {
                return Crosshair.USABLE;
            }
            return Crosshair.INTERACTABLE;
        }
        if (block instanceof SaltLineBlock) {
            class_2680 placementState;
            SaltLineBlock saltLineBlock = (SaltLineBlock)block;
            if (context.player.method_31549().field_7476 && (SaltLineBlockAccessor.invokeIsFullyConnected(blockState) || SaltLineBlockAccessor.invokeIsNotConnected(blockState)) && (placementState = ((SaltLineBlockAccessor)saltLineBlock).invokeGetPlacementState((class_1922)context.world, context.getBlockPos())) != blockState) {
                return Crosshair.INTERACTABLE;
            }
        }
        if (block instanceof WitchCauldronBlock && (itemStack.method_7909() instanceof class_1807 && itemStack.method_7938() || itemStack.method_31574(class_1802.field_8550) || itemStack.method_31574(class_1802.field_8705) || itemStack.method_31574(class_1802.field_8469) || itemStack.method_31574(class_1802.field_8574) && class_1844.method_8063((class_1799)itemStack) == class_1847.field_8991)) {
            return Crosshair.USABLE;
        }
        return null;
    }

    public static boolean isInteractableEntity(class_1297 entity) {
        return entity instanceof DemonMerchant || entity instanceof Pledgeable && !(entity instanceof LeonardEntity);
    }

    public static Crosshair computeFromEntity(CrosshairContext context) {
        LilithEntity lilith;
        HerneEntity herne;
        class_1297 entity = context.getEntity();
        class_1799 itemStack = context.getItemStack();
        if (entity instanceof BWTameableEntity) {
            BWTameableEntity tameableEntity = (BWTameableEntity)entity;
            if (tameableEntity.method_6481(itemStack)) {
                if (tameableEntity.method_6032() < tameableEntity.method_6063()) {
                    return Crosshair.USABLE;
                }
            } else if (!tameableEntity.method_6181()) {
                if (((BWTameableEntityAccessor)tameableEntity).invokeIsTamingItem(itemStack)) {
                    return Crosshair.USABLE;
                }
            } else if (tameableEntity.method_6171((class_1309)context.player)) {
                return Crosshair.INTERACTABLE;
            }
        }
        if (entity instanceof BWHostileEntity) {
            BWHostileEntity trader = (BWHostileEntity)entity;
            if (entity instanceof DemonMerchant) {
                BaphometEntity baphomet;
                DemonMerchant merchant = (DemonMerchant)entity;
                if (entity instanceof BaphometEntity && !BewitchmentAPI.isPledged((class_1657)context.player, (String)(baphomet = (BaphometEntity)entity).getPledgeID())) {
                    return null;
                }
                if (trader.method_5805() && trader.method_5968() == null) {
                    if (BWUtil.rejectTrades((class_1309)trader)) {
                        return null;
                    }
                    if (!merchant.getOffers().isEmpty()) {
                        return Crosshair.INTERACTABLE;
                    }
                }
            }
        }
        if (entity instanceof HerneEntity && (herne = (HerneEntity)entity).method_5805() && herne.method_5968() == null && BewitchmentAPI.isWerewolf((class_1297)context.player, (boolean)true) && itemStack.method_31574(BWObjects.ACONITE)) {
            return Crosshair.USABLE;
        }
        if (entity instanceof LilithEntity && (lilith = (LilithEntity)entity).method_5805() && lilith.method_5968() == null && BewitchmentAPI.isVampire((class_1297)context.player, (boolean)true) && itemStack.method_31574(BWObjects.GARLIC)) {
            return Crosshair.USABLE;
        }
        return null;
    }
}

