/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.compat.extended_drawers;

import io.github.mattidragon.extendeddrawers.block.AccessPointBlock;
import io.github.mattidragon.extendeddrawers.block.ShadowDrawerBlock;
import io.github.mattidragon.extendeddrawers.block.base.StorageDrawerBlock;
import io.github.mattidragon.extendeddrawers.block.entity.ShadowDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.block.entity.StorageDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.item.LimiterItem;
import io.github.mattidragon.extendeddrawers.item.UpgradeItem;
import io.github.mattidragon.extendeddrawers.misc.DrawerRaycastUtil;
import io.github.mattidragon.extendeddrawers.registry.ModItems;
import mod.crend.dynamiccrosshair.api.CrosshairContext;
import mod.crend.dynamiccrosshair.api.DynamicCrosshairApi;
import mod.crend.dynamiccrosshair.component.Crosshair;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;

public class ApiImplExtendedDrawers
implements DynamicCrosshairApi {
    public String getNamespace() {
        return "extended_drawers";
    }

    public boolean forceInvalidate(CrosshairContext context) {
        return context.isWithBlock() && context.getBlock() instanceof StorageDrawerBlock;
    }

    private <T extends StorageDrawerBlockEntity> int getClickedSlot(StorageDrawerBlock<T> drawerBlock, CrosshairContext context) {
        class_2680 blockState = context.getBlockState();
        class_241 clickedPosition = DrawerRaycastUtil.calculateFaceLocation((class_2338)context.getBlockPos(), (class_243)context.hitResult.method_17784(), (class_2350)context.getBlockHitSide(), (class_2350)((class_2350)blockState.method_11654((class_2769)StorageDrawerBlock.FACING)), (class_2738)((class_2738)blockState.method_11654((class_2769)StorageDrawerBlock.FACE)));
        StorageDrawerBlockEntity drawer = (StorageDrawerBlockEntity)context.getBlockEntity();
        return drawerBlock.getSlotIndex(drawer, clickedPosition);
    }

    private <T extends StorageDrawerBlockEntity> StorageView<ItemVariant> getClickedSlotContents(StorageDrawerBlock<T> drawerBlock, CrosshairContext context) {
        return drawerBlock.getSlot((StorageDrawerBlockEntity)context.getBlockEntity(), this.getClickedSlot(drawerBlock, context));
    }

    public boolean isUsableItem(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        return item instanceof UpgradeItem || item instanceof LimiterItem || item == ModItems.LOCK;
    }

    public Crosshair computeFromItem(CrosshairContext context) {
        StorageDrawerBlock drawerBlock;
        class_2680 blockState;
        class_2248 block;
        class_1792 item = context.getItem();
        if (context.isWithBlock() && context.player.method_5715() && (item instanceof UpgradeItem || item instanceof LimiterItem || item == ModItems.LOCK) && (block = (blockState = context.getBlockState()).method_26204()) instanceof StorageDrawerBlock && (drawerBlock = (StorageDrawerBlock)block).isFront(blockState, context.getBlockHitSide()) && context.player.method_7294()) {
            return Crosshair.USABLE;
        }
        return null;
    }

    public boolean isInteractableBlock(class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        return block instanceof StorageDrawerBlock || block instanceof AccessPointBlock || block instanceof ShadowDrawerBlock;
    }

    public Crosshair computeFromBlock(CrosshairContext context) {
        StorageDrawerBlock drawerBlock;
        class_2680 blockState = context.getBlockState();
        class_1799 handItemStack = context.getItemStack();
        class_2248 block = blockState.method_26204();
        if (context.isOffHand()) {
            return null;
        }
        if (block instanceof StorageDrawerBlock && (drawerBlock = (StorageDrawerBlock)block).isFront(blockState, context.getBlockHitSide()) && context.player.method_7294() && context.getBlockEntity() instanceof StorageDrawerBlockEntity) {
            StorageView<ItemVariant> storage = this.getClickedSlotContents(drawerBlock, context);
            ItemVariant storedItem = (ItemVariant)storage.getResource();
            if (!context.player.method_5715()) {
                if (handItemStack.method_7960()) {
                    if (!storage.isResourceBlank()) {
                        return Crosshair.INTERACTABLE;
                    }
                } else if (storedItem.isBlank() || storedItem.getItem() == handItemStack.method_7909()) {
                    return Crosshair.USABLE;
                }
            }
        }
        if (block instanceof AccessPointBlock) {
            if (handItemStack.method_7960()) {
                return Crosshair.INTERACTABLE;
            }
            return Crosshair.USABLE;
        }
        if (block instanceof ShadowDrawerBlock) {
            drawerBlock = (ShadowDrawerBlock)block;
            if (context.isMainHand() && drawerBlock.isFront(blockState, context.getBlockHitSide())) {
                ShadowDrawerBlockEntity drawerBlockEntity = (ShadowDrawerBlockEntity)context.getBlockEntity();
                if (context.player.method_5715()) {
                    if (handItemStack.method_7960()) {
                        return Crosshair.INTERACTABLE;
                    }
                } else if (handItemStack.method_7960()) {
                    if (!drawerBlockEntity.item.isBlank()) {
                        return Crosshair.INTERACTABLE;
                    }
                } else if (drawerBlockEntity.item.isBlank() || drawerBlockEntity.item.getItem() == handItemStack.method_7909()) {
                    return Crosshair.USABLE;
                }
            }
        }
        return null;
    }
}

