/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.compat.kibe;

import io.github.lucaargolo.kibe.blocks.bigtorch.BigTorch;
import io.github.lucaargolo.kibe.blocks.breaker.Breaker;
import io.github.lucaargolo.kibe.blocks.chunkloader.ChunkLoader;
import io.github.lucaargolo.kibe.blocks.cooler.Cooler;
import io.github.lucaargolo.kibe.blocks.drawbridge.Drawbridge;
import io.github.lucaargolo.kibe.blocks.entangledchest.EntangledChest;
import io.github.lucaargolo.kibe.blocks.entangledtank.EntangledTank;
import io.github.lucaargolo.kibe.blocks.entangledtank.EntangledTankEntity;
import io.github.lucaargolo.kibe.blocks.miscellaneous.BlockGenerator;
import io.github.lucaargolo.kibe.blocks.miscellaneous.CursedDirt;
import io.github.lucaargolo.kibe.blocks.miscellaneous.FluidHopper;
import io.github.lucaargolo.kibe.blocks.miscellaneous.RedstoneTimer;
import io.github.lucaargolo.kibe.blocks.placer.Placer;
import io.github.lucaargolo.kibe.blocks.tank.Tank;
import io.github.lucaargolo.kibe.blocks.trashcan.TrashCan;
import io.github.lucaargolo.kibe.blocks.vacuum.VacuumHopper;
import io.github.lucaargolo.kibe.blocks.witherbuilder.WitherBuilder;
import io.github.lucaargolo.kibe.items.cooler.CoolerBlockItem;
import io.github.lucaargolo.kibe.items.entangledbag.EntangledBag;
import io.github.lucaargolo.kibe.items.entangledbucket.EntangledBucket;
import io.github.lucaargolo.kibe.items.miscellaneous.BooleanItem;
import io.github.lucaargolo.kibe.items.miscellaneous.CursedSeeds;
import io.github.lucaargolo.kibe.items.miscellaneous.Glider;
import io.github.lucaargolo.kibe.items.miscellaneous.Lasso;
import io.github.lucaargolo.kibe.items.miscellaneous.PocketCraftingTable;
import io.github.lucaargolo.kibe.items.miscellaneous.Rune;
import io.github.lucaargolo.kibe.items.miscellaneous.SleepingBag;
import io.github.lucaargolo.kibe.items.miscellaneous.VoidBucket;
import io.github.lucaargolo.kibe.items.miscellaneous.WoodenBucket;
import io.github.lucaargolo.kibe.items.trashcan.PocketTrashCan;
import mod.crend.dynamiccrosshair.api.CrosshairContext;
import mod.crend.dynamiccrosshair.api.DynamicCrosshairApi;
import mod.crend.dynamiccrosshair.component.Crosshair;
import mod.crend.dynamiccrosshair.fabric.api.CrosshairFluidContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2402;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3737;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class ApiImplKibe
implements DynamicCrosshairApi {
    public String getNamespace() {
        return "kibe";
    }

    public Crosshair computeFromBlock(CrosshairContext context) {
        class_2680 blockState = context.getBlockState();
        class_2248 block = blockState.method_26204();
        if (block instanceof BigTorch || block instanceof Breaker || block instanceof Cooler || block instanceof Drawbridge || block instanceof BlockGenerator || block instanceof RedstoneTimer || block instanceof Placer || block instanceof Tank || block instanceof TrashCan || block instanceof VacuumHopper || block instanceof WitherBuilder) {
            return Crosshair.INTERACTABLE;
        }
        if (block instanceof ChunkLoader && ((Boolean)blockState.method_11654((class_2769)class_2741.field_12515)).booleanValue()) {
            return Crosshair.INTERACTABLE;
        }
        if (block instanceof EntangledChest || block instanceof EntangledTank) {
            class_1792 item;
            if (context.hitResult.method_17784().method_10214() - (double)context.getBlockPos().method_10264() > 0.9375 && ((item = context.getItem()) instanceof Rune || item == class_1802.field_8477 || item == class_1802.field_8695)) {
                return Crosshair.USABLE;
            }
            if (block instanceof EntangledChest) {
                if (EntangledChest.Companion.canOpen((class_1937)context.world, context.getBlockPos())) {
                    return Crosshair.INTERACTABLE;
                }
            } else {
                EntangledTankEntity blockEntity;
                class_2586 class_25862 = context.getBlockEntity();
                if (class_25862 instanceof EntangledTankEntity && CrosshairFluidContext.canInteractWithFluidStorage((CrosshairContext)context, (Storage)(blockEntity = (EntangledTankEntity)class_25862).getTank())) {
                    return Crosshair.USABLE;
                }
            }
        }
        if (block instanceof CursedDirt && context.isMainHand() && context.player.method_5715()) {
            return Crosshair.INTERACTABLE;
        }
        if (block instanceof FluidHopper) {
            return Crosshair.INTERACTABLE;
        }
        return null;
    }

    public boolean isAlwaysUsableItem(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        return item instanceof EntangledBag || item instanceof Glider || item instanceof PocketCraftingTable || item instanceof PocketTrashCan;
    }

    public boolean isUsableItem(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        return item instanceof CoolerBlockItem || item instanceof EntangledBucket || item instanceof BooleanItem || item instanceof CursedSeeds || item instanceof Lasso || item instanceof SleepingBag;
    }

    public Crosshair computeFromItem(CrosshairContext context) {
        class_2248 block;
        if (!context.includeUsableItem()) {
            return null;
        }
        class_1799 itemStack = context.getItemStack();
        class_1792 item = itemStack.method_7909();
        if (item instanceof CoolerBlockItem && (!context.isWithBlock() || context.player.method_5715())) {
            return Crosshair.USABLE;
        }
        if (item instanceof EntangledBucket) {
            if (context.isWithBlock() && context.player.method_5715() && context.getBlock() instanceof EntangledTank) {
                return Crosshair.USABLE;
            }
            class_2487 tag = EntangledBucket.Companion.getTag(itemStack);
            StringBuilder colorCode = new StringBuilder();
            for (int i = 1; i <= 8; ++i) {
                class_1767 dc = class_1767.method_7793((String)tag.method_10558("rune" + i), (class_1767)class_1767.field_7952);
                colorCode.append(Integer.toHexString(dc.method_7789()));
            }
            tag.method_10582("colorCode", colorCode.toString());
            SingleVariantStorage fluidInv = EntangledBucket.Companion.getFluidInv((class_1937)context.world, tag);
            class_3611 fluid = fluidInv.isResourceBlank() ? class_3612.field_15906 : ((FluidVariant)fluidInv.getResource()).getFluid();
            boolean hasSpace = fluidInv.getAmount() + 81000L <= fluidInv.getCapacity();
            boolean hasBucket = fluidInv.getAmount() >= 81000L;
            class_3965 hitResult = context.raycastWithFluid(hasSpace ? class_3959.class_242.field_1345 : class_3959.class_242.field_1348);
            if (hitResult != null) {
                boolean isBucket;
                boolean bl = isBucket = context.player.method_5715() || fluid.method_15774() == class_1802.field_8550;
                if (isBucket && hasSpace) {
                    return Crosshair.USABLE;
                }
                class_2350 dir = hitResult.method_17780();
                class_2338 pos = hitResult.method_17777();
                class_2338 offsetPos = pos.method_10093(dir);
                if (context.player.method_7343(offsetPos, dir, itemStack)) {
                    class_2338 interactablePos;
                    class_2680 interactableBlockState;
                    class_2680 blockState = context.world.method_8320(pos);
                    if (blockState.method_26204() instanceof class_2263) {
                        if (hasSpace) {
                            return Crosshair.USABLE;
                        }
                    } else if (hasBucket && (!((interactableBlockState = context.world.method_8320(interactablePos = blockState.method_26204() instanceof class_2402 && fluid == class_3612.field_15910 ? pos : offsetPos)).method_26204() instanceof class_2263) || interactableBlockState.method_28498((class_2769)class_2741.field_12538) && (Integer)interactableBlockState.method_11654((class_2769)class_2741.field_12538) != 0)) {
                        return Crosshair.HOLDING_BLOCK;
                    }
                }
            }
        }
        if (item instanceof BooleanItem && context.player.method_5715()) {
            return Crosshair.USABLE;
        }
        if (item instanceof CursedSeeds && context.isWithBlock() && ((block = context.getBlock()) == class_2246.field_10566 || block == class_2246.field_10219) && context.world.method_22339(context.getBlockPos()) <= 7) {
            return Crosshair.USABLE;
        }
        if (item instanceof Lasso) {
            class_1297 entity;
            Lasso lasso = (Lasso)item;
            if (context.isWithEntity() ? itemStack.method_7985() && !itemStack.method_7969().method_10545("Entity") && (entity = context.getEntity()) instanceof class_1308 && lasso.canStoreEntity(entity.method_5864()) : context.isWithBlock() && itemStack.method_7985() && itemStack.method_7969().method_10545("Entity")) {
                return Crosshair.USABLE;
            }
        }
        if (item instanceof SleepingBag && (context.isWithBlock() || context.player.method_24828())) {
            return Crosshair.USABLE;
        }
        if (item instanceof VoidBucket) {
            class_2680 fluidBlockState;
            class_3965 fluidHitResult;
            if (context.isWithBlock() && context.getBlock() instanceof class_2263) {
                return Crosshair.USABLE;
            }
            if (!context.isWithEntity() && (fluidHitResult = context.raycastWithFluid(class_3959.class_242.field_1345)).method_17783() != class_239.class_240.field_1333 && (fluidBlockState = context.world.method_8320(fluidHitResult.method_17777())).method_26204() instanceof class_2263) {
                return Crosshair.USABLE;
            }
        }
        if (item instanceof WoodenBucket) {
            WoodenBucket bucket = (WoodenBucket)item;
            if (bucket.getFluid() == class_3612.field_15906) {
                class_2680 fluidBlockState;
                class_3965 fluidHitResult;
                if (context.isWithBlock() && context.getBlock() instanceof class_2263) {
                    return Crosshair.USABLE;
                }
                if (!context.isWithEntity() && (fluidHitResult = context.raycastWithFluid(class_3959.class_242.field_1345)).method_17783() != class_239.class_240.field_1333 && (fluidBlockState = context.world.method_8320(fluidHitResult.method_17777())).method_26204() instanceof class_2263) {
                    return Crosshair.USABLE;
                }
            } else if (context.isWithBlock()) {
                if (context.getBlock() instanceof class_3737 && bucket.getFluid() == class_3612.field_15910) {
                    return Crosshair.USABLE;
                }
                return Crosshair.HOLDING_BLOCK;
            }
        }
        return null;
    }
}

