/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.api;

import java.util.List;
import mod.crend.dynamiccrosshair.DynamicCrosshair;
import mod.crend.dynamiccrosshair.api.ApiList;
import mod.crend.dynamiccrosshair.api.DynamicCrosshairApi;
import mod.crend.dynamiccrosshair.api.InvalidContextState;
import mod.crend.dynamiccrosshair.config.BlockCrosshairPolicy;
import mod.crend.dynamiccrosshair.config.CrosshairPolicy;
import mod.crend.dynamiccrosshair.config.UsableCrosshairPolicy;
import mod.crend.dynamiccrosshair.mixin.BlockItemAccessor;
import mod.crend.dynamiccrosshair.mixin.ItemAccessor;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public class CrosshairContext {
    @NotNull
    public class_638 world;
    @NotNull
    public final class_746 player;
    @NotNull
    public class_239 hitResult;
    private boolean withBlock = false;
    private class_2338 blockPos = null;
    private class_2680 blockState = null;
    private class_2586 blockEntity = null;
    private boolean withEntity = false;
    private class_1297 entity = null;
    private class_1268 hand;
    private class_1799 itemStackMainHand = null;
    private class_1799 itemStackOffHand = null;
    private ApiList apiList = null;

    public CrosshairContext() {
        assert (class_310.method_1551().field_1687 != null);
        assert (class_310.method_1551().field_1724 != null);
        assert (class_310.method_1551().field_1765 != null);
        this.world = class_310.method_1551().field_1687;
        this.player = class_310.method_1551().field_1724;
        this.hand = class_1268.field_5808;
        this.hitResult = class_310.method_1551().field_1765;
        this.invalidateHitResult(this.hitResult);
    }

    public void invalidateHitResult(class_239 newHitResult) {
        assert (newHitResult != null);
        assert (class_310.method_1551().field_1687 != null);
        this.hitResult = newHitResult;
        this.withBlock = false;
        this.blockPos = null;
        this.blockState = null;
        this.blockEntity = null;
        this.withEntity = false;
        this.entity = null;
        this.apiList = null;
        this.itemStackMainHand = null;
        this.itemStackOffHand = null;
        switch (this.hitResult.method_17783()) {
            case field_1332: {
                class_3965 blockHitResult = (class_3965)this.hitResult;
                this.withBlock = true;
                this.blockPos = blockHitResult.method_17777();
                break;
            }
            case field_1331: {
                class_3966 entityHitResult = (class_3966)this.hitResult;
                this.withEntity = true;
                this.entity = entityHitResult.method_17782();
            }
        }
        this.world = class_310.method_1551().field_1687;
        for (DynamicCrosshairApi api : this.apis()) {
            try {
                class_638 useWorld = api.overrideWorld();
                if (useWorld == null) continue;
                this.world = useWorld;
                break;
            }
            catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | RuntimeException throwable) {
            }
        }
    }

    public void invalidateItem(class_1268 hand) {
        switch (hand) {
            case field_5808: {
                this.itemStackMainHand = null;
                break;
            }
            case field_5810: {
                this.itemStackOffHand = null;
            }
        }
    }

    public boolean isTargeting() {
        return this.hitResult.method_17783() != class_239.class_240.field_1333;
    }

    public boolean isEmptyHanded() {
        return this.player.method_6047().method_7960() && this.player.method_6079().method_7960();
    }

    public boolean shouldInteract() {
        return !this.player.method_21823() || this.isEmptyHanded();
    }

    public boolean isWithBlock() {
        return this.withBlock;
    }

    public class_2338 getBlockPos() {
        return this.blockPos;
    }

    public class_2680 getBlockState() {
        if (!this.withBlock) {
            throw new InvalidContextState("Called getBlockState() without a targeted block!");
        }
        if (this.blockPos == null) {
            throw new InvalidContextState("In getBlockState(): blockPos is null despite targeted block!");
        }
        if (this.blockState == null) {
            this.blockState = this.world.method_8320(this.blockPos);
        }
        return this.blockState;
    }

    public class_2248 getBlock() {
        return this.getBlockState().method_26204();
    }

    public class_2586 getBlockEntity() {
        if (!this.withBlock) {
            throw new InvalidContextState("Called getBlockEntity() without a targeted block!");
        }
        if (this.blockPos == null) {
            throw new InvalidContextState("In getBlockEntity(): blockPos is null despite targeted block!");
        }
        if (this.blockEntity == null) {
            this.blockEntity = this.world.method_8321(this.blockPos);
        }
        return this.blockEntity;
    }

    public class_3610 getFluidState() {
        if (!this.withBlock) {
            throw new InvalidContextState("Called getFluidState() without a targeted block!");
        }
        if (this.blockPos == null) {
            throw new InvalidContextState("In getFluidState(): blockPos is null despite targeted block!");
        }
        return this.world.method_8316(this.blockPos);
    }

    public class_3965 getBlockHitResult() {
        if (!this.withBlock) {
            throw new InvalidContextState("Called getFluidState() without a targeted block!");
        }
        return (class_3965)this.hitResult;
    }

    public class_2350 getBlockHitSide() {
        return this.getBlockHitResult().method_17780();
    }

    public class_3965 raycastWithFluid(class_3959.class_242 fluidHandling) {
        return ItemAccessor.invokeRaycast((class_1937)this.world, (class_1657)this.player, fluidHandling);
    }

    public class_3965 raycastWithFluid() {
        return this.raycastWithFluid(class_3959.class_242.field_1347);
    }

    public class_3966 raycastForEntity(double d) {
        class_243 vCamPos = this.player.method_5836(1.0f);
        class_243 vRotation = this.player.method_5828(1.0f);
        class_243 vRaycast = vCamPos.method_1031(vRotation.field_1352 * d, vRotation.field_1351 * d, vRotation.field_1350 * d);
        class_238 box = this.player.method_5829().method_18804(vRotation.method_1021(d)).method_1009(1.0, 1.0, 1.0);
        return class_1675.method_18075((class_1297)this.player, (class_243)vCamPos, (class_243)vRaycast, (class_238)box, entity -> !entity.method_7325() && entity.method_30948(), (double)(d * d));
    }

    public boolean isWithEntity() {
        return this.withEntity;
    }

    public class_1297 getEntity() {
        if (!this.withEntity) {
            throw new InvalidContextState("Called getEntity() without a targeted entity!");
        }
        if (this.entity == null) {
            throw new InvalidContextState("In getEntity(): entity is null despite targeted entity!");
        }
        return this.entity;
    }

    public class_1268 getHand() {
        return this.hand;
    }

    public void setHand(class_1268 hand) {
        this.hand = hand;
    }

    public boolean isMainHand() {
        return this.hand == class_1268.field_5808;
    }

    public boolean isOffHand() {
        return this.hand == class_1268.field_5810;
    }

    public class_1799 getItemStack(class_1268 hand) {
        class_1799 itemStack;
        switch (hand) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case field_5808: {
                class_1799 class_17992 = this.itemStackMainHand;
                break;
            }
            case field_5810: {
                class_1799 class_17992 = itemStack = this.itemStackOffHand;
            }
        }
        if (itemStack == null) {
            itemStack = this.player.method_5998(hand);
            switch (hand) {
                case field_5808: {
                    this.itemStackMainHand = itemStack;
                    break;
                }
                case field_5810: {
                    this.itemStackOffHand = itemStack;
                }
            }
        }
        return itemStack;
    }

    public class_1799 getItemStack() {
        return this.getItemStack(this.hand);
    }

    public class_1792 getItem() {
        return this.getItemStack().method_7909();
    }

    public boolean isActiveItem() {
        return this.player.method_6030().equals(this.getItemStack());
    }

    public boolean isCoolingDown() {
        return this.player.method_7357().method_7904(this.getItem());
    }

    public boolean canPlaceItemAsBlock() {
        if (!this.withBlock) {
            throw new InvalidContextState("Called canPlaceItemAsBlock() without a targeted block!");
        }
        BlockItemAccessor blockItem = (BlockItemAccessor)this.getItem();
        class_1750 itemPlacementContext = new class_1750((class_1657)this.player, this.hand, this.getItemStack(), (class_3965)this.hitResult);
        try {
            class_2680 blockState = blockItem.invokeGetPlacementState(itemPlacementContext);
            return blockState != null && blockItem.invokeCanPlace(itemPlacementContext, blockState);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean canUseWeaponAsTool() {
        return this.isWithBlock() && DynamicCrosshair.config.dynamicCrosshairHoldingTool() != CrosshairPolicy.Disabled;
    }

    public boolean isRangedWeaponCharged(int bound) {
        return this.isActiveItem() && this.getItem().method_7881(this.getItemStack()) - this.player.method_6014() >= bound;
    }

    public boolean includeUsableItem() {
        return switch (DynamicCrosshair.config.dynamicCrosshairHoldingUsableItem()) {
            default -> throw new IncompatibleClassChangeError();
            case UsableCrosshairPolicy.Always -> true;
            case UsableCrosshairPolicy.IfInteractable -> {
                if (!this.isCoolingDown()) {
                    yield true;
                }
                yield false;
            }
            case UsableCrosshairPolicy.Disabled -> false;
        };
    }

    public boolean includeThrowable() {
        return switch (DynamicCrosshair.config.dynamicCrosshairHoldingThrowable()) {
            default -> throw new IncompatibleClassChangeError();
            case UsableCrosshairPolicy.Always -> true;
            case UsableCrosshairPolicy.IfInteractable -> {
                if (!this.isCoolingDown()) {
                    yield true;
                }
                yield false;
            }
            case UsableCrosshairPolicy.Disabled -> false;
        };
    }

    public boolean includeRangedWeapon() {
        return DynamicCrosshair.config.dynamicCrosshairHoldingRangedWeapon() != UsableCrosshairPolicy.Disabled;
    }

    public boolean includeMeleeWeapon() {
        return this.isMainHand() && DynamicCrosshair.config.dynamicCrosshairHoldingMeleeWeapon();
    }

    public boolean includeTool() {
        boolean bl;
        block7: {
            block6: {
                if (!this.isMainHand()) break block6;
                switch (DynamicCrosshair.config.dynamicCrosshairHoldingTool()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Always: {
                        break;
                    }
                    case IfTargeting: {
                        if (this.isTargeting()) {
                            break;
                        }
                        break block6;
                    }
                    case Disabled: {
                        break block6;
                    }
                }
                bl = true;
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    public boolean includeShield() {
        return DynamicCrosshair.config.dynamicCrosshairHoldingShield();
    }

    public boolean includeHoldingBlock() {
        return switch (DynamicCrosshair.config.dynamicCrosshairHoldingBlock()) {
            default -> throw new IncompatibleClassChangeError();
            case BlockCrosshairPolicy.Always, BlockCrosshairPolicy.IfInteractable -> true;
            case BlockCrosshairPolicy.IfTargeting -> this.isTargeting();
            case BlockCrosshairPolicy.Disabled -> false;
        };
    }

    public List<DynamicCrosshairApi> apis() {
        if (this.apiList == null) {
            this.apiList = new ApiList();
            this.apiList.add(this.getItemStack(class_1268.field_5808));
            this.apiList.add(this.getItemStack(class_1268.field_5810));
            if (this.isWithBlock()) {
                this.apiList.add(this.getBlockState());
            }
            if (this.isWithEntity()) {
                this.apiList.add(this.getEntity());
            }
        }
        return this.apiList.get();
    }
}

