/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import mod.crend.dynamiccrosshair.AutoHudCompat;
import mod.crend.dynamiccrosshair.DynamicCrosshair;
import mod.crend.dynamiccrosshair.component.Crosshair;
import mod.crend.dynamiccrosshair.component.CrosshairHandler;
import mod.crend.dynamiccrosshair.config.CrosshairColor;
import mod.crend.dynamiccrosshair.config.CrosshairModifier;
import net.minecraft.class_332;

public class CrosshairRenderer {
    public static boolean autoHudCompat = false;

    private static void setColor(CrosshairColor color) {
        int argb = color.getColor();
        float alpha = (float)(argb >> 24 & 0xFF) / 255.0f;
        if (autoHudCompat) {
            alpha *= AutoHudCompat.getAlpha();
        }
        RenderSystem.setShaderColor((float)((float)(argb >> 16 & 0xFF) / 255.0f), (float)((float)(argb >> 8 & 0xFF) / 255.0f), (float)((float)(argb & 0xFF) / 255.0f), (float)alpha);
        if (color.forced() || autoHudCompat) {
            RenderSystem.defaultBlendFunc();
        } else {
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        }
    }

    public static void preRender() {
        CrosshairRenderer.setColor(DynamicCrosshair.config.getColor());
    }

    public static void render(class_332 context, int x, int y) {
        Crosshair crosshair = CrosshairHandler.getActiveCrosshair();
        if (crosshair.hasStyle()) {
            crosshairStyle = crosshair.getCrosshairStyle();
            CrosshairRenderer.setColor(crosshairStyle.getColor());
            context.method_25302(CrosshairHandler.crosshairTexture, x, y, crosshairStyle.getStyle().getX(), crosshairStyle.getStyle().getY(), 15, 15);
        } else if (CrosshairHandler.forceShowCrosshair) {
            crosshairStyle = Crosshair.REGULAR.getCrosshairStyle();
            CrosshairRenderer.setColor(crosshairStyle.getColor());
            context.method_25302(CrosshairHandler.crosshairTexture, x, y, crosshairStyle.getStyle().getX(), crosshairStyle.getStyle().getY(), 15, 15);
        }
        for (CrosshairModifier modifier : crosshair.getModifiers()) {
            CrosshairRenderer.setColor(modifier.getColor());
            context.method_25302(CrosshairHandler.crosshairTexture, x, y, modifier.getStyle().getX(), modifier.getStyle().getY(), 15, 15);
        }
    }

    public static void postRender() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
    }
}

